/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.promotionCentre.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellDetail;
import java.io.Serializable;
import java.util.List;

public class CalSaleReturnIn
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JSONField(name="bill_detail")
    BillDetail billDetail;
    @JSONField(name="calc_mode")
    String calcMode;
    @JSONField(name="calc_billid")
    String calcBillid;

    public String getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(String calcMode) {
        this.calcMode = calcMode;
    }

    public String getCalcBillid() {
        return this.calcBillid;
    }

    public void setCalcBillid(String calcBillid) {
        this.calcBillid = calcBillid;
    }

    public BillDetail getBillDetail() {
        return this.billDetail;
    }

    public void setBillDetail(BillDetail billDetail) {
        this.billDetail = billDetail;
    }

    public CalSaleReturnIn(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        List<Goods> goodsList = cacheModel.getGoodsList();
        this.setCalcMode("0");
        this.setCalcBillid(null);
        BillDetail billDetail = Order.transferBillDetail(order);
        billDetail.setReturnMode(cacheModel.getOrder().getSysPara().getDeductMode());
        billDetail.setSellDetails(Goods.transferSellDetail(goodsList, order, false));
        this.setBillDetail(billDetail);
    }

    public static BillDetail buildBillDetail(CacheModel cacheModel, List<SellDetail> sellDetails) {
        BillDetail billDetail = new BillDetail();
        billDetail.setSellDetails(sellDetails);
        return billDetail;
    }

    public static SellDetail transfer(Goods goods, Order order, int index) {
        SellDetail sellDetail = new SellDetail();
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setBrand(goods.getBrand());
        sellDetail.setCategory(goods.getCategory());
        sellDetail.setContract(order.getShopCode());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setFlag(goods.getFlag());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setKlm("");
        sellDetail.setListAmount(goods.getListPrice());
        sellDetail.setManaUnit(order.getErpCode());
        sellDetail.setMarket(order.getShopCode());
        sellDetail.setOriginalBillNo(order.getOriginIdSheetNo());
        sellDetail.setOriginalRowNo(goods.getFlowId());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setRowNo(index);
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setSupplier("");
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setUnitcode(goods.getSaleUnit());
        return sellDetail;
    }
}

