/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.promotionCentre.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.CouponGain;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellDetail;
import java.util.ArrayList;

public class CalcIn {
    @JSONField(name="calc_mode")
    private String calcMode;
    @JSONField(name="bill_detail")
    private BillDetail billDetail;
    @JSONField(name="calc_billid")
    private String calcBillid;

    public String getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(String calcMode) {
        this.calcMode = calcMode;
    }

    public BillDetail getBillDetail() {
        return this.billDetail;
    }

    public void setBillDetail(BillDetail billDetail) {
        this.billDetail = billDetail;
    }

    public String getCalcBillid() {
        return this.calcBillid;
    }

    public void setCalcBillid(String calcBillid) {
        this.calcBillid = calcBillid;
    }

    public void fromCacheModel(CacheModel cacheModel, boolean isNewCalcId, boolean isRemoveAdjustDisc, boolean isNeedPopDetail) {
        Order order = cacheModel.getOrder();
        this.calcMode = order.getCalcMarketingMode();
        this.calcBillid = !isNewCalcId ? order.getSeqNo() : null;
        this.billDetail = Order.transferBillDetail(order);
        this.billDetail.setSellPayments(Payment.transferSellPayment(cacheModel.getPayments(), SellType.ISBACK(order.getOrderType())));
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : cacheModel.getGoodsList()) {
            SellDetail sellDetail = this.goodsToSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, isNeedPopDetail);
            sellDetails.add(sellDetail);
        }
        this.billDetail.setSellDetails(sellDetails);
    }

    public void fromCacheModel(CacheModel cacheModel, boolean isNewCalcId, boolean isRemoveAdjustDisc) {
        this.fromCacheModel(cacheModel, isNewCalcId, isRemoveAdjustDisc, false);
    }

    public SellDetail goodsToSellDetail(Goods goods, Order order, boolean isRemoveAdjustDisc, boolean isNewCalcId, boolean isNeedPopDetail) {
        SellDetail sellDetail = Goods.transferSellDetail(goods, order, isRemoveAdjustDisc, isNewCalcId, isNeedPopDetail);
        sellDetail.setCouponGains(CouponGain.transferSellCouponGain(goods.getCouponGains()));
        return sellDetail;
    }
}

