/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.promotionCentre.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.efuture.pos.component.common.YPopStatusType;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.promotionCentre.BillDetailSimple;
import com.efuture.pos.model.promotionCentre.SellDetail;
import com.efuture.pos.model.promotionCentre.SellPopDetail;
import com.efuture.pos.model.request.QueryGoodIn;
import com.efuture.pos.model.request.SkuSearchIn;
import com.efuture.pos.util.ManipulatePrecision;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CalcSimpleTagIn {
    @JSONField(name="bill_detail")
    private BillDetailSimple billDetail;
    private String fields;

    public BillDetailSimple getBillDetail() {
        return this.billDetail;
    }

    public void setBillDetail(BillDetailSimple billDetail) {
        this.billDetail = billDetail;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public static CalcSimpleTagIn transfer(QueryGoodIn queryGoodIn, Goods goods) {
        BillDetailSimple billDetailSimple = new BillDetailSimple();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetailSimple.setChannel(queryGoodIn.getChannel());
        billDetailSimple.setSaleDate(format.format(new Date()));
        billDetailSimple.setMarket(queryGoodIn.getShopCode());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
        sellDetail.setManaUnit(queryGoodIn.getErpCode());
        if (null != goods.getSGoodsSno() && goods.getSGoodsSno().length() > 0) {
            sellDetail.setFlag("3");
        }
        if ("Y".equals(goods.getEscaleFlag())) {
            sellDetail.setFlag("D");
        }
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(queryGoodIn.getShopCode());
        sellDetail.setContract(queryGoodIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrand());
        sellDetail.setCategory(goods.getCategory());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetail.setKlm("M");
        sellDetail.setCounter(goods.getSeason());
        if (ManipulatePrecision.doubleCompare(goods.getBarcodeDiscount(), 0.0, 2) > 0) {
            SellPopDetail sellPopDetail = new SellPopDetail();
            sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getBarcodeDiscount(), 6, 1));
            sellPopDetail.setPopMode("0");
            sellPopDetail.setPopDescribe("\u6761\u7801\u4f18\u60e0");
            sellPopDetail.setRowNo(goods.getFlowId());
            if (goods.getDisMode() == 3) {
                sellPopDetail.setPrcMode("6");
                sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discA);
                sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeA);
            } else if (goods.getDisMode() == 1) {
                sellPopDetail.setPrcMode("6");
                sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeB);
            } else if (goods.getDisMode() == 2) {
                sellPopDetail.setDiscountAmount(0.0);
                sellPopDetail.setPrcMode("5");
                sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                sellPopDetail.setPopEventType(YPopStatusType.pop_type_barcodeB);
                sellPopDetail.setDiscountRate(ManipulatePrecision.doubleConvert(1.0 - goods.getDisValue()));
            }
            sellDetail.getSellPopDetails().add(sellPopDetail);
        }
        sellDetails.add(sellDetail);
        billDetailSimple.setSellDetails(sellDetails);
        billDetailSimple.setConsumersType("01");
        CalcSimpleTagIn calcSimpleTagIn = new CalcSimpleTagIn();
        calcSimpleTagIn.setBillDetail(billDetailSimple);
        return calcSimpleTagIn;
    }

    public static CalcSimpleTagIn transfer(SkuSearchIn skuQueryIn, Goods goods) {
        BillDetailSimple billDetailSimple = new BillDetailSimple();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetailSimple.setChannel("" + skuQueryIn.getChannel());
        billDetailSimple.setSaleDate(format.format(new Date()));
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setManaUnit(skuQueryIn.getErpCode());
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(skuQueryIn.getShopCode());
        sellDetail.setContract(skuQueryIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrand());
        sellDetail.setCategory(goods.getCategory());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetailSimple.setSellDetails(sellDetails);
        billDetailSimple.setConsumersType("01");
        CalcSimpleTagIn calcSimpleTagIn = new CalcSimpleTagIn();
        calcSimpleTagIn.setBillDetail(billDetailSimple);
        return calcSimpleTagIn;
    }
}

