/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.promotionCentre.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.efuture.pos.component.common.YPopStatusType;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.PopDetail;
import com.efuture.pos.model.mainDataCentre.GoodsInfo;
import com.efuture.pos.model.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.pos.model.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellConsData;
import com.efuture.pos.model.promotionCentre.SellDetail;
import com.efuture.pos.model.promotionCentre.SellPopDetail;
import com.efuture.pos.model.request.AddBatchGoodsIn;
import com.efuture.pos.model.request.QueryGoodIn;
import com.efuture.pos.model.request.SkuSearchIn;
import com.efuture.pos.util.ManipulatePrecision;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CalcsingleIn {
    @JSONField(name="calc_mode")
    private String calcMode;
    @JSONField(name="bill_detail")
    private BillDetail billDetail;
    @JSONField(name="calc_billid")
    private String calcBillid;

    public String getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(String calcMode) {
        this.calcMode = calcMode;
    }

    public BillDetail getBillDetail() {
        return this.billDetail;
    }

    public void setBillDetail(BillDetail billDetail) {
        this.billDetail = billDetail;
    }

    public String getCalcBillid() {
        return this.calcBillid;
    }

    public void setCalcBillid(String calcBillid) {
        this.calcBillid = calcBillid;
    }

    public static CalcsingleIn build(Goods goods, SkuSearchIn skuSearchIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel("" + skuSearchIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(skuSearchIn.getShopCode());
        billDetail.setTermNo(skuSearchIn.getTerminalNo());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (null != goods.getSGoodsSno() && goods.getSGoodsSno().length() > 0) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(skuSearchIn.getShopCode());
        sellDetail.setContract(skuSearchIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrand());
        sellDetail.setCategory(goods.getCategory());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getAdjustDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(skuSearchIn.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn build(GoodsInfo goods, GetGoodsDetailIn skuSearchIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel("" + skuSearchIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(skuSearchIn.getShopCode());
        billDetail.setTermNo(skuSearchIn.getTerminalNo());
        billDetail.setConsumersType("01");
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setRowNo(1);
        sellDetail.setFlag("1");
        if ("9".equals(goods.getGoodsType())) {
            sellDetail.setFlag("3");
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(skuSearchIn.getShopCode());
        sellDetail.setContract(skuSearchIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getPartsUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrandId());
        sellDetail.setCategory(goods.getCategoryCode());
        sellDetail.setQty(1.0);
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSalePrice());
        sellDetail.setSaleAmount(goods.getSalePrice());
        sellDetail.setManaUnit(skuSearchIn.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn build(Goods goods, QueryGoodIn queryGoodIn) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = new BillDetail();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        billDetail.setChannel(queryGoodIn.getChannel());
        billDetail.setSaleDate(format.format(new Date()));
        billDetail.setTermInvoiceNo(1L);
        billDetail.setMarket(queryGoodIn.getShopCode());
        billDetail.setTermNo(queryGoodIn.getTerminalNo());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setSellPopDetails(new ArrayList<SellPopDetail>());
        sellDetail.setRowNo(goods.getFlowId());
        sellDetail.setFlag(goods.getFlag());
        if (null != goods.getSGoodsSno() && goods.getSGoodsSno().length() > 0) {
            sellDetail.setFlag("3");
        }
        if ("Y".equals(goods.getEscaleFlag())) {
            sellDetail.setFlag("D");
        }
        sellDetail.setKlm(goods.getKlm());
        sellDetail.setOriginalRowNo(1);
        sellDetail.setGz(goods.getOrgCode());
        sellDetail.setMarket(queryGoodIn.getShopCode());
        sellDetail.setContract(queryGoodIn.getShopCode());
        sellDetail.setItemCode(goods.getGoodsCode());
        sellDetail.setItemName(goods.getGoodsName());
        sellDetail.setBarcode(goods.getBarNo());
        sellDetail.setUnitcode(goods.getSaleUnit());
        sellDetail.setFactor(goods.getPartsNum());
        sellDetail.setBrand(goods.getBrand());
        sellDetail.setCategory(goods.getCategory());
        sellDetail.setQty(goods.getQty());
        sellDetail.setPrice(goods.getSalePrice());
        sellDetail.setListAmount(goods.getSaleValue());
        sellDetail.setTotalDiscount(goods.getTotalDiscountValue());
        sellDetail.setSaleAmount(goods.getSaleAmount());
        sellDetail.setNojf(goods.getNojf());
        sellDetail.setManaUnit(queryGoodIn.getErpCode());
        sellDetail.setSupplier(goods.getVenderId());
        sellDetail.setCounter(goods.getSeason());
        if (goods.getEWCCodeAmount() > 0.0 || goods.getEWCCodeNum() > 0.0) {
            sellDetail.setQty(1.0);
        }
        if (ManipulatePrecision.doubleCompare(goods.getBarcodeDiscount(), 0.0, 2) > 0) {
            SellPopDetail sellPopDetail = new SellPopDetail();
            sellPopDetail.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getBarcodeDiscount(), 6, 1));
            sellPopDetail.setPopMode("0");
            sellPopDetail.setPopDescribe("[\u6761\u7801\u4f18\u60e0]");
            sellPopDetail.setRowNo(goods.getFlowId());
            if (goods.getDisMode() == 3) {
                sellPopDetail.setPrcMode("6");
                sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discA);
                sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeA);
                sellPopDetail.setPopDescribe("[\u6761\u7801\u4f18\u60e0]");
            } else if (goods.getDisMode() == 1) {
                sellPopDetail.setPrcMode("6");
                sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                sellPopDetail.setPopPolicyType(YPopStatusType.pop_type_barcodeB);
            } else if (goods.getDisMode() == 2) {
                sellPopDetail.setDiscountAmount(0.0);
                sellPopDetail.setPrcMode("5");
                sellPopDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_barcode_discB);
                sellPopDetail.setPopEventType(YPopStatusType.pop_type_barcodeB);
                sellPopDetail.setDiscountRate(ManipulatePrecision.doubleConvert(1.0 - goods.getDisValue()));
            }
            sellDetail.getSellPopDetails().add(sellPopDetail);
        }
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn buildAddGoodsCalc(ServiceSession session, AddBatchGoodsIn in, GetGoodsDetailOut goodsDetail, String consumersId, String qty) {
        GoodsInfo goodsInfo = goodsDetail.getGoods().get(0);
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode(in.getCalcMode());
        BillDetail billDetail = new BillDetail();
        billDetail.setConsumersCardNo(consumersId);
        billDetail.setConsumersId(in.getConsumersId());
        billDetail.setConsumersType(in.getConsumersType());
        SellConsData sellConsData = new SellConsData();
        ArrayList<String> consumersGrps = new ArrayList<String>();
        consumersGrps.add(in.getConsumersTrgs());
        sellConsData.setConsumersGrps(consumersGrps);
        billDetail.setConsumersData(sellConsData);
        billDetail.setBillNo(in.getFlowNo());
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail sellDetail = new SellDetail();
        sellDetail.setQty(new Integer(qty).intValue());
        sellDetail.setPrice(goodsInfo.getSalePrice());
        sellDetail.setBarcode(goodsInfo.getBarNo());
        sellDetail.setMarket(in.getShopCode());
        sellDetails.add(sellDetail);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn buildGetSaleGoodsInfoCalc(ServiceSession session, String calcMode, Goods goods, Order order, boolean isRefreshBillId, boolean isNeedPopDetail) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode(calcMode);
        BillDetail billDetail = Order.transferBillDetail(order);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        SellDetail transferSellDetail = Goods.transferSellDetail(goods, order, false, true, isNeedPopDetail);
        sellDetails.add(transferSellDetail);
        if (!isRefreshBillId) {
            calcsingleIn.setCalcBillid(order.getSeqNo());
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        return calcsingleIn;
    }

    public static CalcsingleIn buildGetSaleGoodsInfoCalc(ServiceSession session, String calcMode, Goods goods, Order order, boolean isRefreshBillId) {
        return CalcsingleIn.buildGetSaleGoodsInfoCalc(session, calcMode, goods, order, isRefreshBillId, false);
    }

    public static CalcsingleIn buildAddBatchGoodsCalc(ServiceSession session, List<Goods> goodsList, Order order) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        calcsingleIn.setCalcMode("0");
        BillDetail billDetail = Order.transferBillDetail(order);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : goodsList) {
            goods.setPopDetailsInfo(new ArrayList<PopDetail>());
            SellDetail transferSellDetail = Goods.transferSellDetail(goods, order, true, false);
            sellDetails.add(transferSellDetail);
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        calcsingleIn.setCalcBillid("");
        return calcsingleIn;
    }

    public static CalcsingleIn memberLoginCreateCalcsingleIn(Order order, List<Goods> goodsList) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        BillDetail billDetail = Order.transferBillDetail(order);
        List<SellDetail> sellDetails = Goods.transferSellDetail(goodsList, order, false);
        for (Goods goods : goodsList) {
            for (SellDetail sellDetail : sellDetails) {
                if (goods.getFlowId() != sellDetail.getRowNo()) continue;
                sellDetail.setSellPopDetails(PopDetail.transferSellPopDetail(goods.getPopDetailsInfo(), order, goods));
            }
        }
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        calcsingleIn.setCalcMode(order.getCalcMarketingMode());
        calcsingleIn.setCalcBillid(order.getSeqNo());
        calcsingleIn.setCalcMode("0");
        calcsingleIn.calcBillid = "";
        return calcsingleIn;
    }

    public static CalcsingleIn terminalSnoChangeCreateCalcsingleIn(Order order, List<Goods> goodsList) {
        CalcsingleIn calcsingleIn = new CalcsingleIn();
        BillDetail billDetail = Order.transferBillDetail(order);
        List<SellDetail> sellDetails = Goods.transferSellDetail(goodsList, order, true, true);
        billDetail.setSellDetails(sellDetails);
        calcsingleIn.setBillDetail(billDetail);
        calcsingleIn.setCalcMode(order.getCalcMarketingMode());
        calcsingleIn.setCalcBillid(order.getSeqNo());
        calcsingleIn.setCalcMode("0");
        calcsingleIn.calcBillid = "";
        return calcsingleIn;
    }
}

