/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.promotionCentre.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellDetail;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class CouponGainCalcIn {
    @JSONField(name="calc_mode")
    private String calcMode;
    @JSONField(name="bill_detail")
    private BillDetail billDetail;
    @JSONField(name="calc_billid")
    private String calcBillid;

    public String getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(String calcMode) {
        this.calcMode = calcMode;
    }

    public BillDetail getBillDetail() {
        return this.billDetail;
    }

    public void setBillDetail(BillDetail billDetail) {
        this.billDetail = billDetail;
    }

    public String getCalcBillid() {
        return this.calcBillid;
    }

    public void setCalcBillid(String calcBillid) {
        this.calcBillid = calcBillid;
    }

    public void fromCacheModel(CacheModel cacheModel) {
        Order order = cacheModel.getOrder();
        cacheModel.getOrder().setCalcMarketingMode("0");
        this.calcMode = cacheModel.getOrder().getCalcMarketingMode();
        if (SellType.ISEXERCISE(cacheModel.getOrder().getOrderType())) {
            this.calcMode = "PRE";
        }
        this.calcBillid = order.getSeqNo();
        this.billDetail = Order.transferBillDetail(order);
        ArrayList<SellDetail> sellDetails = new ArrayList<SellDetail>();
        for (Goods goods : cacheModel.getGoodsList()) {
            SellDetail sellDetail = this.goodsToSellDetail(goods, order);
            sellDetails.add(sellDetail);
        }
        this.billDetail.setSellDetails(sellDetails);
        if (!SellType.ISBACK(order.getOrderType()) || SellType.ISBACK(order.getOrderType()) && StringUtils.isBlank((String)order.getOriginTerminalSno())) {
            this.billDetail.setSellPayments(Payment.transferSellPayment(cacheModel.getPayments(), SellType.ISBACK(order.getOrderType())));
        } else {
            this.billDetail.setSellPayments(Payment.transferSellPaymentForReturn(cacheModel));
        }
    }

    public SellDetail goodsToSellDetail(Goods goods, Order order) {
        SellDetail sellDetail = Goods.transferSellDetail(goods, order, false, false);
        return sellDetail;
    }
}

