/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.promotionCentre.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.efuture.pos.model.CouponGain;
import com.efuture.pos.model.CouponUse;
import com.efuture.pos.model.Gift;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.PopDetail;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellDetail;
import com.efuture.pos.model.promotionCentre.SellExceptPay;
import com.efuture.pos.model.promotionCentre.SellGift;
import java.util.ArrayList;
import java.util.List;

public class CalcOut {
    @JSONField(name="calc_result")
    private String calcResult;
    @JSONField(name="calc_billid")
    private String calcBillid;
    @JSONField(name="bill_detail")
    private BillDetail billDetail;
    @JSONField(name="freight_pop_m ode")
    private String freightPopMode;
    @JSONField(name="freight_pop_a mount")
    private String freightPopAmount;
    @JSONField(name="pop_lose")
    private String popLose;
    @JSONField(name="except_pays")
    private List<SellExceptPay> exceptPays;
    @JSONField(name="gifts")
    private List<SellGift> sellGifts;

    public String getCalcResult() {
        return this.calcResult;
    }

    public void setCalcResult(String calcResult) {
        this.calcResult = calcResult;
    }

    public String getCalcBillid() {
        return this.calcBillid;
    }

    public void setCalcBillid(String calcBillid) {
        this.calcBillid = calcBillid;
    }

    public BillDetail getBillDetail() {
        return this.billDetail;
    }

    public void setBillDetail(BillDetail billDetail) {
        this.billDetail = billDetail;
    }

    public String getFreightPopMode() {
        return this.freightPopMode;
    }

    public void setFreightPopMode(String freightPopMode) {
        this.freightPopMode = freightPopMode;
    }

    public String getFreightPopAmount() {
        return this.freightPopAmount;
    }

    public void setFreightPopAmount(String freightPopAmount) {
        this.freightPopAmount = freightPopAmount;
    }

    public String getPopLose() {
        return this.popLose;
    }

    public void setPopLose(String popLose) {
        this.popLose = popLose;
    }

    public List<SellExceptPay> getExceptPays() {
        return this.exceptPays;
    }

    public void setExceptPays(List<SellExceptPay> exceptPays) {
        this.exceptPays = exceptPays;
    }

    public List<SellGift> getGifts() {
        return this.sellGifts;
    }

    public void setGifts(List<SellGift> sellGifts) {
        this.sellGifts = sellGifts;
    }

    private List<Goods> gainGoodsList(List<Goods> goodsList, List<SellDetail> sellDetails) {
        for (Goods g : goodsList) {
            for (SellDetail s : sellDetails) {
                if (g.getFlowId() != s.getRowNo()) continue;
                g.setSalePrice(s.getPrice());
                g.setSaleValue(s.getListAmount());
                g.setSaleAmount(s.getSaleAmount());
                g.setPopDetailsInfo(PopDetail.transferPopDetail2(s.getSellPopDetails()));
                g.setCouponUses(CouponUse.transferCouponUse(s.getCouponUses()));
                g.setCouponGains(CouponGain.transferCouponGain(s.getCouponGains(), g.getFlowId()));
            }
        }
        return goodsList;
    }

    private List<Gift> gainGiftDetails(List<SellGift> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<Gift> gifts = new ArrayList<Gift>();
        for (SellGift g : list) {
            Gift gift = new Gift();
            gift.setMode(g.getMode());
            gift.setRelate(g.getRelate());
            gift.setCode(g.getCode());
            gift.setName(g.getName());
            gift.setCodeMode(g.getCodeMode());
            gift.setPrcMode(g.getPrcMode());
            gift.setPopLsj(g.getPoplsj());
            gift.setBaseQty(g.getBaseQty());
            gift.setLimitQty(g.getLimitQty());
            gift.setMaxQty(g.getMaxQty());
            gift.setExtjjg(g.getExtjjg());
            gift.setSeqNo(g.getSeqNo());
            gift.setEventId(g.getEventId());
            gift.setPolicyId(g.getPolicyId());
            gift.setGroup(g.getGroup());
            gift.setGroupSelect(g.getGroupSelect());
            gift.setCodeJson(g.getCodeJson());
            gift.setJoinMode(g.getJoinMode());
            gift.setLocalinputsl(g.getLocalInputSl());
            gift.setLocalrulememo(g.getLocalRuleMemo());
            gifts.add(gift);
        }
        return gifts;
    }
}

