/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.request;

import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.model.AbstractInModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.PosField;
import com.efuture.pos.model.zhongbai.response.ZhongbaiData;
import com.efuture.pos.model.zhongbai.response.ZhongbaiFund;
import com.efuture.pos.util.UUIDUtils;
import java.util.ArrayList;
import java.util.List;

public class ZhongbaiPayRefundIn
extends AbstractInModel {
    private static final long serialVersionUID = 1L;
    @PosField(describe="\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801")
    private String payCode;
    @PosField(describe="\u4ed8\u6b3e\u7c7b\u578b")
    private String payType;
    @PosField(describe="\u5c0f\u7968\u53f7", allowNull=true)
    private String terminalSno;
    @PosField(describe="\u539f\u5546\u6237\u4ea4\u6613\u53f7")
    private String orgOrderNo;
    @PosField(describe="\u5546\u6237\u9000\u6b3e\u53f7")
    private String refundNo;
    @PosField(describe="\u539f\u5355\u652f\u4ed8\u65f6\u95f4", allowNull=true)
    private String originalCreateTime;
    @PosField(describe="\u539f\u5355\u652f\u4ed8\u91d1\u989d", allowNull=true)
    private double money;
    @PosField(describe="\u9000\u6b3e\u91d1\u989d")
    private double refundMoney;
    @PosField(describe="\u6c47\u7387")
    private double rate;
    @PosField(describe="\u56db\u820d\u4e94\u5165\u7cbe\u5ea6")
    private String precision;
    @PosField(describe="\u56db\u820d\u4e94\u5165\u65b9\u5f0f")
    private String cutMode;

    @Override
    public AbstractInModel transfer(JSONObject jsonParams) {
        return null;
    }

    public String getPayCode() {
        return this.payCode;
    }

    public void setPayCode(String payCode) {
        this.payCode = payCode;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getTerminalSno() {
        return this.terminalSno;
    }

    public void setTerminalSno(String terminalSno) {
        this.terminalSno = terminalSno;
    }

    public String getOrgOrderNo() {
        return this.orgOrderNo;
    }

    public void setOrgOrderNo(String orgOrderNo) {
        this.orgOrderNo = orgOrderNo;
    }

    public String getRefundNo() {
        return this.refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public String getCutMode() {
        return this.cutMode;
    }

    public void setCutMode(String cutMode) {
        this.cutMode = cutMode;
    }

    public String getOriginalCreateTime() {
        return this.originalCreateTime;
    }

    public void setOriginalCreateTime(String originalCreateTime) {
        this.originalCreateTime = originalCreateTime;
    }

    public double getMoney() {
        return this.money;
    }

    public void setMoney(double money) {
        this.money = money;
    }

    public double getRefundMoney() {
        return this.refundMoney;
    }

    public void setRefundMoney(double refundMoney) {
        this.refundMoney = refundMoney;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public String toString() {
        return "ZhongbaiPayRefundIn [payCode=" + this.payCode + ", payType=" + this.payType + ", terminalSno=" + this.terminalSno + ", orgOrderNo=" + this.orgOrderNo + ", refundNo=" + this.refundNo + ", originalCreateTime=" + this.originalCreateTime + ", money=" + this.money + ", refundMoney=" + this.refundMoney + ", rate=" + this.rate + ", precision=" + this.precision + ", cutMode=" + this.cutMode + "]";
    }

    public static Payment creatPreRefungPayment(ZhongbaiPayRefundIn in, CacheModel order) {
        Payment payment = new Payment();
        payment.setPuid(UUIDUtils.buildPuid());
        payment.setRownoId(payment.getPuid());
        payment.setPayCode(in.getPayCode());
        payment.setPayType(in.getPayType());
        payment.setMoney(in.getMoney());
        payment.setAmount(in.getRefundMoney());
        payment.setRate(in.getRate());
        payment.setPrecision(in.getPrecision());
        payment.setFlag("1");
        payment.setTerminalNo(in.getTerminalNo());
        payment.setTerminalSno(in.getTerminalSno());
        payment.setRowno(order.getPayments().size() + 1);
        payment.setPrcutMode(in.getCutMode());
        return payment;
    }

    public static List<Payment> creatRefundPayment(Payment refundTemp, ZhongbaiData data) {
        ArrayList<Payment> payments = new ArrayList<Payment>();
        refundTemp.setRefCode(data.getRefundNo());
        List<ZhongbaiFund> funds = data.getFunds();
        for (int i = 0; i < funds.size(); ++i) {
            Payment pay = (Payment)refundTemp.clone();
            pay.setPuid(UUIDUtils.buildPuid());
            pay.setRownoId(pay.getPuid());
            pay.setPayNo(funds.get(i).getPayno());
            pay.setPayName(funds.get(i).getName());
            pay.setPayCode(funds.get(i).getCode());
            pay.setRowno(pay.getRowno() + i);
            pay.setAmount((double)funds.get(i).getJe() * 0.01);
            pay.setMoney(Double.valueOf((double)funds.get(i).getJe() * 0.01) * pay.getRate());
            pay.setBatchNo(funds.get(i).getBatch());
            payments.add(pay);
        }
        return payments;
    }
}

