/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.request;

import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.model.AbstractInModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.PosField;
import com.efuture.pos.model.zhongbai.response.ZhongbaiData;
import com.efuture.pos.model.zhongbai.response.ZhongbaiFund;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.UUIDUtils;
import java.util.ArrayList;
import java.util.List;

public class ZhongbaiSaleQueryIn
extends AbstractInModel {
    private static final long serialVersionUID = 1L;
    @PosField(describe="\u67e5\u8be2\u7c7b\u578b")
    private String queryType;
    @PosField(describe="\u5c0f\u7968\u53f7")
    private String idSheetNo;
    @PosField(describe="\u5916\u90e8\u6d41\u6c34\u53f7")
    private String orderNo;
    @PosField(describe="\u9000\u6b3e\u5355\u53f7", allowNull=true)
    private String refundNo;
    @PosField(describe="\u652f\u4ed8\u91d1\u989d")
    private double money;
    @PosField(describe="\u6c47\u7387")
    private double rate;
    @PosField(describe="\u56db\u6368\u4e94\u5165\u7cbe\u5ea6")
    private String precision;
    @PosField(describe="\u4ed8\u6b3e\u5927\u985e")
    private String payType;
    @PosField(describe="\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801")
    private String payCode;
    @PosField(describe="\u56db\u820d\u4e94\u5165\u65b9\u5f0f")
    private String cutMode;

    @Override
    public AbstractInModel transfer(JSONObject jsonParams) {
        return null;
    }

    public String getIdSheetNo() {
        return this.idSheetNo;
    }

    public void setIdSheetNo(String idSheetNo) {
        this.idSheetNo = idSheetNo;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getRefundNo() {
        return this.refundNo;
    }

    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public double getMoney() {
        return this.money;
    }

    public void setMoney(double money) {
        this.money = money;
    }

    public double getRate() {
        return this.rate;
    }

    public void setRate(double rate) {
        this.rate = rate;
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
    }

    public String getPayCode() {
        return this.payCode;
    }

    public void setPayCode(String payCode) {
        this.payCode = payCode;
    }

    public String getCutMode() {
        return this.cutMode;
    }

    public void setCutMode(String cutMode) {
        this.cutMode = cutMode;
    }

    public static Payment creatPrePayment(ZhongbaiSaleQueryIn in, CacheModel order) {
        Payment payment = new Payment();
        payment.setPuid(UUIDUtils.buildPuid());
        payment.setRownoId(payment.getPuid());
        payment.setPayCode(in.getPayCode());
        payment.setPayType(in.getPayType());
        payment.setMoney(in.getMoney());
        payment.setAmount(in.getMoney());
        payment.setRate(in.getRate());
        payment.setPrecision(in.getPrecision());
        payment.setFlag("1");
        payment.setTerminalNo(in.getTerminalNo());
        payment.setTerminalSno(in.getIdSheetNo());
        payment.setRowno(order.getPayments().size() + 1);
        payment.setPrcutMode(in.getCutMode());
        return payment;
    }

    public static List<Payment> creatPayment(Payment Temp, ZhongbaiData data, String queryType) {
        ArrayList<Payment> payments = new ArrayList<Payment>();
        if ("1".equals(queryType)) {
            Temp.setRefCode(data.getOrderNo());
        } else if ("4".equals(queryType)) {
            Temp.setRefCode(data.getRefundNo());
        }
        List<ZhongbaiFund> funds = data.getFunds();
        for (int i = 0; i < funds.size(); ++i) {
            Payment pay = (Payment)Temp.clone();
            pay.setPuid(UUIDUtils.buildPuid());
            pay.setPayNo(funds.get(i).getPayno());
            pay.setPayCode(funds.get(i).getCode());
            pay.setRowno(pay.getRowno() + i);
            pay.setAmount(ManipulatePrecision.doubleConvert(funds.get(i).getJe(), 2, 0));
            payments.add(pay);
        }
        return payments;
    }
}

