/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.yongwang.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.model.AbstractInModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.ConsumersData;
import com.efuture.pos.model.Order;
import com.efuture.pos.util.CnaeonSignature;
import com.efuture.pos.util.UUIDUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class YWMemberGiveOrReverseIn
extends AbstractInModel {
    private static final long serialVersionUID = 3984005492482603852L;
    private String tokenId;
    private int sourceId = 90;
    private String orgId;
    private String sign;
    private long timestamp;
    private String orderNo;
    private String srcOrderNo;
    private String regionalCode;
    private String payNo;
    @NotNull(message="opType")
    private Integer opType;
    @NotNull(message="point")
    private double point;
    @NotNull(message="balance")
    private double balance;
    private String memberId;
    private String storeCode;
    private String transactionAmount;
    private String puid;

    public String getPuid() {
        return this.puid;
    }

    public void setPuid(String puid) {
        this.puid = puid;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(int sourceId) {
        this.sourceId = sourceId;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getSrcOrderNo() {
        return this.srcOrderNo;
    }

    public void setSrcOrderNo(String srcOrderNo) {
        this.srcOrderNo = srcOrderNo;
    }

    public String getRegionalCode() {
        return this.regionalCode;
    }

    public void setRegionalCode(String regionalCode) {
        this.regionalCode = regionalCode;
    }

    public String getPayNo() {
        return this.payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public Integer getOpType() {
        return this.opType;
    }

    public void setOpType(Integer opType) {
        this.opType = opType;
    }

    public double getPoint() {
        return this.point;
    }

    public void setPoint(double point) {
        this.point = point;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(String transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    @Override
    public AbstractInModel transfer(JSONObject jsonParams) {
        return null;
    }

    public String toString() {
        return "YWMemberGiveOrReverseIn [tokenId=" + this.tokenId + ", sourceId=" + this.sourceId + ", orgId=" + this.orgId + ", sign=" + this.sign + ", timestamp=" + this.timestamp + ", orderNo=" + this.orderNo + ", srcOrderNo=" + this.srcOrderNo + ", regionalCode=" + this.regionalCode + ", payNo=" + this.payNo + ", opType=" + this.opType + ", point=" + this.point + ", balance=" + this.balance + ", memberId=" + this.memberId + ", storeCode=" + this.storeCode + ", transactionAmount=" + this.transactionAmount + "]";
    }

    public Map<String, Object> transferSignMap(Order order, ConsumersData member) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", this.getTokenId());
        params.put("timestamp", this.getTimestamp());
        params.put("storeCode", this.getShopCode());
        params.put("memberId", member.getConsumersId());
        params.put("orderNo", this.getFlowNo());
        params.put("payNo", this.payNo);
        params.put("transactionAmount", order.getOughtPay());
        params.put("balance", JSON.toJSONString((Object)this.balance));
        params.put("point", this.point);
        params.put("opType", this.opType);
        if (this.srcOrderNo != null) {
            params.put("srcOrderNo", this.srcOrderNo);
        }
        return params;
    }

    public static YWMemberGiveOrReverseIn transferGiveOrReverse(CacheModel cacheModel, Integer opType) {
        Order order = cacheModel.getOrder();
        YWMemberGiveOrReverseIn in = new YWMemberGiveOrReverseIn();
        in.setTokenId(UUIDUtils.buildGuid());
        in.setTimestamp(new Date().getTime());
        in.setOrgId(order.getOrgId());
        in.setStoreCode(order.getShopCode());
        in.setMemberId(order.getConsumersData().getConsumersId());
        in.setOrderNo(cacheModel.getFlowNo());
        in.setTransactionAmount(JSON.toJSONString((Object)order.getOughtPay()));
        in.setPoint(Math.abs(order.getThisTimePoint()));
        in.setOpType(opType);
        in.setPayNo(cacheModel.getOrder().getTerminalNo() + new Date().getTime());
        if (opType == 82 || opType == 84) {
            in.setSrcOrderNo(cacheModel.getOrder().getOriginFlowNo());
        }
        return in;
    }

    public static String yWMemberGiveOrReverseInSign(Order order, ConsumersData member, YWMemberGiveOrReverseIn yWMemberGiveOrReverseIn) {
        String salt = order.getSysPara().getZtKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", yWMemberGiveOrReverseIn.getTokenId());
        params.put("timestamp", yWMemberGiveOrReverseIn.getTimestamp());
        params.put("storeCode", yWMemberGiveOrReverseIn.getStoreCode());
        params.put("memberId", yWMemberGiveOrReverseIn.getMemberId());
        params.put("orderNo", yWMemberGiveOrReverseIn.getOrderNo());
        params.put("payNo", yWMemberGiveOrReverseIn.getPayNo());
        params.put("transactionAmount", yWMemberGiveOrReverseIn.getTransactionAmount());
        params.put("point", JSON.toJSONString((Object)Math.abs(yWMemberGiveOrReverseIn.getPoint())));
        params.put("opType", yWMemberGiveOrReverseIn.getOpType());
        if (yWMemberGiveOrReverseIn.srcOrderNo != null) {
            params.put("srcOrderNo", yWMemberGiveOrReverseIn.srcOrderNo);
        }
        String sign = null;
        try {
            sign = CnaeonSignature.sign(params, salt);
            System.out.println("sign" + sign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sign;
    }
}

