/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.yongwang.request;

import com.alibaba.fastjson.JSON;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.yongwang.request.YWMemberPointConsumerIn;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.CnaeonSignature;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.UUIDUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import javax.validation.constraints.NotNull;

public class YWMemberPointConsume
implements Serializable {
    private static final long serialVersionUID = -2456078438309824171L;
    private String tokenId;
    private int sourceId = 90;
    private long timestamp;
    private String storeCode;
    private String sign;
    private String srcOrderNo;
    private String trNum;
    @NotNull(message="opType")
    private Integer opType;
    @NotNull(message="point")
    private double point;
    private String puid;
    @NotNull(message="balance")
    private double balance;
    @NotNull(message="memberId")
    private String memberId;
    private String orderNo;
    private String orgId;
    private String payNo;

    public String getPayNo() {
        return this.payNo;
    }

    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(String tokenId) {
        this.tokenId = tokenId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(int sourceId) {
        this.sourceId = sourceId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getStoreCode() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getSrcOrderNo() {
        return this.srcOrderNo;
    }

    public void setSrcOrderNo(String srcOrderNo) {
        this.srcOrderNo = srcOrderNo;
    }

    public String getTrNum() {
        return this.trNum;
    }

    public void setTrNum(String trNum) {
        this.trNum = trNum;
    }

    public Integer getOpType() {
        return this.opType;
    }

    public void setOpType(Integer opType) {
        this.opType = opType;
    }

    public double getPoint() {
        return this.point;
    }

    public void setPoint(double point) {
        this.point = point;
    }

    public String getPuid() {
        return this.puid;
    }

    public void setPuid(String puid) {
        this.puid = puid;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public static YWMemberPointConsume transferParams(YWMemberPointConsume params, YWMemberPointConsumerIn in, Order order, Payment payment) {
        in.setTokenId(UUIDUtils.buildGuid());
        in.setTrNum(in.getTerminalNo() + new Date().getTime());
        Date date = new Date();
        in.setTimestamp(date.getTime());
        params.setTimestamp(date.getTime());
        params.setTokenId(in.getTokenId());
        params.setSourceId(Integer.valueOf(order.getChannel()));
        params.setStoreCode(in.getShopCode());
        params.setMemberId(order.getConsumersData().getConsumersId());
        params.setOrgId(order.getOrgId());
        if (in.getOpType() == 56) {
            params.setOrderNo(UUIDUtils.buildGuid());
        } else {
            params.setOrderNo(in.getFlowNo());
        }
        params.setBalance(ManipulatePrecision.doubleConvert(in.getBalance()));
        params.setOpType(in.getOpType());
        if (in.getOpType() == 56) {
            params.setPayNo(payment.getRefCode());
        } else {
            params.setPayNo(in.getTrNum());
        }
        params.setPoint(ManipulatePrecision.doubleConvert(in.getPoint()));
        if (in.getOpType() == 94) {
            params.setSrcOrderNo(order.getOriginFlowNo());
        } else if (in.getOpType() == 56) {
            params.setSrcOrderNo(order.getFlowNo());
        }
        return params;
    }

    public static YWMemberPointConsume buildYWMemberPointConsume(CacheModel cacheModel, Payment sp, Integer opType) {
        sp.setAmount(ManipulatePrecision.getDetailOverFlow(sp.getAmount(), "4"));
        Order order = cacheModel.getOrder();
        YWMemberPointConsume consume = new YWMemberPointConsume();
        Date date = new Date();
        consume.setTimestamp(date.getTime());
        consume.setTokenId(UUIDUtils.buildGuid().substring(10));
        consume.setSourceId(CastUtil.castInt(cacheModel.getOrder().getChannel()));
        consume.setStoreCode(order.getShopCode());
        consume.setMemberId(order.getConsumersData().getConsumersId());
        consume.setOrgId(order.getOrgId());
        consume.setOrderNo(order.getFlowNo());
        consume.setBalance(sp.getMoney());
        consume.setOpType(opType);
        consume.setPoint(sp.getAmount());
        consume.setPayNo(cacheModel.getOrder().getTerminalNo() + new Date().getTime() + "");
        if (opType == 94) {
            consume.setSrcOrderNo(cacheModel.getOrder().getOriginFlowNo());
        }
        return consume;
    }

    public static String signYWmemberPointConsume(CacheModel cacheModel, YWMemberPointConsume consume, Integer opType) {
        String salt = cacheModel.getOrder().getSysPara().getZtKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", consume.getTokenId());
        params.put("timestamp", consume.getTimestamp());
        params.put("storeCode", consume.getStoreCode());
        params.put("memberId", consume.getMemberId());
        params.put("orderNo", consume.getOrderNo());
        params.put("srcOrderNo", consume.getSrcOrderNo());
        params.put("payNo", consume.getPayNo());
        params.put("point", JSON.toJSONString((Object)consume.getPoint()));
        params.put("balance", JSON.toJSONString((Object)consume.getBalance()));
        params.put("opType", opType);
        String sign = null;
        try {
            sign = CnaeonSignature.sign(params, salt);
        }
        catch (Exception e) {
            // empty catch block
        }
        return sign;
    }
}

