/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.zhongbai.request;

import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.request.ZhongbaiPayRefundIn;
import com.efuture.pos.model.zhongbai.BaseRequest;
import com.efuture.pos.model.zhongbai.request.ZhongbaiBill;
import com.efuture.pos.util.RSAConfig;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;

public class RefundRequest
extends BaseRequest {
    private static final long serialVersionUID = 1L;

    public RefundRequest(ZhongbaiPayRefundIn reqIn, CacheModel cacheModel) {
        RefundRequestData data = new RefundRequestData(reqIn, cacheModel);
        this.setService(BaseRequest.ZBServiceType.refund.code());
        this.setData(data);
    }

    public RefundRequest(ZhongbaiPayRefundIn reqIn, CacheModel cacheModel, RSAConfig rsaConfig) {
        super(rsaConfig.getVersion(), rsaConfig.getMcId(), rsaConfig.getPactId(), BaseRequest.ZBServiceType.refund.code());
        RefundRequestData data = new RefundRequestData(reqIn, cacheModel);
        this.setData(data);
    }

    public RefundRequest() {
    }

    public static class RefundRequestData
    extends BaseRequest.RequestData {
        private static final long serialVersionUID = 1L;
        private String listNo;
        private String cashier;
        private String orderNo;
        private String refundNo;
        private long transAmt;
        private int repeat;
        private ZhongbaiBill bill;

        public String getListNo() {
            return this.listNo;
        }

        public void setListNo(String listNo) {
            this.listNo = listNo;
        }

        public String getCashier() {
            return this.cashier;
        }

        public void setCashier(String cashier) {
            this.cashier = cashier;
        }

        public String getOrderNo() {
            return this.orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getRefundNo() {
            return this.refundNo;
        }

        public void setRefundNo(String refundNo) {
            this.refundNo = refundNo;
        }

        public long getTransAmt() {
            return this.transAmt;
        }

        public void setTransAmt(long transAmt) {
            this.transAmt = transAmt;
        }

        public int getRepeat() {
            return this.repeat;
        }

        public void setRepeat(int repeat) {
            this.repeat = repeat;
        }

        public ZhongbaiBill getBill() {
            return this.bill;
        }

        public void setBill(ZhongbaiBill bill) {
            this.bill = bill;
        }

        public RefundRequestData(ZhongbaiPayRefundIn reqIn, CacheModel cacheModel) {
            Order order = cacheModel.getOrder();
            this.setTransDate(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            this.setStoreCode(reqIn.getShopCode());
            this.setPosId(reqIn.getTerminalNo());
            this.setListNo(order.getTerminalSno());
            this.setCashier(reqIn.getTerminalOperator());
            this.setRefundNo(reqIn.getRefundNo());
            this.setOrderNo(reqIn.getOrgOrderNo());
            this.setTransAmt((long)(reqIn.getRefundMoney() * 100.0));
            this.setRepeat(0);
            ZhongbaiBill bill = new ZhongbaiBill(cacheModel);
            bill.setType("4");
            this.setBill(bill);
        }

        public RefundRequestData() {
        }
    }
}

