/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.zhongbai.request;

import com.efuture.pos.model.Goods;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ZhongBaisaleGoods {
    private String rowno;
    private String code;
    private String barcode;
    private String name;
    private String manaframe;
    private String catid;
    private String ppid;
    private long xxtax;
    private long sj;
    private long jg;
    private long sl;
    private long hjje;
    private long hjzk;

    public String getRowno() {
        return this.rowno;
    }

    public void setRowno(String rowno) {
        this.rowno = rowno;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getManaframe() {
        return this.manaframe;
    }

    public void setManaframe(String manaframe) {
        this.manaframe = manaframe;
    }

    public String getCatid() {
        return this.catid;
    }

    public void setCatid(String catid) {
        this.catid = catid;
    }

    public String getPpid() {
        return this.ppid;
    }

    public void setPpid(String ppid) {
        this.ppid = ppid;
    }

    public long getXxtax() {
        return this.xxtax;
    }

    public void setXxtax(long xxtax) {
        this.xxtax = xxtax;
    }

    public long getSj() {
        return this.sj;
    }

    public void setSj(long sj) {
        this.sj = sj;
    }

    public long getJg() {
        return this.jg;
    }

    public void setJg(long jg) {
        this.jg = jg;
    }

    public long getSl() {
        return this.sl;
    }

    public void setSl(long sl) {
        this.sl = sl;
    }

    public long getHjje() {
        return this.hjje;
    }

    public void setHjje(long hjje) {
        this.hjje = hjje;
    }

    public long getHjzk() {
        return this.hjzk;
    }

    public void setHjzk(long hjzk) {
        this.hjzk = hjzk;
    }

    public static ZhongBaisaleGoods transform2zb(Goods good) {
        ZhongBaisaleGoods zbGood = new ZhongBaisaleGoods();
        zbGood.setRowno(String.valueOf(good.getFlowId()));
        zbGood.setCode(good.getGoodsCode());
        zbGood.setBarcode(good.getBarNo());
        try {
            zbGood.setName(URLEncoder.encode(good.getGoodsName(), "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            zbGood.setName(good.getGoodsName());
        }
        zbGood.setManaframe(good.getOrgCode());
        zbGood.setCatid(good.getCategory());
        zbGood.setPpid(good.getBrand());
        zbGood.setSj((long)(good.getListPrice() * 100.0));
        zbGood.setJg((long)(good.getSalePrice() * 100.0));
        zbGood.setSl((long)(good.getQty() * 1000.0));
        zbGood.setHjje((long)(good.getSaleValue() * 100.0));
        zbGood.setHjzk((long)(good.getTotalDiscountValue() * 100.0));
        return zbGood;
    }

    public static List<ZhongBaisaleGoods> transform2zb(List<Goods> goods) {
        ArrayList<ZhongBaisaleGoods> goodsZB = new ArrayList<ZhongBaisaleGoods>();
        for (Goods good : goods) {
            goodsZB.add(ZhongBaisaleGoods.transform2zb(good));
        }
        return goodsZB;
    }
}

