/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.net;

import com.efuture.pos.component.common.PayConfigure;
import com.efuture.pos.net.IServiceRequest;
import com.efuture.pos.util.Log;
import com.efuture.pos.util.XMLUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public abstract class AbstractRequest
implements IServiceRequest {
    private boolean hasInit = false;
    private int socketTimeout = 10000;
    private int connectTimeout = 30000;
    private RequestConfig requestConfig;
    private CloseableHttpClient httpClient;
    private PayConfigure payConfigure;

    public PayConfigure getConfigure() {
        return this.payConfigure;
    }

    public void setConfigure(PayConfigure payConfigure) {
        this.payConfigure = payConfigure;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        this.resetRequestConfig();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.resetRequestConfig();
    }

    private void resetRequestConfig() {
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    protected String sendPost(String url, String postDataXML, Log log) {
        return this.executePost(url, postDataXML, log);
    }

    protected String sendPost(String url, Object xmlObj, Log log) {
        XStream xStreamForRequestPostData = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
        xStreamForRequestPostData.autodetectAnnotations(true);
        String postDataXML = xStreamForRequestPostData.toXML(xmlObj);
        return this.executePost(url, postDataXML, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executePost(String url, String postDataXML, Log log) {
        String result = null;
        HttpPost httpPost = new HttpPost(url);
        StringEntity postEntity = new StringEntity(postDataXML, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.setEntity((HttpEntity)postEntity);
        httpPost.setConfig(this.requestConfig);
        XMLUtil.log("executing request" + httpPost.getRequestLine());
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (ConnectionPoolTimeoutException e) {
            log.e("http get throw ConnectionPoolTimeoutException(wait time out)");
        }
        catch (ConnectTimeoutException e) {
            log.e("http get throw ConnectTimeoutException");
        }
        catch (SocketTimeoutException e) {
            log.e("http get throw SocketTimeoutException");
        }
        catch (Exception e) {
            log.e("http get throw Exception");
        }
        finally {
            httpPost.abort();
        }
        return result;
    }

    protected void init() {
        this.httpClient = HttpClients.custom().build();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
        this.hasInit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void httpsInit() throws IOException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream instream = new FileInputStream(new File(this.payConfigure.getCertLocalPath()));){
            keyStore.load(instream, this.payConfigure.getCertPassword().toCharArray());
        }
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, this.payConfigure.getCertPassword().toCharArray()).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        this.httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build();
        this.hasInit = true;
    }

    public boolean isHasInit() {
        return this.hasInit;
    }

    @Override
    public String sendHttpsPost(String apiUrl, Object xmlObj) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, IOException {
        return null;
    }

    @Override
    public String sendHttpPost(String apiUrl, Object xmlObj) {
        return null;
    }

    @Override
    public String sendHttpPost(String apiUrl, String xmlStr) {
        return null;
    }

    public static interface ResultListener {
        public void onConnectionPoolTimeoutError();
    }
}

