/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.pay;

import com.efuture.pos.net.HttpRequest;
import com.efuture.pos.pay.model.aeon.BasePayRequest;
import com.efuture.pos.pay.model.aeon.request.PayQueryRequest;
import com.efuture.pos.pay.model.aeon.request.PayRefundQueryRequest;
import com.efuture.pos.pay.model.aeon.request.PayRefundRequest;
import com.efuture.pos.pay.model.aeon.request.PayRequest;
import com.efuture.pos.pay.model.aeon.request.RepealPayRequest;
import com.efuture.pos.pay.model.aeon.response.PayQueryResponse;
import com.efuture.pos.pay.model.aeon.response.PayRefundQueryResponse;
import com.efuture.pos.pay.model.aeon.response.PayRefundResponse;
import com.efuture.pos.pay.model.aeon.response.PayResponse;
import com.efuture.pos.pay.model.aeon.response.RepealPayResponse;
import com.efuture.pos.util.MD5;
import com.efuture.pos.util.XMLUtil;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AeonPayTools {
    private static final Logger logger = LoggerFactory.getLogger(AeonPayTools.class);

    public static PayResponse salePay(PayRequest req, String url, String key) {
        return AeonPayTools.doRequest(url, req, PayResponse.class, key);
    }

    public static PayRefundResponse saleRefundPay(PayRefundRequest req, String url, String key) {
        return AeonPayTools.doRequest(url, req, PayRefundResponse.class, key);
    }

    public static PayQueryResponse salePayQuery(PayQueryRequest req, String url, String key) {
        return AeonPayTools.doRequest(url, req, PayQueryResponse.class, key);
    }

    public static PayRefundQueryResponse saleRefundPayQuery(PayRefundQueryRequest req, String url, String key) {
        return AeonPayTools.doRequest(url, req, PayRefundQueryResponse.class, key);
    }

    public static RepealPayResponse repealPay(RepealPayRequest req, String url, String key) {
        return AeonPayTools.doRequest(url, req, RepealPayResponse.class, key);
    }

    private static <T> T doRequest(String url, BasePayRequest req, Class<T> targetClazz, String key) {
        req = AeonPayTools.sign(req, key);
        String resp = null;
        String posXmlStr = XMLUtil.objectToXmlStr(req);
        posXmlStr = StringEscapeUtils.unescapeHtml((String)posXmlStr);
        try {
            resp = new HttpRequest(null).sendHttpPost(url, AeonPayTools.filt(posXmlStr));
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.error("\u8bf7\u6c42\u5916\u90e8\u652f\u4ed8\u63a5\u53e3\u901a\u8baf\u51fa\u9519\uff01", (Throwable)e);
        }
        if (StringUtils.isEmpty(resp)) {
            return null;
        }
        logger.info("\u79fb\u52a8\u652f\u4ed8\u8bf7\u6c42\u771f\u5b9e\u8fd4\u56de--->{}", (Object)resp);
        req.getRequest().setSign(null);
        return XMLUtil.getObjectFromXML(resp, targetClazz);
    }

    private static BasePayRequest sign(BasePayRequest req, String key) {
        req.getRequest().setSign(null);
        BasePayRequest.Request request = req.getRequest();
        String sign = AeonPayTools.md5Sign(request, req.getData(), key);
        request.setSign(sign);
        return req;
    }

    private static String filt(String xmlStr) {
        String str = xmlStr.replace("<data class=\"data\">", "<data>");
        str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + str;
        logger.info("\u79fb\u52a8\u652f\u4ed8\u8bf7\u6c42\u5165\u53c2--->{}" + str);
        return str;
    }

    private static String md5Sign(Object request, Object data, String key) {
        String sortedStr = AeonPayTools.getTreeSortParamsPair(request, data, key);
        logger.info("\u79fb\u52a8\u652f\u4ed8\u63a5\u53e3\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32--->{}", (Object)sortedStr);
        return MD5.MD5EncodeU(sortedStr).toUpperCase();
    }

    private static String getTreeSortParamsPair(Object request, Object data, String mkey) {
        Map<String, Object> treMmap = AeonPayTools.getTreeMap();
        treMmap = AeonPayTools.fillTreeMap(AeonPayTools.fillTreeMap(treMmap, request), data);
        StringBuffer sb = new StringBuffer();
        for (String key : treMmap.keySet()) {
            sb.append(key).append("=").append(treMmap.get(key)).append("&");
        }
        String paramStr = sb.append("KEY=").append(mkey).toString();
        paramStr = "&" + paramStr;
        return paramStr;
    }

    private static Map<String, Object> fillTreeMap(Map<String, Object> map, Object paramObj) {
        for (Class<?> clazz = paramObj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                String fieldName = f.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                String getFieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Method getMethod = clazz.getMethod("get" + getFieldName, null);
                    Object value = getMethod.invoke(paramObj, (Object[])null);
                    if (null == value) continue;
                    String key = fieldName;
                    XStreamAlias fieldAlias = f.getDeclaredAnnotation(XStreamAlias.class);
                    if (null != fieldAlias) {
                        key = fieldAlias.value();
                    }
                    map.put(key, value);
                }
                catch (Exception e) {
                    logger.error("\u652f\u4ed8\u586b\u5145\u53c2\u6570\u952e\u503c\u5bf9\u51fa\u9519\uff01", (Throwable)e);
                }
            }
        }
        return map;
    }

    private static Map<String, Object> getTreeMap() {
        return new TreeMap(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return String.valueOf(o1).compareTo(String.valueOf(o2));
            }
        });
    }
}

