/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.pay;

import com.efuture.pos.pay.TcpUtil;
import com.efuture.pos.pay.model.allVpay.request.PayQueryRequest;
import com.efuture.pos.pay.model.allVpay.request.PayRequest;
import com.efuture.pos.pay.model.allVpay.request.RefundPayQueryRequest;
import com.efuture.pos.pay.model.allVpay.request.RefundPayRequest;
import com.efuture.pos.pay.model.allVpay.request.RepealPayRequest;
import com.efuture.pos.pay.model.allVpay.response.PayQueryResponse;
import com.efuture.pos.pay.model.allVpay.response.PayResponse;
import com.efuture.pos.pay.model.allVpay.response.RefundPayQueryResponse;
import com.efuture.pos.pay.model.allVpay.response.RefundPayResponse;
import com.efuture.pos.pay.model.allVpay.response.RepealPayResponse;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
@Configuration
@PropertySource(value={"classpath:allvpay.properties"})
public class AllVPayTools {
    @Value(value="${allvpay.ip}")
    private String ip;
    @Value(value="${allvpay.port}")
    private int port;
    @Value(value="${allvpay.timeOut}")
    private int timeOut;
    @Autowired
    TcpUtil tcpUtil;

    public static String getDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String date = df.format(new Date()).toString();
        return date;
    }

    public static String getTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = df.format(new Date()).toString();
        return time;
    }

    public PayResponse salePay(PayRequest payRequest) throws UnsupportedEncodingException {
        String result = new String(this.tcpUtil.send(this.ip, this.port, payRequest.toString().getBytes("gbk"), this.timeOut), "gbk");
        return new PayResponse(result);
    }

    public PayQueryResponse salePayQuery(PayQueryRequest payQueryRequest) throws UnsupportedEncodingException {
        String result = new String(this.tcpUtil.send(this.ip, this.port, payQueryRequest.toString().getBytes("gbk"), this.timeOut), "gbk");
        if (null == result) {
            throw new NullPointerException("\u652f\u4ed8\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6");
        }
        return new PayQueryResponse(result);
    }

    public RefundPayResponse saleRefundPay(RefundPayRequest refundRequest) throws UnsupportedEncodingException {
        String result = new String(this.tcpUtil.send(this.ip, this.port, refundRequest.toString().getBytes("gbk"), this.timeOut), "gbk");
        if (null == result) {
            throw new NullPointerException("\u652f\u4ed8\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6");
        }
        return new RefundPayResponse(result);
    }

    public RefundPayQueryResponse saleRefundPayQuery(RefundPayQueryRequest refundQueryRequest) throws UnsupportedEncodingException {
        String result = new String(this.tcpUtil.send(this.ip, this.port, refundQueryRequest.toString().getBytes("gbk"), this.timeOut), "gbk");
        if (null == result) {
            throw new NullPointerException("\u652f\u4ed8\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6");
        }
        return new RefundPayQueryResponse(result);
    }

    public RepealPayResponse repealPay(RepealPayRequest repealPayRequest) throws UnsupportedEncodingException {
        String result = new String(this.tcpUtil.send(this.ip, this.port, repealPayRequest.toString().getBytes("gbk"), this.timeOut), "gbk");
        if (null == result) {
            throw new NullPointerException("\u652f\u4ed8\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6");
        }
        return new RepealPayResponse(result);
    }
}

