/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.pay;

import com.efuture.pos.component.service.BaseService;
import com.efuture.pos.pay.model.offlinepay.OfflineRev;
import com.efuture.pos.util.HttpUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class OfflinePayTools
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(OfflinePayTools.class);
    public static final String SALEPAY = "/wechat-order-api/wechat/payment/offlinecode/pay";
    public static final String SALEPAYQUERY = "/wechat-order-api/wechat/payment/offlinecode/orderquery";
    public static final String REFUND = "/wechat-order-api/wechat/payment/offlinecode/refund";
    public static final String REFUNDQUERY = "/wechat-order-api/wechat/payment/offlinecode/refundquery";
    public static final String REVERSE = "/wechat-order-api/wechat/payment/offlinecode/reverse";

    public ServiceResponse salePay(RestTemplate restTemplate, ServiceSession session, String inStr) {
        logger.info("salePay -start");
        ServiceResponse resp = this.httpUtils.offlineDoPost(restTemplate, HttpUtils.RemoteService.OFFLINEPAY, SALEPAY, session, inStr, Object.class, "\u7ebf\u4e0b\u6536\u5355", "\u652f\u4ed8");
        logger.info("salePay -end");
        return resp;
    }

    public ServiceResponse salePayQuery(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.offlineDoPost(restTemplate, HttpUtils.RemoteService.OFFLINEPAY, SALEPAYQUERY, session, inStr, OfflineRev.class, "\u7ebf\u4e0b\u6536\u5355", "\u652f\u4ed8\u67e5\u8be2");
        return resp;
    }

    public ServiceResponse refund(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.offlineDoPost(restTemplate, HttpUtils.RemoteService.OFFLINEPAY, REFUND, session, inStr, OfflineRev.class, "\u7ebf\u4e0b\u6536\u5355", "\u9000\u6b3e");
        return resp;
    }

    public ServiceResponse refundQuery(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.offlineDoPost(restTemplate, HttpUtils.RemoteService.OFFLINEPAY, REFUNDQUERY, session, inStr, OfflineRev.class, "\u7ebf\u4e0b\u6536\u5355", "\u9000\u6b3e\u67e5\u8be2");
        return resp;
    }

    public ServiceResponse reverse(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.offlineDoPost(restTemplate, HttpUtils.RemoteService.OFFLINEPAY, REVERSE, session, inStr, OfflineRev.class, "\u7ebf\u4e0b\u6536\u5355", "\u64a4\u9500\u8ba2\u5355");
        return resp;
    }
}

