/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.common.utils.DiscoveryRestUtils;
import com.efuture.pos.util.HttpLog;
import com.efuture.pos.util.RSASignature;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.StatisticUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Component(value="possvHttpUtils")
@Configuration
@PropertySource(name="possvHttp", value={"classpath:http-${spring.profiles.active}.properties"})
public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static final String FUSE_CODE = "100";
    private static final String OFFLINE_CODE = "404";
    private static final int FUSE_RETRY_COUNT = 3;
    public static ThreadLocal<String> postThreadLocal = new ThreadLocal();
    @Value(value="${http.possv.connectTimeout}")
    private int connectTimeout;
    @Value(value="${http.possv.readTimeout}")
    private int readTimeout;
    @Value(value="${service.timeoutlog}")
    private int timeoutlog;
    public static int statictimeoutlog = 0;
    private static int staitcConnectTimeout = 3000;
    private static int staticReadTimeout = 600000;
    @Resource
    ConfigurableEnvironment environment;
    @Value(value="${server.route.mode}")
    private String routeMode;
    @Resource(name="stringRedisTemplate")
    private HashOperations<String, String, String> opsForHash;
    private static String mediaType = "application/json; charset=UTF-8";

    @Bean(value={"possvHttpProperties"})
    public PropertiesPropertySource propertySource() {
        return (PropertiesPropertySource)this.environment.getPropertySources().get("possvHttp");
    }

    @PostConstruct
    public void initHttpConfig() {
        staticReadTimeout = this.getReadTimeout();
        staitcConnectTimeout = this.getConnectTimeout();
        statictimeoutlog = this.getTimeoutlog();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getTimeoutlog() {
        return this.timeoutlog;
    }

    public void setTimeoutlog(int timeoutlog) {
        this.timeoutlog = timeoutlog;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public <T> ServiceResponse doPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String reqUrl;
        long startTime = System.currentTimeMillis();
        String flowNo = postThreadLocal.get();
        String traceID = flowNo;
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo), session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(restTemplate, traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        if ("pos.syjmainlog.searchNewData".equals(method)) {
            HttpLog.log(serviceName, methodName, value, logResp, originResp, traceID, endTime - startTime);
        } else if ("pos.posupdatestamp.syncData".equals(method)) {
            HttpLog.log(serviceName, methodName, "", resp, logResp, traceID, endTime - startTime);
        } else {
            HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        }
        return returnResp;
    }

    public <T> ServiceResponse doPostSaveOrder(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String shopCode) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = postThreadLocal.get();
        String reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl = reqUrl + "&app_code=CPOS", session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(restTemplate, traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        if ("pos.syjmainlog.searchNewData".equals(method)) {
            HttpLog.log(serviceName, methodName, value, logResp, originResp, traceID, endTime - startTime);
        } else if ("pos.posupdatestamp.syncData".equals(method)) {
            HttpLog.log(serviceName, methodName, "", resp, logResp, traceID, endTime - startTime);
        } else {
            HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        }
        return returnResp;
    }

    public <T> ServiceResponse doPostSync(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String flowNo) {
        long startTime = System.currentTimeMillis();
        String traceID = flowNo;
        String reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl, session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(restTemplate, traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        if ("pos.syjmainlog.searchNewData".equals(method)) {
            HttpLog.log(serviceName, methodName, value, logResp, originResp, traceID, endTime - startTime);
        } else if ("pos.posupdatestamp.syncData".equals(method)) {
            HttpLog.log(serviceName, methodName, "", resp, logResp, traceID, endTime - startTime);
        } else {
            HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        }
        return returnResp;
    }

    public <T> ServiceResponse backPrintDoPost(RestTemplate restTemplate, String remoteUrl, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = postThreadLocal.get();
        String reqUrl = "";
        reqUrl = null == remoteUrl || remoteUrl.length() == 0 ? this.buildOuterRequestUrl(remoteService, method, session) : remoteUrl + method;
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl, session, value, remoteService);
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        if (!methodName.equals("cipPay")) {
            if ("pos.syjmainlog.searchNewData".equals(method)) {
                HttpLog.log(serviceName, methodName, value, logResp, originResp, traceID, endTime - startTime);
            } else if ("pos.posupdatestamp.syncData".equals(method)) {
                HttpLog.log(serviceName, methodName, "", resp, logResp, traceID, endTime - startTime);
            } else {
                HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
            }
        }
        return returnResp;
    }

    public <T> ServiceResponse noFlowNoPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String traceID = UUIDUtils.buildGuid();
        String reqUrl = this.buildRequestUrl(remoteService, method, session, traceID);
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl = reqUrl + "&noFlowNo=1", session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(restTemplate, traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse logResp = new ServiceResponse();
        if ("pos.syjmainlog.searchNewData".equals(method)) {
            HttpLog.log(serviceName, methodName, value, originResp, logResp, traceID, endTime - startTime);
        } else if ("pos.posupdatestamp.syncData".equals(method)) {
            HttpLog.log(serviceName, methodName, value, logResp, resp, traceID, endTime - startTime);
        } else {
            HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        }
        return resp;
    }

    public <T> ServiceResponse eSystemPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String traceID = UUIDUtils.buildGuid();
        String reqUrl = this.buildOuterRequestUrl(remoteService, method, session);
        ServiceResponse resp = HttpUtils.executeEsystemPost(restTemplate, traceID, reqUrl, session, value, remoteService);
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, startTime - endTime);
        return resp;
    }

    public <T> ServiceResponse doPostWithOutRetry(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = postThreadLocal.get();
        String reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        ServiceResponse resp = HttpUtils.externalPost(restTemplate, traceID, reqUrl, session, value, remoteService);
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public <T> ServiceResponse flowNoEndPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = postThreadLocal.get();
        String reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl = reqUrl + "&flowEnd=1", session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(restTemplate, traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        try {
            if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
                resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
            }
            long endTime = System.currentTimeMillis();
            HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, startTime - endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            HttpLog.log(serviceName, methodName, value, originResp, resp, e.getMessage(), traceID);
        }
        return resp;
    }

    private static ServiceResponse retryPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, Integer retryCount, RemoteService remoteService) {
        if (null == retryCount) {
            retryCount = 1;
        }
        if (retryCount <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)OFFLINE_CODE, (String)HttpUtils.errorMessage(remoteService, null));
        }
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, templateURL, session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            retryCount = retryCount - 1;
            return HttpUtils.retryPost(restTemplate, traceID, templateURL, session, value, retryCount, remoteService);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceResponse executePost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp;
        long startTime = System.currentTimeMillis();
        try {
            StatisticUtils.onIncrementMethod((String)templateURL, (long)startTime);
            logger.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            String respStr = (String)DiscoveryRestUtils.onHttpPost((RestTemplate)restTemplate, (String)traceID, (int)staitcConnectTimeout, (int)40000, (String)mediaType, (String)templateURL, Collections.singletonMap("session", JSON.toJSONString((Object)session)), (String)value, String.class, HttpUtils.class);
            respStr = respStr.replace("\u001a", "");
            resp = (ServiceResponse)JSON.parseObject((String)respStr, ServiceResponse.class);
            if (null == resp) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, e));
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTime;
            StatisticUtils.onDecrementMethod((String)templateURL, (Long)elapsed);
        }
        return resp;
    }

    public String buildRequestUrl(RemoteService service, String method, ServiceSession session, String flowNo) {
        if (method.startsWith("http")) {
            return method;
        }
        long ent_id = session.getEnt_id();
        logger.info("[ ent_id ]---->[{}]", (Object)("" + ent_id));
        String url = this.getRemoteServiceUrl(service) + "?flowNo=" + flowNo + "&ent_id=" + ent_id + "&method=" + method;
        if (HttpUtils.isNeedTokenAuthc(service)) {
            String token = HttpUtils.getToken();
            url = url + "&token=" + token;
        }
        if (HttpUtils.isNeedShopCode(service)) {
            url = url + "&shop_code=" + session.getShop_code();
        }
        return url;
    }

    public String buildZuulUrl(RemoteService service, ServiceSession session, String method) {
        if (method.startsWith("http")) {
            return method;
        }
        long ent_id = session.getEnt_id();
        logger.info("[ ent_id ]---->[{}]", (Object)("" + ent_id));
        String url = this.getRemoteServiceUrl(service);
        if (url.contains("/amp-openapi-service")) {
            url = url.replace("/amp-openapi-service", ":8088/rocketMQ");
        }
        url = url + "?method=" + method + "&ent_id=" + ent_id;
        return url;
    }

    public String buildOuterRequestUrl(RemoteService service, String method, ServiceSession session) {
        if (method.startsWith("http")) {
            return method;
        }
        String url = this.getRemoteServiceUrl(service) + method;
        return url;
    }

    private String getRemoteServiceUrl(RemoteService service) {
        String response = (String)this.propertySource().getProperty(service.getAlias());
        return this.getEnvValue(response);
    }

    private static String getToken() {
        return "1592161107706568120";
    }

    private static boolean isNeedTokenAuthc(RemoteService service) {
        return true;
    }

    private static ServiceResponse cloneOriginResp(ServiceResponse origin) {
        ServiceResponse originResp = new ServiceResponse();
        originResp.setReturncode(origin.getReturncode());
        originResp.setData(origin.getData());
        return originResp;
    }

    private static ServiceResponse executeEsystemPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        try {
            logger.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            respStr = (String)DiscoveryRestUtils.onHttpPost((RestTemplate)restTemplate, (String)traceID, (int)10000, (int)10000, (String)mediaType, (String)templateURL, Collections.singletonMap("session", JSON.toJSONString((Object)session)), (String)value, String.class, HttpUtils.class);
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                respStr = respStr.replace("\u001a", "");
                respStr = respStr.replace("\\", "");
                respStr = respStr.replace("\"{", "{");
                respStr = respStr.replace("}\"", "}");
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            logger.info("\u6c38\u65faeSystem:" + e.getMessage());
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, e));
        }
        return resp;
    }

    private static <T> ServiceResponse convertSuccessResponseData(ServiceResponse resp, Class<T> targetClass) {
        if (targetClass != null) {
            Object obj = JSON.toJSON((Object)resp.getData());
            String jsonString = obj.toString();
            if (targetClass == String.class) {
                obj = jsonString;
            } else if (obj instanceof JSONObject) {
                obj = JSON.parseObject((String)jsonString, targetClass);
            } else if (obj instanceof JSONArray) {
                obj = JSON.parseArray((String)jsonString, targetClass);
            }
            resp.setData(obj);
        }
        return resp;
    }

    private static String errorMessage(RemoteService remoteService, Exception e) {
        if (null != e) {
            logger.info(e.getMessage());
        }
        String error = "[possv\u670d\u52a1\u63d0\u9192\u60a8,";
        switch (remoteService.getAlias()) {
            case "http.mdm.url": {
                error = "\u4e3b\u6570\u636e";
                break;
            }
            case "http.promotion.event.url": {
                error = "\u8425\u9500\u4e2d\u5fc3[\u4fc3\u9500&\u6d3b\u52a8&\u5238]";
                break;
            }
            case "http.promotion.info.url": {
                error = "\u8425\u9500\u4e2d\u5fc3[\u4f1a\u5458&\u8ba4\u8bc1]";
                break;
            }
            case "http.promotion.activity.url": {
                error = "\u8425\u9500\u4e2d\u5fc3[\u6d3b\u52a8&\u4e70\u5238]";
                break;
            }
            case "http.promotion.accnt.url": {
                error = "\u8425\u9500\u4e2d\u5fc3[\u5238\u6fc0\u6d3b]";
                break;
            }
            case "http.warehouse.url": {
                error = "\u5e93\u5b58\u4e2d\u5fc3";
                break;
            }
            case "http.order.url": {
                error = "\u8ba2\u5355\u4e2d\u5fc3";
                break;
            }
            case "http.contract.url": {
                error = "\u5c65\u7ea6\u4e2d\u5fc3";
                break;
            }
            case "http.posmanager.url": {
                error = "POS\u603b\u90e8";
                break;
            }
            case "http.possv.cloud.url": {
                error = "\u4e91\u7aefPOS\u4e2d\u53f0";
                break;
            }
            case "http.crm.ibm.url": {
                error = "\u6c38\u65facrm\u7cfb\u7edf";
                break;
            }
            case "http.esystem.url": {
                error = "\u6c38\u65faeSystem";
                break;
            }
            case "http.backPrint.url": {
                error = "\u540e\u53a8\u6253\u5370";
                break;
            }
        }
        error = error + "]-->\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\uff01";
        logger.info(error);
        return error;
    }

    private String getEnvValue(String keySource) {
        String keyData = keySource.toString();
        int startPos = keyData.indexOf("${");
        if (startPos >= 0) {
            Pattern pattern = Pattern.compile("(\\$\\{[^>]*?\\})");
            StringBuffer buffer = new StringBuffer();
            Matcher matcher = pattern.matcher(keyData);
            while (matcher.find()) {
                String findKey = matcher.group();
                String dataKey = findKey.replaceAll("\\$\\{", "").replaceAll("\\}", "");
                String dataNew = this.environment.getProperty(dataKey);
                if (StringUtils.isEmpty((String)dataNew)) continue;
                matcher.appendReplacement(buffer, dataNew.toString());
            }
            matcher.appendTail(buffer);
            logger.info("\u73af\u5883\u53d8\u91cf" + keySource + ":" + buffer.toString());
            return buffer.toString();
        }
        logger.info("\u672a\u83b7\u53d6\u5230\u73af\u5883\u53d8\u91cf\uff1a" + keySource);
        return keySource;
    }

    public String getRemoteUrl(RemoteService server) throws RuntimeException {
        String response = (String)this.propertySource().getProperty(server.getAlias());
        return this.getEnvValue(response);
    }

    private static ServiceResponse externalPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp = new ServiceResponse();
        try {
            logger.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            String respStr = (String)DiscoveryRestUtils.onHttpPost((RestTemplate)restTemplate, (String)traceID, (int)staitcConnectTimeout, (int)staticReadTimeout, (String)mediaType, (String)templateURL, Collections.singletonMap("session", JSON.toJSONString((Object)session)), (String)value, String.class, HttpUtils.class);
            if (null == respStr) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                respStr = respStr.replace("\u001a", "");
                resp.setReturncode("0");
                resp.setData((Object)respStr);
            }
        }
        catch (Exception e) {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, e));
        }
        return resp;
    }

    public <T> ServiceResponse zhongbaiDataCenterPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String traceID = UUIDUtils.buildGuid();
        String reqUrl = this.buildOuterRequestUrl(remoteService, method, session);
        ServiceResponse resp = HttpUtils.executeZhongbaiDataCenterPost(restTemplate, traceID, reqUrl, session, value, remoteService);
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, startTime - endTime);
        return resp;
    }

    private static ServiceResponse executeZhongbaiDataCenterPost(RestTemplate restTemplate, String traceID, String templateURL, ServiceSession session, String value, RemoteService remoteService) {
        ServiceResponse resp = new ServiceResponse();
        String respStr = "";
        try {
            String signValue = RSASignature.sign(value);
            logger.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)templateURL);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httppost = new HttpPost(templateURL);
            StringEntity myEntity = new StringEntity(value);
            httppost.addHeader("Content-Type", "application/json");
            httppost.addHeader("X-Sign", signValue);
            httppost.setEntity((HttpEntity)myEntity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            InputStreamReader reader = new InputStreamReader(resEntity.getContent(), "UTF-8");
            char[] buff = new char[1024];
            int length = 0;
            while ((length = reader.read(buff)) != -1) {
                respStr = new String(buff, 0, length);
            }
            httpclient.getConnectionManager().shutdown();
            if ("".equals(respStr)) {
                resp.setReturncode("-1");
                resp.setData(null);
            } else {
                respStr = respStr.replace("\u001a", "");
                resp.setData(JSON.parse((String)respStr));
                resp.setReturncode("0");
            }
        }
        catch (Exception e) {
            StackTraceElement[] trace;
            String sOut = "";
            for (StackTraceElement s : trace = e.getStackTrace()) {
                sOut = sOut + "\tat " + s + "\r\n";
            }
            logger.info("\u4e2d\u767e\u4e91\u4e2d\u53f0\u8bf7\u6c42\u5931\u8d25:[{}]", (Object)sOut);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)HttpUtils.errorMessage(remoteService, e));
        }
        return resp;
    }

    public <T> ServiceResponse cnaeonDoPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        long startTime = System.currentTimeMillis();
        String traceID = postThreadLocal.get();
        ServiceResponse resp = new ServiceResponse();
        String url = this.getRemoteServiceUrl(remoteService) + method;
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)25000);
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParams);
            HttpPost httpPost = new HttpPost(url);
            logger.info("[" + traceID + "]--\u8bf7\u6c42\u5730\u5740-->[{}]", (Object)url);
            StringEntity entity = new StringEntity(value, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new Exception("\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u975e200\uff1a" + response.getStatusLine().getStatusCode());
            }
            String res = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
            if (null == res || "".equals(res)) {
                resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            } else {
                JSONObject jsonObject = JSONObject.parseObject((String)res);
                resp = ServiceResponse.buildSuccess((Object)jsonObject);
            }
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5931\u8d25\uff1a", (Throwable)e);
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"60003", (String)"\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38");
        }
        long endTime = System.currentTimeMillis();
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, startTime - endTime);
        return resp;
    }

    public <T> ServiceResponse doPostZuul(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String reqUrl;
        String flowNo;
        long startTime = System.currentTimeMillis();
        String traceID = flowNo = postThreadLocal.get();
        String marketURL = (String)this.opsForHash.get((Object)"posroute:log:posserver", (Object)"marketURL");
        logger.info("\u662f\u5426\u6709\u524d\u7f6e\u673a\uff1a" + StringUtils.isNotEmpty((String)marketURL));
        if ("0".equals(this.routeMode) && StringUtils.isNotEmpty((String)marketURL)) {
            reqUrl = this.buildZuulUrl(remoteService, session, method);
            logger.info("reqUrl\uff1a" + reqUrl);
        } else {
            reqUrl = this.buildRequestUrl(remoteService, method, session, flowNo);
        }
        ServiceResponse resp = HttpUtils.doPost(reqUrl, JSONObject.parseObject((String)value));
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        long endTime = System.currentTimeMillis();
        HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        return returnResp;
    }

    public static ServiceResponse doPost(String url, JSONObject jsonParam) {
        ServiceResponse resp;
        block5: {
            resp = null;
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)3000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)3000);
            DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParams);
            HttpPost method = new HttpPost(url);
            try {
                if (null != jsonParam) {
                    StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
                    entity.setContentEncoding("UTF-8");
                    entity.setContentType("application/json");
                    method.setEntity((HttpEntity)entity);
                }
                CloseableHttpResponse result = httpClient.execute((HttpUriRequest)method);
                url = URLDecoder.decode(url, "UTF-8");
                if (result.getStatusLine().getStatusCode() != 200) break block5;
                String str = "";
                try {
                    str = EntityUtils.toString((HttpEntity)result.getEntity());
                    resp = (ServiceResponse)JSON.parseObject((String)str, ServiceResponse.class);
                }
                catch (Exception e) {
                    logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
                    return ServiceResponse.buildFailure(null, (String)"10000", (String)"\u8f6c\u6362\u5bf9\u8c61\u5f02\u5e38");
                }
            }
            catch (IOException e) {
                logger.error("post\u8bf7\u6c42\u63d0\u4ea4\u5931\u8d25:" + url, (Throwable)e);
                return ServiceResponse.buildFailure(null, (String)"10000", (String)"\u8bf7\u6c42\u5f02\u5e38");
            }
        }
        return resp;
    }

    private static boolean isNeedShopCode(RemoteService service) {
        return true;
    }

    public <T> ServiceResponse doUserCenterPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName, String idcUrl) {
        String reqUrl;
        long startTime = System.currentTimeMillis();
        String flowNo = postThreadLocal.get();
        String traceID = flowNo;
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl = this.buildUserCenterUrl(idcUrl, method, session, flowNo), session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(restTemplate, traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        if ("pos.syjmainlog.searchNewData".equals(method)) {
            HttpLog.log(serviceName, methodName, value, logResp, originResp, traceID, endTime - startTime);
        } else if ("pos.posupdatestamp.syncData".equals(method)) {
            HttpLog.log(serviceName, methodName, "", resp, logResp, traceID, endTime - startTime);
        } else {
            HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        }
        return returnResp;
    }

    public String buildUserCenterUrl(String s, String method, ServiceSession session, String flowNo) {
        long ent_id = session.getEnt_id();
        logger.info("[ ent_id ]---->[{}]", (Object)("" + ent_id));
        String url = this.getEnvValue(s) + "?flowNo=" + flowNo + "&ent_id=" + ent_id + "&method=" + method + "&token=" + HttpUtils.getToken() + "&shop_code=" + session.getShop_code();
        return url;
    }

    public <T> ServiceResponse offlineDoPost(RestTemplate restTemplate, RemoteService remoteService, String method, ServiceSession session, String value, Class<T> targetClass, String serviceName, String methodName) {
        String reqUrl;
        long startTime = System.currentTimeMillis();
        String flowNo = postThreadLocal.get();
        String traceID = flowNo;
        ServiceResponse resp = HttpUtils.executePost(restTemplate, traceID, reqUrl = this.getRemoteServiceUrl(remoteService) + method, session, value, remoteService);
        if (FUSE_CODE.equals(resp.getReturncode())) {
            resp = HttpUtils.retryPost(restTemplate, traceID, reqUrl, session, value, 3, remoteService);
        }
        ServiceResponse originResp = HttpUtils.cloneOriginResp(resp);
        if ("0".equals(resp.getReturncode()) || "1".equals(resp.getReturncode())) {
            resp = HttpUtils.convertSuccessResponseData(resp, targetClass);
        }
        ServiceResponse returnResp = HttpUtils.cloneOriginResp(resp);
        ServiceResponse logResp = ServiceResponse.buildSuccess((Object)"");
        long endTime = System.currentTimeMillis();
        if ("pos.syjmainlog.searchNewData".equals(method)) {
            HttpLog.log(serviceName, methodName, value, logResp, originResp, traceID, endTime - startTime);
        } else if ("pos.posupdatestamp.syncData".equals(method)) {
            HttpLog.log(serviceName, methodName, "", resp, logResp, traceID, endTime - startTime);
        } else {
            HttpLog.log(serviceName, methodName, value, originResp, resp, traceID, endTime - startTime);
        }
        return returnResp;
    }

    public static enum RemoteService {
        MDM("http.mdm.url"),
        PROMOTION("http.promotion.event.url"),
        PROMOTION_INFO("http.promotion.info.url"),
        PROMOTION_ACTIVITY("http.promotion.activity.url"),
        PROMOTION_ACCNT("http.promotion.accnt.url"),
        PROMOTION_MODEL("http.promotion.model.url"),
        ORDER("http.order.url"),
        WAREHOUSE("http.warehouse.url"),
        CONTRACT("http.contract.url"),
        POSMANAGER("http.posmanager.url"),
        POSSV("http.possv.cloud.url"),
        CRM_IBM("http.crm.ibm.url"),
        ESYSTEM("http.esystem.url"),
        BACK_PRINT("http.backPrint.url"),
        ZHONGBAI_DATACENTER("http.zhongbai.url"),
        CNAEON("http.cnaeon.url"),
        OFFLINEPAY("http.offlinePay.url"),
        ROCKERMQ_PRODUCER("http.rocket.mq");

        private String alias;

        public String getAlias() {
            return this.alias;
        }

        private RemoteService(String alias) {
            this.alias = alias;
        }
    }
}

