/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.util;

import com.efuture.pos.util.RSAUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSASignature {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSASignature.class);

    private static byte[] sign(byte[] data, PrivateKey privateKey, String signMethod) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signMethod);
        signature.initSign(privateKey);
        signature.update(data);
        return signature.sign();
    }

    public static String sign(String content, PrivateKey privateKey, String charset) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        LOGGER.info("\u7b7e\u540d\u7b97\u6cd5[{}],\u7b7e\u540d\u5b57\u7b26\u96c6[{}]", (Object)"SHA1WithRSA", (Object)charset);
        LOGGER.info("\u5f85\u7b7e\u540d\u8bf7\u6c42\u6570\u636e[{}]", (Object)content);
        byte[] signData = RSASignature.sign(content.getBytes(charset), privateKey, "SHA1WithRSA");
        String signStr = new String(Base64.getEncoder().encode(signData));
        LOGGER.info("\u751f\u6210\u7b7e\u540d[{}]", (Object)signStr);
        return signStr;
    }

    public static String sign(String data) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException, UnsupportedEncodingException {
        return RSASignature.sign(data, (PrivateKey)RSAUtil.getPrivateKey(), "utf-8");
    }

    public static boolean verify(String content, String sign, PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        LOGGER.info("\u5f85\u9a8c\u7b7e\u54cd\u5e94\u6570\u636e[{}]", (Object)content);
        LOGGER.info("\u5f85\u9a8c\u7b7e\u7b7e\u540d[{}]", (Object)sign);
        byte[] decodeSign = Base64.getDecoder().decode(sign.getBytes());
        return RSASignature.verify(content.getBytes(), decodeSign, publicKey, "SHA1WithRSA");
    }

    public static boolean verify(byte[] content, byte[] sign, PublicKey publicKey, String signMethod) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(signMethod);
        signature.initVerify(publicKey);
        signature.update(content);
        return signature.verify(sign);
    }

    public static boolean verify(String content, String sign) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return RSASignature.verify(content, sign, RSAUtil.getPublicKey());
    }
}

