/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.util;

import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.lang.reflect.Field;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateUtils {
    private static Logger logger = LoggerFactory.getLogger(ValidateUtils.class);

    public static void checkFieldNotNull(Object source) throws Exception {
        for (Class<?> clazz = source.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                NotNull notNull = f.getDeclaredAnnotation(NotNull.class);
                if (notNull == null) continue;
                String fieldName = f.getName();
                String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Object value = clazz.getMethod(methodName, null).invoke(source, (Object[])null);
                if (null != value && !"".equals(value)) continue;
                String msg = notNull.message();
                msg = "\u5b57\u6bb5[" + fieldName + "]\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                logger.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    public static ServiceResponse checkFieldNotNullResp(Object source, ServiceSession session) {
        try {
            ValidateUtils.checkFieldNotNull(source);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getMessage());
        }
        return ServiceResponse.buildSuccess(null);
    }
}

