/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.util;

import com.efuture.pos.util.Log;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static Log logger = new Log(LoggerFactory.getLogger(XMLUtil.class));

    public static void reflect(Object o) throws Exception {
        Class<?> cls = o.getClass();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            f.setAccessible(true);
            XMLUtil.log(f.getName() + " -> " + f.get(o));
        }
    }

    public static byte[] readInput(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
        return out.toByteArray();
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        return baos.toString();
    }

    public static InputStream getStringStream(String sInputString) {
        ByteArrayInputStream tInputStringStream = null;
        if (sInputString != null && !sInputString.trim().equals("")) {
            tInputStringStream = new ByteArrayInputStream(sInputString.getBytes());
        }
        return tInputStringStream;
    }

    public static <T> T getObjectFromXML(String xml, Class<T> tClass) {
        XStream xStreamForResponseData = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStreamForResponseData.alias("xml", tClass);
        xStreamForResponseData.processAnnotations(tClass);
        xStreamForResponseData.ignoreUnknownElements();
        return (T)xStreamForResponseData.fromXML(xml);
    }

    public static String objectToXmlStr(Object obj) {
        XStream xStreamForRequestPostData = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8", (NameCoder)new XmlFriendlyNameCoder("-_", "_")));
        xStreamForRequestPostData.autodetectAnnotations(true);
        String xmlStr = xStreamForRequestPostData.toXML(obj);
        return xmlStr;
    }

    public static String getStringFromMap(Map<String, Object> map, String key, String defaultValue) {
        if (key == "" || key == null) {
            return defaultValue;
        }
        String result = (String)map.get(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static int getIntFromMap(Map<String, Object> map, String key) {
        if (key == "" || key == null) {
            return 0;
        }
        if (map.get(key) == null) {
            return 0;
        }
        return Integer.parseInt((String)map.get(key));
    }

    public static String log(Object log) {
        logger.i(log.toString());
        return log.toString();
    }

    public static String getLocalXMLString(String localPath) throws IOException {
        return XMLUtil.inputStreamToString(XMLUtil.class.getResourceAsStream(localPath));
    }

    public static Map<String, Object> getMapFromXML(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream is = XMLUtil.getStringStream(xmlString);
        Document document = builder.parse(is);
        NodeList allNodes = document.getFirstChild().getChildNodes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Node node = allNodes.item(i);
            if (!(node instanceof Element)) continue;
            map.put(node.getNodeName(), node.getTextContent());
        }
        return map;
    }
}

