/*
 * Decompiled with CFR 0.152.
 */
package com.product.annotation;

import com.product.annotation.UniqueKey;
import com.product.annotation.UniqueKeyRepeatedValues;
import com.product.component.BaseAnnotationService;
import com.product.model.RowMap;
import com.product.model.ServiceSession;
import com.product.service.OperationFlag;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public abstract class UniqueKeyByMongoImpl<T extends MongoTemplate>
extends BaseAnnotationService<UniqueKey> {
    protected abstract T getTemplate();

    public UniqueKeyByMongoImpl() {
        super(UniqueKey.class);
    }

    private void onAction(Object targetObject, UniqueKey uniqueKey, OperationFlag operFlag) throws Exception {
        Object value;
        String tagTable = uniqueKey.table();
        String[] tagKeys = uniqueKey.keys();
        String tagMessage = uniqueKey.message();
        String primaryKey = uniqueKey.primaryKey();
        OperationFlag[] tagFlags = uniqueKey.operationFlags();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Criteria criteria = null;
        if (!StringUtils.isEmpty((Object)primaryKey) && !StringUtils.isEmpty((Object)(value = this.onValueGet(targetObject, primaryKey)))) {
            criteria = Criteria.where((String)primaryKey).ne(value);
        }
        for (String key : tagKeys) {
            Object value2 = this.onValueGet(targetObject, key);
            if (StringUtils.isEmpty((Object)value2)) continue;
            criteria = criteria == null ? Criteria.where((String)key).is(value2) : criteria.and(key).is(value2);
        }
        if (criteria != null) {
            Query query = new Query((CriteriaDefinition)criteria);
            query.limit(1);
            T template = this.getTemplate();
            RowMap resultRow = null;
            try {
                resultRow = (RowMap)template.findOne(query, RowMap.class, tagTable);
            }
            catch (Exception e) {
                this.printStack(this.logger, "UniqueKeyImpl", e, "\u8bf7\u6c42\u6570\u636e\u5e93\u6216\u8bfb\u53d6\u53d1\u751f\u5f02\u5e38");
                throw new Exception("\u8bf7\u6c42\u6570\u636e\u5e93\u6216\u8bfb\u53d6\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
            }
            if (resultRow != null) {
                if (StringUtils.isEmpty((Object)tagMessage)) {
                    throw new Exception("\u6570\u636e\u8fdd\u53cd\u552f\u4e00\u6027\u6570\u636e\u9519\u8bef");
                }
                if (tagMessage.indexOf("{") >= 0 && tagMessage.indexOf("}") > 0) {
                    StringBuffer buffer = new StringBuffer();
                    this.onMessageParse(buffer, tagMessage, targetObject);
                    this.printStack(this.logger, "UniqueKeyImpl", buffer.toString());
                    throw new Exception(buffer.toString());
                }
                throw new Exception(tagMessage);
            }
        }
    }

    @Override
    public void onAction(ServiceSession session, Object targetObject, OperationFlag operFlag, Class<?> beanClass) throws Exception {
        if (targetObject == null) {
            this.printStack(this.logger, "UniqueKeyImpl", "\u8bf7\u6c42\u5199\u5165\u5bf9\u8c61\u7981\u6b62\u4e3a\u7a7a");
            return;
        }
        if (beanClass.isAnnotationPresent(UniqueKeyRepeatedValues.class)) {
            UniqueKey[] uniqueKeys;
            UniqueKeyRepeatedValues uniqueKeyRepeate = beanClass.getAnnotation(UniqueKeyRepeatedValues.class);
            for (UniqueKey uniqueKey : uniqueKeys = uniqueKeyRepeate.value()) {
                this.onAction(targetObject, uniqueKey, operFlag);
            }
        } else if (beanClass.isAnnotationPresent(this.getAnnotationClass())) {
            UniqueKey uniqueKey = (UniqueKey)beanClass.getAnnotation(this.getAnnotationClass());
            this.onAction(targetObject, uniqueKey, operFlag);
        }
    }
}

