/*
 * Decompiled with CFR 0.152.
 */
package com.product.annotation;

import com.alibaba.fastjson.JSONObject;
import com.product.annotation.AssertFalse;
import com.product.annotation.AssertTrue;
import com.product.annotation.DecimalMax;
import com.product.annotation.DecimalMin;
import com.product.annotation.DefaultValue;
import com.product.annotation.Digits;
import com.product.annotation.Email;
import com.product.annotation.Length;
import com.product.annotation.Max;
import com.product.annotation.Min;
import com.product.annotation.NotEmpty;
import com.product.annotation.NotNull;
import com.product.annotation.Null;
import com.product.annotation.Size;
import com.product.annotation.VerificationBase;
import com.product.component.BaseAnnotationService;
import com.product.model.ServiceSession;
import com.product.service.OperationFlag;
import com.product.util.TypeUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class VerificationImpl
extends BaseAnnotationService<VerificationBase> {
    private static final Logger logger = LoggerFactory.getLogger(VerificationImpl.class);
    private final String ruleEMail = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
    private final Pattern pattern = Pattern.compile("^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$");

    public VerificationImpl() {
        super(VerificationBase.class);
    }

    public static void onExistValidator(JSONObject paramsObject, String fieldConfig) throws Exception {
        VerificationImpl.onExistValidator((Map<String, Object>)paramsObject, "\u8bf7\u6c42\u53c2\u6570", fieldConfig);
    }

    public static void onExistValidator(Map<String, Object> paramsObject, String tagName, String fieldConfig) throws Exception {
        List<String> configList = Arrays.asList(fieldConfig.split(";"));
        for (String action : configList) {
            List<String> itemList = Arrays.asList(action.split("\\|"));
            boolean found = false;
            ArrayList<String> messageList = new ArrayList<String>();
            for (String orItem : itemList) {
                String fieldName;
                List<String> childList = Arrays.asList(orItem.split(":"));
                if (childList.size() > 1) {
                    fieldName = childList.get(0);
                    String fieldMsg = childList.get(1);
                    if (!paramsObject.containsKey(fieldName)) {
                        messageList.add(fieldMsg);
                        continue;
                    }
                    found = true;
                    continue;
                }
                if (childList.size() <= 0) continue;
                fieldName = childList.get(0);
                if (!paramsObject.containsKey(fieldName)) {
                    messageList.add(String.format("%1$s\u5fc5\u987b\u5305\u542b\u5b57\u6bb5:%2$s", tagName, fieldName));
                    continue;
                }
                found = true;
            }
            if (found) continue;
            String messageFormat = "%1$s\u5fc5\u987b\u5305\u542b\u53c2\u6570: %2$s";
            if (messageList.size() > 1) {
                messageFormat = "%1$s\u5fc5\u987b\u5305\u542b\u53c2\u6570: %2$s \u4e4b\u4e00";
            }
            throw new Exception(String.format(messageFormat, tagName, String.join((CharSequence)"\u3001", messageList)));
        }
    }

    protected void onNull(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Null nullAnnotation = field.getAnnotation(Null.class);
        OperationFlag[] tagFlags = nullAnnotation.operationFlags();
        String tagMessage = nullAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        if (value != null) {
            if (StringUtils.isEmpty((Object)tagMessage)) {
                throw new Exception(field.getName() + "\u6570\u636e\u5fc5\u987b\u4e3a\u7a7a");
            }
            throw new Exception(tagMessage);
        }
    }

    protected void onNotNull(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        NotNull notNullAnnotation = field.getAnnotation(NotNull.class);
        OperationFlag[] tagFlags = notNullAnnotation.operationFlags();
        String tagMessage = notNullAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        if (value == null) {
            if (StringUtils.isEmpty((Object)tagMessage)) {
                throw new Exception(field.getName() + "\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            throw new Exception(tagMessage);
        }
    }

    protected void onAssertTrue(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        AssertTrue assertAnnotation = field.getAnnotation(AssertTrue.class);
        OperationFlag[] tagFlags = assertAnnotation.operationFlags();
        String tagMessage = assertAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5fc5\u987b\u4e3atrue";
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            if (!boolValue.equals(true)) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onAssertFalse(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        AssertFalse assertAnnotation = field.getAnnotation(AssertFalse.class);
        OperationFlag[] tagFlags = assertAnnotation.operationFlags();
        String tagMessage = assertAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5fc5\u987b\u4e3afalse";
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            if (!boolValue.equals(false)) {
                error = true;
            }
        } else {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDecimalMin(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        BigDecimal valueTag;
        DecimalMin minAnnotation = field.getAnnotation(DecimalMin.class);
        OperationFlag[] tagFlags = minAnnotation.operationFlags();
        String tagMessage = minAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = minAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5927\u4e8e\u6700\u5c0f\u503c" + tagValue;
        if (value == null) {
            return;
        }
        BigDecimal valueSet = TypeUtils.castToBigDecimal(value);
        if (valueSet.compareTo(valueTag = TypeUtils.castToBigDecimal(tagValue)) < 0) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDecimalMax(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        BigDecimal valueTag;
        DecimalMax maxAnnotation = field.getAnnotation(DecimalMax.class);
        OperationFlag[] tagFlags = maxAnnotation.operationFlags();
        String tagMessage = maxAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = maxAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5c0f\u4e8e\u6700\u5927\u503c" + tagValue;
        if (value == null) {
            return;
        }
        BigDecimal valueSet = TypeUtils.castToBigDecimal(value);
        if (valueSet.compareTo(valueTag = TypeUtils.castToBigDecimal(tagValue)) > 0) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDefaultValue(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        DefaultValue defaultAnnotation = field.getAnnotation(DefaultValue.class);
        OperationFlag[] tagFlags = defaultAnnotation.operationFlags();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = defaultAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        if (value == null) {
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToString(tagValue));
            } else if (type.equals(Boolean.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToBoolean(tagValue));
            } else if (type.equals(Integer.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToBigInteger(tagValue));
            } else if (type.equals(Double.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToDouble(tagValue));
            } else if (type.equals(Float.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToFloat(tagValue));
            } else if (type.equals(BigDecimal.class)) {
                this.onValueSet(targetObject, field.getName(), TypeUtils.castToBigDecimal(tagValue));
            } else if (type.equals(Date.class)) {
                this.onValueSet(targetObject, field.getName(), new Date());
            }
        }
    }

    protected void onMin(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Min minAnnotation = field.getAnnotation(Min.class);
        OperationFlag[] tagFlags = minAnnotation.operationFlags();
        String tagMessage = minAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = minAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5927\u4e8e\u6700\u5c0f\u503c" + tagValue;
        if (value == null) {
            return;
        }
        Double valueSet = TypeUtils.castToDouble(value);
        Double valueTag = TypeUtils.castToDouble(tagValue);
        if (valueSet < valueTag) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onMax(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Max maxAnnotation = field.getAnnotation(Max.class);
        OperationFlag[] tagFlags = maxAnnotation.operationFlags();
        String tagMessage = maxAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String tagValue = maxAnnotation.value();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5c0f\u4e8e\u6700\u5927\u503c" + tagValue;
        if (value == null) {
            return;
        }
        Double valueSet = TypeUtils.castToDouble(value);
        Double valueTag = TypeUtils.castToDouble(tagValue);
        if (valueSet > valueTag) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onSize(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Size sizeAnnotation = field.getAnnotation(Size.class);
        OperationFlag[] tagFlags = sizeAnnotation.operationFlags();
        String tagMessage = sizeAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String maxValue = sizeAnnotation.max();
        String minValue = sizeAnnotation.min();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5728\u6700\u5c0f\u503c" + minValue + "\u6700\u5927\u503c" + maxValue + "\u4e4b\u95f4";
        if (value == null) {
            return;
        }
        Double valueSet = TypeUtils.castToDouble(value);
        Double valueMax = TypeUtils.castToDouble(maxValue);
        Double valueMin = TypeUtils.castToDouble(minValue);
        if (valueSet > valueMax) {
            error = true;
        } else if (valueSet < valueMin) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onDigits(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Digits digitsAnnotation = field.getAnnotation(Digits.class);
        OperationFlag[] tagFlags = digitsAnnotation.operationFlags();
        String tagMessage = digitsAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String fraction = digitsAnnotation.fraction();
        String integer = digitsAnnotation.integer();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5728\u53ef\u63a5\u53d7\u7684\u8303\u56f4\u5185";
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString(value);
        int integerDigit = valueSet.lastIndexOf(".");
        int fractionDigit = valueSet.length() - integerDigit;
        Integer fractionValue = TypeUtils.castToInt(fraction);
        Integer integerValue = TypeUtils.castToInt(integer);
        if (integerDigit > integerValue) {
            error = true;
        } else if (fractionDigit > fractionValue) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onEMail(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Null nullAnnotation = field.getAnnotation(Null.class);
        OperationFlag[] tagFlags = nullAnnotation.operationFlags();
        String tagMessage = nullAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u5fc5\u987b\u662f\u6b63\u786e\u7684eMail\u683c\u5f0f";
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString(value);
        Matcher matcher = this.pattern.matcher(valueSet);
        if (!matcher.find()) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onLength(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Length lengthAnnotation = field.getAnnotation(Length.class);
        OperationFlag[] tagFlags = lengthAnnotation.operationFlags();
        String tagMessage = lengthAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        String maxValue = lengthAnnotation.max();
        String minValue = lengthAnnotation.min();
        Object value = this.onValueGet(targetObject, field.getName());
        boolean error = false;
        String message = field.getName() + "\u6570\u636e\u957f\u5ea6\u5fc5\u987b\u5728\u6700\u5c0f\u503c" + minValue + "\u6700\u5927\u503c" + maxValue + "\u4e4b\u95f4";
        if (value == null) {
            return;
        }
        String valueSet = TypeUtils.castToString(value);
        Integer valueMax = TypeUtils.castToInt(maxValue);
        Integer valueMin = TypeUtils.castToInt(minValue);
        if (valueSet.length() > valueMax) {
            error = true;
        } else if (valueSet.length() < valueMin) {
            error = true;
        }
        if (error) {
            if (!StringUtils.isEmpty((Object)tagMessage)) {
                message = tagMessage;
            }
            throw new Exception(message);
        }
    }

    protected void onNotEmpty(Object targetObject, Field field, OperationFlag operFlag) throws Exception {
        Null nullAnnotation = field.getAnnotation(Null.class);
        OperationFlag[] tagFlags = nullAnnotation.operationFlags();
        String tagMessage = nullAnnotation.message();
        boolean actionFlag = false;
        for (OperationFlag flag : tagFlags) {
            if (!operFlag.equals((Object)flag) && !flag.equals((Object)OperationFlag.All)) continue;
            actionFlag = true;
            break;
        }
        if (!actionFlag) {
            return;
        }
        Object value = this.onValueGet(targetObject, field.getName());
        if (value == null) {
            if (StringUtils.isEmpty((Object)tagMessage)) {
                throw new Exception(field.getName() + "\u6570\u636e\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            throw new Exception(tagMessage);
        }
    }

    @Override
    public void onAction(ServiceSession session, Object targetObject, OperationFlag operFlag, Class<?> beanClass) throws Exception {
        Field[] fields;
        if (targetObject == null) {
            this.printStack(logger, "VerificationImpl", "\u8bf7\u6c42\u5199\u5165\u5bf9\u8c61\u7981\u6b62\u4e3a\u7a7a");
            return;
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            if (field.isAnnotationPresent(Null.class)) {
                this.onNull(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(NotNull.class)) {
                this.onNotNull(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(AssertTrue.class)) {
                this.onAssertTrue(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(AssertFalse.class)) {
                this.onAssertFalse(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Min.class)) {
                this.onMin(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Max.class)) {
                this.onMax(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(DecimalMin.class)) {
                this.onDecimalMin(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(DecimalMax.class)) {
                this.onDecimalMax(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Size.class)) {
                this.onSize(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Digits.class)) {
                this.onDigits(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Email.class)) {
                this.onEMail(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(Length.class)) {
                this.onLength(targetObject, field, operFlag);
                continue;
            }
            if (field.isAnnotationPresent(NotEmpty.class)) {
                this.onNotEmpty(targetObject, field, operFlag);
                continue;
            }
            if (!field.isAnnotationPresent(DefaultValue.class)) continue;
            this.onDefaultValue(targetObject, field, operFlag);
        }
    }
}

