/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class AbstractData {
    private FileChannel dataChannel;
    private FileChannel indexChannel;
    private Integer modSize;
    private Integer batchSize;
    private List<String> primaryKeys;
    protected final Integer BLOCK_SIZE = 100;
    protected final Charset CHARSET = Charset.forName("utf-8");
    private SortedMap<Integer, Map<String, Map<String, Object>>> sortedMap;

    public AbstractData(String dataFilename, String indexFilename, Integer modSize, Integer batchSize, boolean createNew, String ... fieldName) throws IOException {
        File fileDat = new File(dataFilename);
        File fileIdx = new File(indexFilename);
        if (createNew) {
            if (fileDat.exists()) {
                fileDat.deleteOnExit();
            }
            if (fileIdx.exists()) {
                fileIdx.deleteOnExit();
            }
        }
        this.dataChannel = FileChannel.open(Paths.get(dataFilename, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
        this.indexChannel = FileChannel.open(Paths.get(indexFilename, new String[0]), StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
        this.modSize = modSize;
        this.batchSize = batchSize;
        this.primaryKeys = Arrays.asList(fieldName);
        this.sortedMap = new TreeMap<Integer, Map<String, Map<String, Object>>>();
    }

    private int getHash(String source) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < source.length(); ++i) {
            hash = (hash ^ source.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        if ((hash += hash << 5) < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }

    public int getHashCode(String source) {
        Integer hashCode = this.getHash(source) % this.getModSize();
        return hashCode;
    }

    public String getDataKey(Map<String, Object> dataMap) {
        List collectData = this.getPrimaryKeys().stream().map(key -> (dataMap.containsKey(key) ? dataMap.get(key) : "none").toString()).collect(Collectors.toList());
        String dataKey = String.join((CharSequence)"#", collectData);
        return dataKey;
    }

    public void onClose() {
        try {
            this.dataChannel.close();
            this.indexChannel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FileChannel getDataChannel() {
        return this.dataChannel;
    }

    public void setDataChannel(FileChannel dataChannel) {
        this.dataChannel = dataChannel;
    }

    public FileChannel getIndexChannel() {
        return this.indexChannel;
    }

    public void setIndexChannel(FileChannel indexChannel) {
        this.indexChannel = indexChannel;
    }

    public Integer getModSize() {
        return this.modSize;
    }

    public void setModSize(Integer modSize) {
        this.modSize = modSize;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public List<String> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(List<String> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public SortedMap<Integer, Map<String, Map<String, Object>>> getSortedMap() {
        return this.sortedMap;
    }

    public void setSortedMap(SortedMap<Integer, Map<String, Map<String, Object>>> sortedMap) {
        this.sortedMap = sortedMap;
    }
}

