/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.product.annotation.NotField;
import com.product.annotation.ReferQuery;
import com.product.component.BaseCallback;
import com.product.component.BaseServiceImpl;
import com.product.component.QueryBlankValuePreFilter;
import com.product.model.AbstractEntityBean;
import com.product.model.BeanConstant;
import com.product.model.RowMap;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.service.AnnotationService;
import com.product.service.OperationFlag;
import com.product.util.FileProcessorUtils;
import com.product.util.TypeUtils;
import com.product.util.UniqueID;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriTemplate;

public abstract class BaseCompomentServiceImpl<X, Y>
extends BaseServiceImpl<Y> {
    private String collectionName;
    private String keyfieldName;
    private boolean useEntID = true;
    private boolean containEntId = true;
    private String entname = "entId";
    protected List<AnnotationService> plugins;

    public List<AnnotationService> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<AnnotationService>();
        }
        return this.plugins;
    }

    public void setPlugins(List<AnnotationService> plugins) {
        this.plugins = plugins;
    }

    public void addPlugins(AnnotationService plugin) {
        this.getPlugins().add(plugin);
    }

    public boolean isUseEntID() {
        return this.useEntID;
    }

    public void setUseEntID(boolean useEntID) {
        this.useEntID = useEntID;
        this.entname = this.isUseEntID() ? "entId" : "ent_id";
    }

    public void setContainEntId(boolean containEntId) {
        this.containEntId = containEntId;
    }

    public String getEntname() {
        return this.entname;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getKeyfieldName() {
        return this.keyfieldName;
    }

    public void setKeyfieldName(String keyfieldName) {
        this.keyfieldName = keyfieldName;
    }

    public BaseCompomentServiceImpl(String collectionName, String keyfieldName) {
        this.setCollectionName(collectionName);
        this.setKeyfieldName(keyfieldName);
    }

    protected abstract X getTemplate();

    protected abstract long onCount(ServiceSession var1, X var2, Query var3, String var4);

    protected abstract <T> List<T> onFind(ServiceSession var1, X var2, Query var3, Class<T> var4, String var5);

    protected abstract void onUpsert(ServiceSession var1, X var2, Query var3, Update var4, String var5);

    protected abstract int onUpsertd(ServiceSession var1, X var2, Query var3, Update var4, String var5);

    protected abstract void onInsert(ServiceSession var1, X var2, JSONObject var3, String var4);

    protected abstract int onInsertd(ServiceSession var1, X var2, JSONObject var3, String var4);

    protected abstract void onRemove(ServiceSession var1, X var2, Query var3, String var4);

    protected abstract int onRemoved(ServiceSession var1, X var2, Query var3, String var4);

    protected abstract int onUpdate(ServiceSession var1, X var2, Query var3, Update var4, String var5);

    protected void onBeforeQuery(ServiceSession session, Criteria criteria) {
    }

    protected void onAfterQuery(List<RowMap> dataList, String keyfieldName) {
        for (RowMap dataMap : dataList) {
            this.onRowAfterQuery(dataMap, keyfieldName);
        }
    }

    protected void onDifferentWarning(ServiceSession session, JSONObject params) throws Exception {
        if (params != null && params.containsKey((Object)this.getEntname())) {
            long paramsEntID = params.getLongValue(this.getEntname());
            if (session.getEnt_id() != paramsEntID) {
                throw new Exception(String.format("\u8bf7\u6c42\u53c2\u6570\u7684\u4f01\u4e1aID\u3010%1$d\u3011\u548c\u767b\u5f55\u4f01\u4e1aID\u3010%2$d\u3011\u4e0d\u4e00\u81f4\uff01", paramsEntID, session.getEnt_id()));
            }
        }
    }

    protected void onQueryForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put(this.getEntname(), (Object)session.getEnt_id());
    }

    protected void onRowAfterQuery(RowMap dataMap, String keyfieldName) {
        if (dataMap.containsKey(keyfieldName)) {
            dataMap.put(keyfieldName, TypeUtils.castToString(dataMap.get(keyfieldName)));
        }
    }

    protected Criteria onParseParamsOne(Criteria criteria, String keyName, Object keyValue) {
        if (keyValue instanceof Map) {
            Criteria[] c;
            Map paramsMap = (Map)keyValue;
            Set keySet = paramsMap.keySet();
            ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
            for (String subKey : keySet) {
                Criteria criteriaMap;
                Object subValue = paramsMap.get(subKey);
                if ("$gt".equalsIgnoreCase(subKey) || ">".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).gt(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$gte".equalsIgnoreCase(subKey) || ">=".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).gte(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$lt".equalsIgnoreCase(subKey) || "<".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).lt(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$lte".equalsIgnoreCase(subKey) || "<=".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).lte(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$ne".equalsIgnoreCase(subKey) || "!=".equalsIgnoreCase(subKey) || "<>".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).ne(subValue);
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if ("$like".equalsIgnoreCase(subKey) || "like".equalsIgnoreCase(subKey)) {
                    criteriaMap = Criteria.where((String)keyName).regex(BaseCompomentServiceImpl.escapeExprSpecialWord(subValue.toString()));
                    criteriaList.add(criteriaMap);
                    continue;
                }
                if (!"$in".equalsIgnoreCase(subKey) && !"in".equalsIgnoreCase(subKey)) continue;
                Object[] oos = subValue instanceof JSONArray ? ((JSONArray)subValue).toArray() : subValue.toString().split(",");
                Criteria criteriaMap2 = Criteria.where((String)keyName).in(oos);
                criteriaList.add(criteriaMap2);
            }
            if (criteria == null) {
                if (criteriaList.size() > 0) {
                    c = new Criteria[criteriaList.size()];
                    criteria = new Criteria().andOperator(criteriaList.toArray(c));
                }
            } else if (criteriaList.size() > 0) {
                c = new Criteria[criteriaList.size()];
                criteria.andOperator(criteriaList.toArray(c));
            }
        } else if (keyValue instanceof JSONArray) {
            JSONArray json = (JSONArray)keyValue;
            Object[] oos = new Object[json.size()];
            for (int i = 0; i < json.size(); ++i) {
                oos[i] = json.get(i);
            }
            if (criteria == null) {
                criteria = Criteria.where((String)keyName).in(oos);
            } else {
                criteria.and(keyName).in(oos);
            }
        } else if (criteria == null) {
            Object[] oos;
            criteria = keyValue instanceof String ? ((oos = ((String)keyValue).split(",")).length > 1 ? Criteria.where((String)keyName).in(oos) : Criteria.where((String)keyName).is(keyValue)) : Criteria.where((String)keyName).is(keyValue);
        } else if (keyValue instanceof String) {
            Object[] oos = ((String)keyValue).split(",");
            if (oos.length > 1) {
                criteria.and(keyName).in(oos);
            } else {
                criteria.and(keyName).is(keyValue);
            }
        } else {
            criteria.and(keyName).is(keyValue);
        }
        return criteria;
    }

    protected List<Criteria> onParseParamsor(String keyName, Object keyValue) {
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        ArrayList<Criteria> clst = new ArrayList<Criteria>();
        if ("$or".equalsIgnoreCase(keyName) || "or".equalsIgnoreCase(keyName)) {
            if (keyValue instanceof JSONObject) {
                JSONObject jo = (JSONObject)keyValue;
                Set ks = jo.keySet();
                for (String k : ks) {
                    Criteria c = this.baseBuildCriteria(k, jo.get((Object)k));
                    if (c == null) continue;
                    clst.add(c);
                }
            } else if (keyValue instanceof JSONArray) {
                JSONArray ja = (JSONArray)keyValue;
                for (int i = 0; i < ja.size(); ++i) {
                    Object oo = ja.get(i);
                    if (!(oo instanceof JSONObject)) continue;
                    JSONObject jo = (JSONObject)oo;
                    Set ks = jo.keySet();
                    for (String k : ks) {
                        Criteria c = this.baseBuildCriteria(k, jo.get((Object)k));
                        if (c == null) continue;
                        clst.add(c);
                    }
                }
            }
            if (clst.size() > 0) {
                Criteria[] c = new Criteria[clst.size()];
                criteriaList.add(new Criteria().orOperator(clst.toArray(c)));
            }
        }
        return criteriaList;
    }

    protected List<Criteria> onParseParams(List<Criteria> criteriaList, String keyName, Object keyValue) {
        ArrayList<Criteria> clst = new ArrayList<Criteria>();
        if ("$or".equalsIgnoreCase(keyName) || "or".equalsIgnoreCase(keyName)) {
            if (keyValue instanceof JSONObject) {
                JSONObject jo = (JSONObject)keyValue;
                Set ks = jo.keySet();
                for (String k : ks) {
                    Criteria c = this.baseBuildCriteria(k, jo.get((Object)k));
                    if (c == null) continue;
                    clst.add(c);
                }
            } else if (keyValue instanceof JSONArray) {
                JSONArray ja = (JSONArray)keyValue;
                for (int i = 0; i < ja.size(); ++i) {
                    Object oo = ja.get(i);
                    if (!(oo instanceof JSONObject)) continue;
                    JSONObject jo = (JSONObject)oo;
                    Set ks = jo.keySet();
                    for (String k : ks) {
                        Criteria c = this.baseBuildCriteria(k, jo.get((Object)k));
                        if (c == null) continue;
                        clst.add(c);
                    }
                }
            }
            if (clst.size() > 0) {
                Criteria[] c = new Criteria[clst.size()];
                criteriaList.add(new Criteria().orOperator(clst.toArray(c)));
            }
        } else {
            Criteria c = this.baseBuildCriteria(keyName, keyValue);
            if (c != null) {
                criteriaList.add(c);
            }
        }
        return criteriaList;
    }

    public static String escapeExprSpecialWord(String keyword) {
        if (!StringUtils.isEmpty((Object)keyword)) {
            String[] fbsArr;
            for (String key : fbsArr = new String[]{"\\", "$", "(", ")", "*", "+", ".", "[", "]", "?", "^", "{", "}", "|"}) {
                if (!keyword.contains(key)) continue;
                keyword = keyword.replace(key, "\\" + key);
            }
        }
        return keyword;
    }

    public Criteria baseBuildCriteria(String key, Object o) {
        List<Criteria> response = this.baseBuildCriteriaList(key, o);
        if (response == null) {
            return null;
        }
        if (response.size() > 1) {
            Criteria[] c = new Criteria[response.size()];
            return new Criteria().andOperator(response.toArray(c));
        }
        if (response.size() == 1) {
            return response.get(0);
        }
        return null;
    }

    public List<Criteria> baseBuildCriteriaList(String key, Object o) {
        ArrayList<Criteria> response = new ArrayList<Criteria>();
        if (StringUtils.isEmpty((Object)o)) {
            Criteria c = new Criteria().orOperator(new Criteria[]{Criteria.where((String)key).exists(false), Criteria.where((String)key).is((Object)"")});
            response.add(c);
            return response;
        }
        if (o instanceof String && !StringUtils.isEmpty((Object)o)) {
            if (this.isExactMatchKey(key)) {
                String[] ss = ((String)o).split(",");
                if (ss.length > 1) {
                    Criteria c = Criteria.where((String)key).in((Object[])ss);
                    response.add(c);
                } else {
                    Criteria c = Criteria.where((String)key).is((Object)ss[0]);
                    response.add(c);
                }
                return response;
            }
            Criteria c = Criteria.where((String)key).is((Object)String.valueOf(o).trim());
            response.add(c);
            return response;
        }
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            Object[] oos = new Object[ja.size()];
            for (int i = 0; i < ja.size(); ++i) {
                Object oo;
                oos[i] = oo = ja.get(i);
            }
            Criteria c = Criteria.where((String)key).in(oos);
            response.add(c);
            return response;
        }
        if (o instanceof JSONObject || o instanceof Map) {
            if (o instanceof Map) {
                o = JSONObject.toJSON((Object)o);
            }
            ArrayList<Criteria> criteria = new ArrayList<Criteria>();
            Set sets = ((JSONObject)o).keySet();
            for (String s : sets) {
                Object oo = ((JSONObject)o).get((Object)s);
                if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s) || "$nin".equalsIgnoreCase(s) || "notin".equalsIgnoreCase(s) || "$all".equalsIgnoreCase(s) || "all".equalsIgnoreCase(s)) {
                    Object[] oos = null;
                    if (oo instanceof JSONArray) {
                        JSONArray ja = (JSONArray)oo;
                        oos = new Object[ja.size()];
                        for (int i = 0; i < ja.size(); ++i) {
                            Object obj;
                            oos[i] = obj = ja.get(i);
                        }
                    } else {
                        oos = oo.toString().split(",");
                    }
                    if ("$in".equalsIgnoreCase(s) || "in".equalsIgnoreCase(s)) {
                        criteria.add(Criteria.where((String)key).in(oos));
                        continue;
                    }
                    if ("$nin".equalsIgnoreCase(s) || "notin".equalsIgnoreCase(s)) {
                        criteria.add(Criteria.where((String)key).nin(oos));
                        continue;
                    }
                    criteria.add(Criteria.where((String)key).all(oos));
                    continue;
                }
                if ("$exists".equalsIgnoreCase(s)) {
                    boolean existso = ((JSONObject)o).getBooleanValue(s);
                    criteria.add(Criteria.where((String)key).exists(existso));
                    continue;
                }
                if ("$is".equalsIgnoreCase(s) || "==".equalsIgnoreCase(s) || "=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).is(oo));
                    continue;
                }
                if ("$ne".equalsIgnoreCase(s) || "<>".equalsIgnoreCase(s) || "!=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).ne(oo));
                    continue;
                }
                if ("like".equalsIgnoreCase(s)) {
                    if (String.valueOf(oo).indexOf("%") < 0) {
                        criteria.add(Criteria.where((String)key).regex(String.valueOf(oo) + "%"));
                        continue;
                    }
                    criteria.add(Criteria.where((String)key).regex(String.valueOf(oo)));
                    continue;
                }
                if ("$gt".equalsIgnoreCase(s) || ">".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).gt(oo));
                    continue;
                }
                if ("$gte".equalsIgnoreCase(s) || ">=".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).gte(oo));
                    continue;
                }
                if ("$lt".equalsIgnoreCase(s) || "<".equalsIgnoreCase(s)) {
                    criteria.add(Criteria.where((String)key).lt(oo));
                    continue;
                }
                if (!"$lte".equalsIgnoreCase(s) && !"<=".equalsIgnoreCase(s)) continue;
                criteria.add(Criteria.where((String)key).lte(oo));
            }
            if (criteria.size() > 0) {
                return criteria;
            }
        } else {
            Criteria c = Criteria.where((String)key).is(o);
            response.add(c);
            return response;
        }
        return response;
    }

    private boolean isExactMatchKey(String key) {
        if (key.endsWith("code")) {
            return false;
        }
        return !key.endsWith("status");
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject, Boolean trimBlankValueFlag) {
        if (trimBlankValueFlag.booleanValue()) {
            paramsObject = QueryBlankValuePreFilter.getInstance().trimBlankValue(paramsObject);
        }
        return this.onQueryCallback(session, paramsObject, null);
    }

    public ServiceResponse onQueryWithHint(ServiceSession session, JSONObject paramsObject, Boolean BeanFalg) {
        if (BeanFalg.booleanValue()) {
            Field[] fields = this.beanClass.getDeclaredFields();
            StringBuffer fieldValue = new StringBuffer();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.isAnnotationPresent(ReferQuery.class) || field.isAnnotationPresent(NotField.class)) continue;
                if (i == fields.length - 1) {
                    fieldValue.append(fields[i].getName());
                    continue;
                }
                fieldValue.append(fields[i].getName()).append(",");
            }
            paramsObject.put("fields", (Object)fieldValue);
            if (paramsObject.containsKey((Object)"order_field")) {
                this.removeOrderFld(paramsObject, fields);
            }
        }
        return this.onQuery(session, paramsObject, true);
    }

    private List<String> onSplit(String source) {
        ArrayList<String> responseList = new ArrayList<String>();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)source)) {
            Iterator iterator = Splitter.on((String)",").split((CharSequence)source).iterator();
            while (iterator.hasNext()) {
                responseList.add((String)iterator.next());
            }
        }
        return responseList;
    }

    private void removeOrderFld(JSONObject paramsObject, Field[] fields) {
        if (paramsObject.containsKey((Object)"order_field") && !StringUtils.isEmpty((Object)"order_field")) {
            int i;
            List<String> fld_list = this.onSplit(paramsObject.getString("order_field"));
            List<Object> sort_list = new ArrayList();
            if (paramsObject.containsKey((Object)"order_direction") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_direction"))) {
                sort_list = this.onSplit(paramsObject.getString("order_direction"));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            int fld_size = fld_list.size();
            int sort_size = sort_list.size();
            for (i = 0; i < fld_size; ++i) {
                if (StringUtils.isEmpty((Object)fld_list.get(i))) continue;
                if (sort_size > i && !StringUtils.isEmpty((Object)fld_list.get(i).trim())) {
                    String sortFlag = StringUtils.isEmpty((Object)((String)sort_list.get(i)).trim()) ? "ASC" : ((String)sort_list.get(i)).trim();
                    map.put(fld_list.get(i), sortFlag);
                    continue;
                }
                map.put(fld_list.get(i), "asc");
            }
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.isAnnotationPresent(ReferQuery.class) && !field.isAnnotationPresent(NotField.class) || !map.containsKey(field.getName())) continue;
                map.remove(field.getName());
            }
            if (map.isEmpty()) {
                paramsObject.remove((Object)"order_field");
                paramsObject.remove((Object)"order_direction");
            } else {
                StringBuffer orderfield = new StringBuffer();
                StringBuffer orderSort = new StringBuffer();
                for (Map.Entry entry : map.entrySet()) {
                    String mapKey = (String)entry.getKey();
                    String mapValue = (String)entry.getValue();
                    System.out.println(mapKey + ":" + mapValue);
                    orderfield.append(mapKey).append(",");
                    orderSort.append(mapValue).append(",");
                }
                orderfield.deleteCharAt(orderfield.length() - 1);
                orderSort.deleteCharAt(orderSort.length() - 1);
                paramsObject.put("order_field", (Object)orderfield.toString());
                paramsObject.put("order_direction", (Object)orderSort.toString());
            }
        }
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        return this.onQuery(session, paramsObject, true);
    }

    public ServiceResponse onQuery(boolean searchPluginFlag, ServiceSession session, JSONObject paramsObject) {
        paramsObject.put("searchPluginFlag", (Object)false);
        return this.onQuery(session, paramsObject, true);
    }

    public ServiceResponse onQueryCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        Object keyValue;
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put("fields", 1);
        keyMap.put("order_field", 1);
        keyMap.put("order_direction", 1);
        keyMap.put("page_no", 1);
        keyMap.put("page_size", 1);
        if (paramsObject.containsKey((Object)this.getEntname())) {
            try {
                this.onQueryForEntID(session, paramsObject);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure(session, "10000", e.getMessage());
            }
        } else if (this.containEntId) {
            paramsObject.put(this.getEntname(), (Object)session.getEnt_id());
        }
        String keyfieldName = this.getKeyfieldName();
        if (paramsObject.containsKey((Object)keyfieldName) && (keyValue = paramsObject.get((Object)keyfieldName)) != null) {
            if (keyValue instanceof Long) {
                paramsObject.put(keyfieldName, (Object)TypeUtils.castToLong(paramsObject.get((Object)keyfieldName)));
            } else if (keyValue instanceof Map) {
                keyMap.remove(keyfieldName);
            }
        }
        Set keySet = paramsObject.keySet();
        ArrayList orList = new ArrayList();
        List<Criteria> criteriaList = new ArrayList<Criteria>();
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName) || !"$or".equalsIgnoreCase(keyName) && !"or".equalsIgnoreCase(keyName) && AbstractEntityBean.isTransientField(this.getBeanClass(), keyName)) continue;
            criteriaList = this.onParseParams(criteriaList, keyName, paramsObject.get((Object)keyName));
        }
        Query query = new Query();
        query = this.baseCreateQuery(query, criteriaList);
        String collectionName = this.getCollectionName();
        long rowCount = this.onCount(session, template, query, collectionName);
        JSONObject response = new JSONObject();
        response.put("total_results", (Object)rowCount);
        rowCount = 1L;
        if (rowCount > 0L) {
            int i;
            Sort order = null;
            Integer pageno = BeanConstant.QueryPage.DEFAULT_PAGENO;
            Integer pageSize = BeanConstant.QueryPage.DEFAULT_PAGESIZE;
            if (paramsObject.containsKey((Object)"page_no")) {
                pageno = paramsObject.getInteger("page_no") - 1;
            }
            if (paramsObject.containsKey((Object)"page_size")) {
                pageSize = paramsObject.getInteger("page_size");
            }
            if (pageno < 0) {
                pageno = 0;
            }
            if (paramsObject.containsKey((Object)"order_field") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_field"))) {
                if (paramsObject.containsKey((Object)"order_direction") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"order_direction"))) {
                    String[] dirs = paramsObject.getString("order_direction").split(",");
                    String[] flds = paramsObject.getString("order_field").split(",");
                    ArrayList<Sort.Order> lst = new ArrayList<Sort.Order>();
                    for (i = 0; i < flds.length; ++i) {
                        if (i < dirs.length) {
                            lst.add(new Sort.Order(Sort.Direction.fromString((String)dirs[i]), flds[i].trim()));
                            continue;
                        }
                        lst.add(Sort.Order.by((String)flds[i].trim()));
                    }
                    order = Sort.by(lst);
                } else {
                    order = Sort.by((String[])paramsObject.getString("order_field").split(","));
                }
            }
            org.springframework.data.mongodb.core.query.Field flds = query.fields();
            if (paramsObject.containsKey((Object)"fields") && !StringUtils.isEmpty((Object)paramsObject.get((Object)"fields"))) {
                String[] paramFields = paramsObject.getString("fields").split(",");
                HashSet<String> set = new HashSet<String>();
                paramFields = this.checkFields(paramFields, set);
                if (set.size() > 0) {
                    return ServiceResponse.buildFailure(session, "10006", String.format("fields\u7684\u3010%1$s\u3011\u8bf7\u6c42\u53c2\u6570\u9519\u8bef", set.toArray()));
                }
                for (i = 0; i < paramFields.length; ++i) {
                    if (StringUtils.isEmpty((Object)paramFields[i].trim())) continue;
                    flds.include(paramFields[i].trim());
                }
            } else {
                flds.include("*");
            }
            query.with((Pageable)PageRequest.of((int)pageno, (int)pageSize));
            if (order != null) {
                query.with(order);
            }
            List<RowMap> dataList = this.onFind(session, template, query, RowMap.class, collectionName);
            if (!paramsObject.containsKey((Object)"searchPluginFlag")) {
                List<AnnotationService> tagPlugins = this.getPlugins();
                for (AnnotationService plugin : tagPlugins) {
                    try {
                        plugin.onAction(session, dataList, OperationFlag.afterQuery, this.getBeanClass());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.onAfterQuery(dataList, keyfieldName);
            response.put(collectionName, dataList);
        } else {
            response.put(collectionName, new ArrayList());
        }
        return ServiceResponse.buildSuccess(response);
    }

    public Query baseCreateQuery(Query query, List<Criteria> criteriaList) {
        if (criteriaList.size() > 0) {
            Boolean falg = true;
            if (!falg.booleanValue()) {
                for (int i = 0; i < criteriaList.size(); ++i) {
                    query.addCriteria((CriteriaDefinition)criteriaList.get(i));
                }
            } else {
                Criteria c = null;
                int firCriteriaIdx = -1;
                while (((c = criteriaList.get(++firCriteriaIdx)).getCriteriaObject().toString().trim().startsWith("{ \"$and\"") || c.getCriteriaObject().toString().startsWith("{\"$and\"")) && firCriteriaIdx < criteriaList.size() - 1) {
                }
                if (criteriaList.size() > 1) {
                    Criteria[] cc = new Criteria[criteriaList.size() - 1];
                    int j = 0;
                    for (int i = 0; i < criteriaList.size(); ++i) {
                        if (i == firCriteriaIdx) continue;
                        cc[j] = criteriaList.get(i);
                        ++j;
                    }
                    c.andOperator(cc);
                }
                query.addCriteria((CriteriaDefinition)c);
            }
        }
        return query;
    }

    private String[] checkFields(String[] paramFields, Set<String> returnSet) {
        AccessibleObject[] modelFields = this.beanClass.getDeclaredFields();
        String[] modelFieldNames = new String[modelFields.length];
        Field.setAccessible(modelFields, true);
        boolean entIdflag = true;
        for (int i = 0; i < modelFieldNames.length; ++i) {
            modelFieldNames[i] = ((Field)modelFields[i]).getName();
        }
        HashSet<String> set = new HashSet<String>();
        for (String paramfield : paramFields) {
            if ("entId".equals(paramfield)) {
                entIdflag = false;
            }
            set.add(paramfield);
        }
        for (String modelField : modelFieldNames) {
            set.remove(modelField);
        }
        returnSet.addAll(set);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(paramFields));
        for (AccessibleObject field : modelFields) {
            if (!field.isAnnotationPresent(ReferQuery.class) && !field.isAnnotationPresent(NotField.class)) continue;
            list.remove(((Field)field).getName());
        }
        if (entIdflag) {
            list.add("entId");
        }
        return list.toArray(new String[list.size()]);
    }

    protected void onBeforeUpdate(ServiceSession session, Criteria criteria, Update update) {
    }

    protected int doUpdate(ServiceSession session, X template, Query query, Update update, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        return this.onUpsertd(session, template, query, update, collectionName);
    }

    protected void onRowUpdateForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put(this.getEntname(), (Object)session.getEnt_id());
    }

    protected void onAfterRowUpdate(X template, Query query, JSONObject params) {
    }

    @Transactional
    public ServiceResponse onUpdate(ServiceSession session, JSONObject paramsObject) {
        return this.onUpdateCallback(session, paramsObject, null);
    }

    public ServiceResponse onUpdateCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        String collectionName = this.getCollectionName();
        String keyfieldName = this.getKeyfieldName();
        if (paramsObject.containsKey((Object)collectionName)) {
            JSONArray response = new JSONArray();
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Object keyName2;
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (callback != null) {
                        callback.onBeforeAction(params);
                    }
                    if (params.containsKey((Object)this.getEntname()) && this.containEntId) {
                        try {
                            this.onRowUpdateForEntID(session, params);
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure(session, "10000", e.getMessage());
                        }
                    }
                    if (params.containsKey((Object)keyfieldName)) {
                        if (StringUtils.isEmpty((Object)params.get((Object)keyfieldName))) {
                            params.put(keyfieldName, (Object)UniqueID.getUniqueID(true));
                        } else {
                            params.put(keyfieldName, (Object)TypeUtils.castToLong(params.get((Object)keyfieldName)));
                        }
                    } else {
                        return ServiceResponse.buildFailure(session, "50000", "\u8bf7\u6c42\u6761\u4ef6\u7f3a\u5185\u90e8ID\u5173\u952e\u5b57{0}", keyfieldName);
                    }
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put(keyfieldName, 1);
                    Criteria criteria = Criteria.where((String)keyfieldName).is(params.get((Object)keyfieldName));
                    if (params.containsKey((Object)this.getEntname()) && !this.getEntname().equals(keyfieldName)) {
                        criteria.and(this.getEntname()).is(params.get((Object)this.getEntname()));
                        keyMap.put(this.getEntname(), 1);
                    }
                    Update update = new Update();
                    Set keySet = params.keySet();
                    for (Object keyName2 : keySet) {
                        if (keyMap.containsKey(keyName2) || AbstractEntityBean.isTransientField(this.getBeanClass(), (String)keyName2)) continue;
                        this.onAssistMap(update, (Map<String, Object>)params, (String)keyName2);
                    }
                    List<AnnotationService> tagPlugins = this.getPlugins();
                    keyName2 = tagPlugins.iterator();
                    while (keyName2.hasNext()) {
                        AnnotationService plugin = (AnnotationService)keyName2.next();
                        try {
                            plugin.onAction(session, params, OperationFlag.Update, this.getBeanClass());
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure(session, "50000", "\u66f4\u65b0\u524d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38:{0}", e.getMessage() + "");
                        }
                    }
                    this.onBeforeUpdate(session, criteria, update);
                    Query query = new Query((CriteriaDefinition)criteria);
                    System.out.println(query.toString());
                    int n = this.doUpdate(session, template, query, update, callback);
                    if (n > 0) {
                        response.add(params.get((Object)keyfieldName));
                    } else {
                        response.add((Object)0);
                    }
                    this.onAfterRowUpdate(template, query, params);
                }
            }
            return ServiceResponse.buildSuccess(response);
        }
        JSONObject response = new JSONObject();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put(keyfieldName, 1);
        if (callback != null) {
            callback.onBeforeAction(paramsObject);
        }
        if (paramsObject.containsKey((Object)this.getEntname()) && this.containEntId) {
            try {
                this.onRowUpdateForEntID(session, paramsObject);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure(session, "10000", e.getMessage());
            }
            keyMap.put(this.getEntname(), 1);
        }
        if (paramsObject.containsKey((Object)keyfieldName)) {
            if (StringUtils.isEmpty((Object)paramsObject.get((Object)keyfieldName))) {
                paramsObject.put(keyfieldName, (Object)UniqueID.getUniqueID(true));
            } else {
                paramsObject.put(keyfieldName, (Object)TypeUtils.castToLong(paramsObject.get((Object)keyfieldName)));
            }
        } else {
            return ServiceResponse.buildFailure(session, "50000", "\u8bf7\u6c42\u6761\u4ef6\u7f3a\u5185\u90e8ID\u5173\u952e\u5b57{0}", keyfieldName);
        }
        Criteria criteria = Criteria.where((String)keyfieldName).is(paramsObject.get((Object)keyfieldName));
        if (paramsObject.containsKey((Object)this.getEntname()) && !this.getEntname().equals(keyfieldName)) {
            criteria.and(this.getEntname()).is(paramsObject.get((Object)this.getEntname()));
            keyMap.put(this.getEntname(), 1);
        }
        List<AnnotationService> tagPlugins = this.getPlugins();
        for (AnnotationService plugin : tagPlugins) {
            try {
                plugin.onAction(session, paramsObject, OperationFlag.Update, this.getBeanClass());
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure(session, "50000", "\u66f4\u65b0\u524d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38:{0}", e.getMessage() + "");
            }
        }
        Update update = new Update();
        Set keySet = paramsObject.keySet();
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName) || AbstractEntityBean.isTransientField(this.getBeanClass(), keyName)) continue;
            this.onAssistMap(update, (Map<String, Object>)paramsObject, keyName);
        }
        this.onBeforeUpdate(session, criteria, update);
        Query query = new Query((CriteriaDefinition)criteria);
        int n = this.doUpdate(session, template, query, update, callback);
        if (n <= 0) {
            return ServiceResponse.buildFailure(session, "10011", "\u66f4\u65b0\u5931\u8d25!");
        }
        response.put(keyfieldName, paramsObject.get((Object)keyfieldName));
        this.onAfterRowUpdate(template, query, paramsObject);
        return ServiceResponse.buildSuccess(response);
    }

    protected void onBeforeInsert(ServiceSession session, JSONObject dataRow) {
    }

    protected void doInsert(ServiceSession session, X template, JSONObject dataRow, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        this.onInsert(session, template, dataRow, collectionName);
    }

    protected int doInsertd(ServiceSession session, X template, JSONObject dataRow, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        return this.onInsertd(session, template, dataRow, collectionName);
    }

    protected void onAfterRowInsert(X template, JSONObject dataRow) {
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse onInsert(ServiceSession session, JSONObject paramsObject) {
        return this.onInsertCallback(session, paramsObject, null);
    }

    public ServiceResponse onInsertCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        String collectionName = this.getCollectionName();
        String keyfieldName = this.getKeyfieldName();
        long id = 0L;
        JSONArray idArray = new JSONArray();
        if (paramsObject.containsKey((Object)collectionName)) {
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Object keyName2;
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (!params.containsKey((Object)this.getEntname()) && this.containEntId) {
                        params.put(this.getEntname(), (Object)session.getEnt_id());
                    }
                    if (StringUtils.isEmpty((Object)params.get((Object)keyfieldName))) {
                        id = UniqueID.getUniqueID(true);
                        params.put(keyfieldName, (Object)id);
                    } else {
                        id = TypeUtils.castToLong(params.get((Object)keyfieldName));
                        params.put(keyfieldName, (Object)id);
                    }
                    JSONObject dataRow = new JSONObject();
                    Set keySet = params.keySet();
                    for (Object keyName2 : keySet) {
                        if (AbstractEntityBean.isTransientField(this.getBeanClass(), (String)keyName2)) continue;
                        this.onAssistMap(dataRow, (Map<String, Object>)params, (String)keyName2, (String)keyName2);
                    }
                    List<AnnotationService> tagPlugins = this.getPlugins();
                    keyName2 = tagPlugins.iterator();
                    while (keyName2.hasNext()) {
                        AnnotationService plugin = (AnnotationService)keyName2.next();
                        try {
                            plugin.onAction(session, dataRow, OperationFlag.Insert, this.getBeanClass());
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure(session, "50000", "\u63d2\u5165\u524d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38:{0}", e.getMessage() + "");
                        }
                    }
                    if (callback != null) {
                        callback.onBeforeAction(dataRow);
                    }
                    this.onBeforeInsert(session, dataRow);
                    int n = this.doInsertd(session, template, dataRow, callback);
                    if (n > 0) {
                        idArray.add((Object)id);
                    } else {
                        idArray.add((Object)"0");
                    }
                    this.onAfterRowInsert(template, dataRow);
                    if (callback == null) continue;
                    callback.onAfterAction(dataRow);
                }
            }
        } else {
            HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
            keyMap.put(keyfieldName, 1);
            if (!paramsObject.containsKey((Object)this.getEntname()) && this.containEntId) {
                paramsObject.put(this.getEntname(), (Object)session.getEnt_id());
            }
            if (StringUtils.isEmpty((Object)paramsObject.get((Object)keyfieldName))) {
                id = UniqueID.getUniqueID(true);
                paramsObject.put(keyfieldName, (Object)id);
            } else {
                id = TypeUtils.castToLong(paramsObject.get((Object)keyfieldName));
                paramsObject.put(keyfieldName, (Object)id);
            }
            JSONObject dataRow = new JSONObject();
            Set keySet = paramsObject.keySet();
            for (Object keyName : keySet) {
                if (AbstractEntityBean.isTransientField(this.getBeanClass(), (String)keyName)) continue;
                try {
                    this.onAssistMap(dataRow, (Map<String, Object>)paramsObject, (String)keyName, (String)keyName);
                }
                catch (NullPointerException npe) {
                    System.out.println(String.format("\u6267\u884c\u5217[%1$s]\u7c7b\u578b\u8f6c\u6362\u7a7a\u5f02\u5e38!", keyName));
                    throw npe;
                }
            }
            List<AnnotationService> tagPlugins = this.getPlugins();
            for (AnnotationService plugin : tagPlugins) {
                try {
                    plugin.onAction(session, dataRow, OperationFlag.Insert, this.getBeanClass());
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure(session, "50000", "\u63d2\u5165\u524d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38:{0}", e.getMessage() + "");
                }
            }
            if (callback != null) {
                callback.onBeforeAction(dataRow);
            }
            this.onBeforeInsert(session, dataRow);
            int n = this.doInsertd(session, template, dataRow, callback);
            if (n <= 0) {
                return ServiceResponse.buildFailure(session, "10011", "\u66f4\u65b0\u5931\u8d25!");
            }
            this.onAfterRowInsert(template, dataRow);
        }
        if (paramsObject.containsKey((Object)collectionName)) {
            return ServiceResponse.buildSuccess(idArray);
        }
        JSONObject response = new JSONObject();
        response.put(keyfieldName, (Object)id);
        return ServiceResponse.buildSuccess(response);
    }

    protected void onBeforeDelete(ServiceSession session, Criteria criteria) {
    }

    protected int doDelete(ServiceSession session, X template, Query query, BaseCallback callback) {
        String collectionName = this.getCollectionName();
        return this.onRemoved(session, template, query, collectionName);
    }

    protected void onDeleteForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put(this.getEntname(), (Object)session.getEnt_id());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        return this.onDeleteCallback(session, paramsObject, null);
    }

    public ServiceResponse onDeleteCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        String collectionName = this.getCollectionName();
        String keyfieldName = this.getKeyfieldName();
        if (paramsObject.containsKey((Object)collectionName)) {
            JSONArray response = new JSONArray();
            Object dataObject = paramsObject.get((Object)collectionName);
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(collectionName);
                for (int i = 0; i < paramsArray.size(); ++i) {
                    Object keyName2;
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put("fields", 1);
                    keyMap.put("order_field", 1);
                    keyMap.put("order_direction", 1);
                    keyMap.put("page_no", 1);
                    keyMap.put("page_size", 1);
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (callback != null) {
                        callback.onBeforeAction(params);
                    }
                    if (params.containsKey((Object)this.getEntname())) {
                        try {
                            this.onDeleteForEntID(session, paramsObject);
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure(session, "10000", e.getMessage());
                        }
                    }
                    if (params.containsKey((Object)keyfieldName)) {
                        params.put(keyfieldName, (Object)TypeUtils.castToLong(params.get((Object)keyfieldName)));
                    }
                    Set keySet = params.keySet();
                    Criteria criteria = null;
                    for (Object keyName2 : keySet) {
                        if (keyMap.containsKey(keyName2) || AbstractEntityBean.isTransientField(this.getBeanClass(), (String)keyName2)) continue;
                        criteria = this.onParseParamsOne(criteria, (String)keyName2, params.get(keyName2));
                    }
                    if (criteria == null) continue;
                    List<AnnotationService> tagPlugins = this.getPlugins();
                    keyName2 = tagPlugins.iterator();
                    while (keyName2.hasNext()) {
                        AnnotationService plugin = (AnnotationService)keyName2.next();
                        try {
                            plugin.onAction(session, params, OperationFlag.Delete, this.getBeanClass());
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure(session, "50000", "\u5220\u9664\u524d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38:{0}", e.getMessage() + "");
                        }
                    }
                    this.onBeforeDelete(session, criteria);
                    Query query = new Query(criteria);
                    int n = this.doDelete(session, template, query, callback);
                    if (n > 0) {
                        response.add(params.get((Object)keyfieldName));
                        continue;
                    }
                    response.add((Object)0);
                }
            }
            return ServiceResponse.buildSuccess(response);
        }
        JSONObject response = new JSONObject();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put("fields", 1);
        keyMap.put("order_field", 1);
        keyMap.put("order_direction", 1);
        keyMap.put("page_no", 1);
        keyMap.put("page_size", 1);
        if (callback != null) {
            callback.onBeforeAction(paramsObject);
        }
        if (paramsObject.containsKey((Object)this.getEntname())) {
            try {
                this.onDeleteForEntID(session, paramsObject);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure(session, "10000", e.getMessage());
            }
        }
        if (paramsObject.containsKey((Object)keyfieldName)) {
            paramsObject.put(keyfieldName, (Object)TypeUtils.castToLong(paramsObject.get((Object)keyfieldName)));
        }
        Set keySet = paramsObject.keySet();
        Criteria criteria = null;
        for (Object keyName : keySet) {
            if (keyMap.containsKey(keyName) || AbstractEntityBean.isTransientField(this.getBeanClass(), (String)keyName)) continue;
            criteria = this.onParseParamsOne(criteria, (String)keyName, paramsObject.get(keyName));
        }
        if (criteria != null) {
            List<AnnotationService> tagPlugins = this.getPlugins();
            for (AnnotationService plugin : tagPlugins) {
                try {
                    plugin.onAction(session, paramsObject, OperationFlag.Delete, this.getBeanClass());
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure(session, "50000", "\u5220\u9664\u524d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38:{0}", e.getMessage() + "");
                }
            }
            this.onBeforeDelete(session, criteria);
            Query query = new Query(criteria);
            int n = this.doDelete(session, template, query, callback);
            if (n > 0) {
                response.put(keyfieldName, paramsObject.get((Object)keyfieldName));
            } else {
                return ServiceResponse.buildFailure(session, "10003", "\u5220\u9664\u5931\u8d25!");
            }
        }
        return ServiceResponse.buildSuccess(response);
    }

    protected List<Map<String, Object>> onBeforeImportData(String params, MultipartFile file) throws Exception {
        List<Map<String, Object>> dataList = null;
        JSONObject jsonparam = JSONObject.parseObject((String)params);
        String type = jsonparam.getString("type");
        if (!type.equals("plain")) {
            if (file == null) {
                throw new Exception("\u7f3a\u5c11\u4e0a\u4f20\u6587\u4ef6");
            }
            dataList = FileProcessorUtils.parseFile(jsonparam, file.getInputStream());
        } else {
            dataList = FileProcessorUtils.parseFile(jsonparam);
        }
        return dataList;
    }

    public ServiceResponse onImportData(ServiceSession session, String params, MultipartFile file) throws Exception {
        ServiceResponse response = null;
        List<Map<String, Object>> dataList = this.onBeforeImportData(params, file);
        for (int i = 0; i < dataList.size(); ++i) {
            Map<String, Object> map = dataList.get(i);
            JSONObject paramsObject = JSONObject.parseObject((String)JSON.toJSONString(map));
            this.onUpdate(session, paramsObject);
        }
        response = ServiceResponse.buildSuccess("");
        return response;
    }

    protected String onBeforeExportData(String params) throws Exception {
        return params;
    }

    public ServiceResponse onExportData(ServiceSession session, String params, OutputStream os) {
        try {
            JSONObject jsonparam = JSONObject.parseObject((String)this.onBeforeExportData(params));
            String type = jsonparam.getString("type");
            String url = jsonparam.getString("url");
            String jparams = jsonparam.getString("params");
            if (session != null) {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("session", JSON.toJSONString((Object)session));
                UriTemplate template = new UriTemplate(url);
                url = template.expand(paramsMap).toString();
            }
            String cols = jsonparam.getString("cols");
            String tname = jsonparam.getString("tname");
            String istree = jsonparam.getString("istree");
            String childname = jsonparam.getString("childname");
            String header = jsonparam.getString("header");
            FileProcessorUtils.exportFile(type, url, jparams, cols, tname, header, istree, childname, os);
            return ServiceResponse.buildSuccess("");
        }
        catch (Exception e) {
            ServiceResponse sr = new ServiceResponse();
            sr.setReturncode("50000");
            sr.setData("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return sr;
        }
    }

    public ServiceResponse onExportDataDirect(ServiceSession session, String params, OutputStream os) {
        try {
            JSONObject jsonparam = JSONObject.parseObject((String)params);
            String type = jsonparam.getString("type");
            String url = jsonparam.getString("url");
            String jparams = jsonparam.getString("params");
            String cols = jsonparam.getString("cols");
            String tname = jsonparam.getString("tname");
            String istree = jsonparam.getString("istree");
            String childname = jsonparam.getString("childname");
            String header = jsonparam.getString("header");
            FileProcessorUtils.exportFile(type, url, jparams, cols, tname, header, istree, childname, os);
            return ServiceResponse.buildSuccess("");
        }
        catch (Exception e) {
            e.printStackTrace();
            ServiceResponse sr = new ServiceResponse();
            sr.setReturncode("50000");
            sr.setData("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            return sr;
        }
    }

    public ServiceResponse onSave(ServiceSession session, JSONObject paramsObject) throws Exception {
        JSONArray dataList = paramsObject.getJSONArray(this.getCollectionName());
        JSONArray returnarray = new JSONArray();
        for (int i = 0; i < dataList.size(); ++i) {
            JSONObject dataMap = dataList.getJSONObject(i);
            String dataFlag = (String)dataMap.get((Object)"_flag");
            if ("I".equalsIgnoreCase(dataFlag)) {
                returnarray.add((Object)this.onInsert(session, dataMap));
                continue;
            }
            if ("U".equalsIgnoreCase(dataFlag)) {
                returnarray.add((Object)this.onUpdate(session, dataMap));
                continue;
            }
            if ("D".equalsIgnoreCase(dataFlag)) {
                returnarray.add((Object)this.onDelete(session, dataMap));
                continue;
            }
            returnarray.add((Object)this.onQuery(session, dataMap));
        }
        return ServiceResponse.buildSuccess(returnarray);
    }
}

