/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.product.component.AuthorityBaseServiceImpl;
import com.product.controller.ProductReflect;
import com.product.language.MessageSourceHelper;
import com.product.storage.slice.filter.SliceBase;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.product.util.UniqueID;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class BaseConfiger {
    private static final Logger log = LoggerFactory.getLogger(BaseConfiger.class);
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    SqlSessionFactoryBean sqlSessionFactory;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean
    SpringContext.HookBean myBean() {
        return new SpringContext.HookBean();
    }

    @Bean(name={"UniqueID"})
    UniqueID onUniqueIDTemplate() throws Exception {
        UniqueID instance = new UniqueID();
        instance.setHostId("120");
        return instance;
    }

    @Bean(name={"datasource"})
    @Qualifier(value="datasource")
    @ConditionalOnProperty(prefix="spring.datasource", name={"jdbcUrl"})
    @ConfigurationProperties(prefix="spring.datasource")
    @Primary
    public DataSource onHikariDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean(name={"JdbcTemplate"})
    public JdbcTemplate onJdbcTemplate(@Qualifier(value="datasource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name={"sqlSessionTemplate"})
    public SqlSessionTemplate sessionTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Autowired
    @Bean(name={"sqlSessionFactory"})
    @Qualifier(value="sqlSessionFactory")
    @Primary
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="datasource") DataSource datasource) {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        return service;
    }

    @Autowired
    @Bean(name={"StorageOperation"})
    @Qualifier(value="StorageOperation")
    @Primary
    public FMybatisTemplate onFMybatisTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Autowired
    @Bean(name={"primaryTransactionManager"})
    @Primary
    public PlatformTransactionManager transactionManager(@Qualifier(value="datasource") DataSource datasource) {
        return new DataSourceTransactionManager(datasource);
    }

    @Bean(name={"ServiceMethodReflect"})
    public ProductReflect onProductReflect() {
        return new ProductReflect();
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource onResourceBundleMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"message"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean(name={"messageSourceHelper"})
    public MessageSourceHelper onMessageSourceHelper() {
        MessageSourceHelper messageSourceHelper = new MessageSourceHelper();
        messageSourceHelper.setMessageSource(this.onResourceBundleMessageSource());
        return messageSourceHelper;
    }

    @Bean(name={"authorityBaseServiceImpl"})
    public AuthorityBaseServiceImpl onAuthorityBaseServiceImpl() {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = new AuthorityBaseServiceImpl();
        return authorityBaseServiceImpl;
    }

    @Bean(initMethod="init")
    @ConditionalOnMissingBean
    public SliceBase initSliceBase() {
        return new SliceBase();
    }
}

