/*
 * Decompiled with CFR 0.152.
 */
package com.product.controller;

import com.alibaba.fastjson.JSON;
import com.product.controller.ProductReflect;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.slice.filter.SliceBase;
import com.product.util.StatisticUtils;
import com.product.util.Utils;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.StringUtils;

public class ProductController {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ProductController.class);
    @Autowired
    HttpServletRequest request;
    @Autowired
    HttpServletResponse response;
    @Autowired
    @Qualifier(value="ServiceMethodReflect")
    ProductReflect rcm;
    @Autowired
    public SliceBase sliceBase;

    public String onRestService(String method, String session, String ent_id, String user_id, String user_name, String locale, String encrypt, String param) {
        return this.onRestService(method, session, null, ent_id, user_id, user_name, locale, encrypt, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onRestService(String method, String session, String versionCode, String ent_id, String user_id, String user_name, String locale, String encrypt, String param) {
        long startTimeMillis = System.currentTimeMillis();
        StatisticUtils.onIncrementMethod(method, startTimeMillis);
        LOGGER.debug(String.format("---->method=%1$s session=%2$s param=%3$s ent_id=%4$s user_id=%5$s user_name=%6$s locale=%7$s", method + "", session + "", param + "", ent_id + "", user_id + "", user_name + "", locale + ""));
        try {
            Object retdata;
            if (StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)ent_id)) {
                ServiceSession ss = new ServiceSession();
                if (!StringUtils.isEmpty((Object)ent_id)) {
                    ss.setEnt_id(Long.parseLong(ent_id));
                }
                if (!StringUtils.isEmpty((Object)user_id)) {
                    ss.setUser_id(Long.parseLong(user_id));
                }
                ss.setUser_name(user_name);
                ss.setLocale(locale);
                session = JSON.toJSONString((Object)ss);
            }
            if ((retdata = this.rcm.executeClassMethod(method, versionCode, session, param)) == null) {
                String string = "";
                return string;
            }
            if (retdata instanceof String) {
                String string = (String)retdata;
                return string;
            }
            String string = JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
            return string;
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Throwable th = e.getTargetException();
            if (th instanceof IllegalArgumentException) {
                String endTimeMillis = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", e.getTargetException().getMessage()));
                return endTimeMillis;
            }
            if (th instanceof ServiceRuntimeException) {
                ServiceRuntimeException ex = (ServiceRuntimeException)th;
                String endTimeMillis = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, ex.getCode(), ex.getMessage()));
                return endTimeMillis;
            }
            String ex = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(e)));
            return ex;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            String string = JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex)));
            return string;
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTimeMillis;
            StatisticUtils.onDecrementMethod(method, elapsed);
        }
    }

    @Scheduled(cron="0 01 01 * * ?")
    public void onRefreshSliceReader() {
        LOGGER.info("onRefreshSliceReader------begin");
        this.sliceBase.init();
        LOGGER.info("onRefreshSliceReader------end");
    }
}

