/*
 * Decompiled with CFR 0.152.
 */
package com.product.dao;

import com.alibaba.fastjson.JSONObject;
import com.product.dao.BaseDao;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public abstract class AbstractMongodbDao<T>
implements BaseDao<T> {
    public abstract long remove(Query var1);

    public abstract List<T> queryCustom(MongoJson var1);

    public abstract List<T> queryCustom(Query var1);

    public abstract MPage<T> queryTPage(Query var1, int var2, int var3);

    public abstract MPage<T> queryCustomTPage(MongoJson var1);

    protected MPage<T> wrap(PageImpl<T> tPageImpl) {
        return new MPage(tPageImpl.getContent(), tPageImpl.getTotalElements(), tPageImpl.getTotalPages());
    }

    protected Query buildQuery(MongoJson mongoJson) {
        Query query = new Query();
        if (CollectionUtils.isEmpty(mongoJson.getValues())) {
            return query;
        }
        MongoJsonCriteria mongoJsonCriteria = this.buildCriteria(mongoJson.getValues());
        query.addCriteria((CriteriaDefinition)mongoJsonCriteria.getCriteria()).with(Sort.by(mongoJsonCriteria.getOrders()));
        return query;
    }

    protected MongoJsonCriteria buildCriteria(List<MongoJsonObject> values) {
        MongoJsonCriteria mongoJsonCriteria = new MongoJsonCriteria();
        Criteria criteria = null;
        boolean firstTag = true;
        for (MongoJsonObject mongoJsonObject : values) {
            if (!StringUtils.isNotBlank((String)mongoJsonObject.getKey())) continue;
            if (firstTag) {
                criteria = new Criteria(mongoJsonObject.getKey());
                mongoJsonCriteria.setCriteria(criteria);
                this.buildCriteria(mongoJsonCriteria, mongoJsonObject, firstTag);
                firstTag = false;
                continue;
            }
            this.buildCriteria(mongoJsonCriteria, mongoJsonObject, firstTag);
        }
        return mongoJsonCriteria;
    }

    protected void buildCriteria(MongoJsonCriteria mongoJsonCriteria, MongoJsonObject mongoJsonObject, boolean firstTag) {
        LinkedHashMap<String, Object> objectLinkedHashMap = mongoJsonObject.getCriteria();
        Criteria criteria = null;
        criteria = !firstTag ? new Criteria(mongoJsonObject.getKey()) : mongoJsonCriteria.getCriteria();
        Criteria finalCriteriaRef = criteria;
        objectLinkedHashMap.forEach((k, v) -> {
            switch (k) {
                case "$is": {
                    finalCriteriaRef.is(v);
                    break;
                }
                case "$ne": {
                    finalCriteriaRef.ne(v);
                    break;
                }
                case "$lt": {
                    finalCriteriaRef.lt(v);
                    break;
                }
                case "$lte": {
                    finalCriteriaRef.lte(v);
                    break;
                }
                case "$gt": {
                    finalCriteriaRef.gt(v);
                    break;
                }
                case "$gte": {
                    finalCriteriaRef.gte(v);
                    break;
                }
                case "$in": {
                    finalCriteriaRef.in(new Object[]{v});
                    break;
                }
                case "$nin": {
                    finalCriteriaRef.nin(new Object[]{v});
                    break;
                }
            }
        });
        if (!firstTag) {
            mongoJsonCriteria.getCriteria().andOperator(new Criteria[]{finalCriteriaRef});
        }
        if (StringUtils.isNotBlank((String)mongoJsonObject.getSortDesc())) {
            if ("DESC".equals(mongoJsonObject.getSortDesc())) {
                mongoJsonCriteria.getOrders().add(Sort.Order.desc((String)mongoJsonObject.getKey()));
            } else {
                mongoJsonCriteria.getOrders().add(Sort.Order.asc((String)mongoJsonObject.getKey()));
            }
        }
    }

    protected UpdateCondition createUpdate(T t, String primaryKeyName, Class<T> tClass, String ... updateFields) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        UpdateCondition updateCondition = new UpdateCondition();
        PropertyDescriptor primaryProp = new PropertyDescriptor(primaryKeyName, tClass);
        Object primaryKeyValue = primaryProp.getReadMethod().invoke(t, new Object[0]);
        JSONObject queryJsonObject = new JSONObject();
        queryJsonObject.put(primaryKeyName, primaryKeyValue);
        updateCondition.setQuery(this.buildQuery(t, queryJsonObject, tClass));
        Update update = this.buildUpdate(t, queryJsonObject, tClass, updateFields);
        updateCondition.setUpdateDefinition((UpdateDefinition)update);
        return updateCondition;
    }

    protected Query buildQuery(T t, JSONObject queyJsonObject, Class<T> tClass) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Criteria criteria = null;
        Set entries = queyJsonObject.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            PropertyDescriptor primaryProp = new PropertyDescriptor(key, tClass);
            Object keyValue = primaryProp.getReadMethod().invoke(t, new Object[0]);
            if (null == criteria) {
                criteria = Criteria.where((String)key).is(keyValue);
                continue;
            }
            criteria.and(key).is(keyValue);
        }
        return Query.query(criteria);
    }

    protected Update buildUpdate(T t, JSONObject queryJsonObject, Class<T> tClass, String ... updateFields) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Field[] fields = tClass.getDeclaredFields();
        Update update = null;
        if (updateFields.length == 0) {
            for (Field field : fields) {
                String fieldName = field.getName();
                PropertyDescriptor fieldProp = new PropertyDescriptor(fieldName, tClass);
                Object fieldValue = fieldProp.getReadMethod().invoke(t, new Object[0]);
                if (queryJsonObject.containsKey((Object)fieldName)) continue;
                if (null == update) {
                    update = Update.update((String)fieldName, (Object)fieldValue);
                    continue;
                }
                update.set(fieldName, fieldValue);
            }
        } else {
            for (String fieldName : updateFields) {
                PropertyDescriptor fieldProp = new PropertyDescriptor(fieldName, tClass);
                Object fieldValue = fieldProp.getReadMethod().invoke(t, new Object[0]);
                if (null == update) {
                    update = Update.update((String)fieldName, (Object)fieldValue);
                    continue;
                }
                update.set(fieldName, fieldValue);
            }
        }
        return update;
    }

    private JSONObject buildIndexJsonObject(String compoundIndexName, Class<T> tClass) {
        CompoundIndexes compoundIndexes = (CompoundIndexes)AnnotationUtils.findAnnotation(tClass, CompoundIndexes.class);
        CompoundIndex[] compoundIndexArray = compoundIndexes.value();
        CompoundIndex nowCompoundIndex = null;
        for (CompoundIndex compoundIndex : compoundIndexArray) {
            if (!compoundIndexName.equals(compoundIndex.name())) continue;
            nowCompoundIndex = compoundIndex;
            break;
        }
        return JSONObject.parseObject((String)nowCompoundIndex.def());
    }

    protected Query buildQuery(T t, String compoundIndexName, Class<T> tClass) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        JSONObject jsonObject = this.buildIndexJsonObject(compoundIndexName, tClass);
        return this.buildQuery(t, jsonObject, tClass);
    }

    protected UpdateCondition createUpdateByCompoundIndex(T t, String compoundIndexName, Class<T> tClass, String ... updateFields) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        UpdateCondition updateCondition = new UpdateCondition();
        JSONObject queryJsonObject = this.buildIndexJsonObject(compoundIndexName, tClass);
        updateCondition.setQuery(this.buildQuery(t, queryJsonObject, tClass));
        updateCondition.setUpdateDefinition((UpdateDefinition)this.buildUpdate(t, queryJsonObject, tClass, updateFields));
        return updateCondition;
    }

    public static class UpdateCondition {
        Query query;
        UpdateDefinition updateDefinition;

        public Query getQuery() {
            return this.query;
        }

        public UpdateDefinition getUpdateDefinition() {
            return this.updateDefinition;
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public void setUpdateDefinition(UpdateDefinition updateDefinition) {
            this.updateDefinition = updateDefinition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateCondition)) {
                return false;
            }
            UpdateCondition other = (UpdateCondition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Query this$query = this.getQuery();
            Query other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            UpdateDefinition this$updateDefinition = this.getUpdateDefinition();
            UpdateDefinition other$updateDefinition = other.getUpdateDefinition();
            return !(this$updateDefinition == null ? other$updateDefinition != null : !this$updateDefinition.equals(other$updateDefinition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateCondition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Query $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            UpdateDefinition $updateDefinition = this.getUpdateDefinition();
            result = result * 59 + ($updateDefinition == null ? 43 : $updateDefinition.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractMongodbDao.UpdateCondition(query=" + this.getQuery() + ", updateDefinition=" + this.getUpdateDefinition() + ")";
        }
    }

    public static class MongoJsonCriteria {
        Criteria criteria;
        List<Sort.Order> orders = new ArrayList<Sort.Order>();

        public Criteria getCriteria() {
            return this.criteria;
        }

        public List<Sort.Order> getOrders() {
            return this.orders;
        }

        public void setCriteria(Criteria criteria) {
            this.criteria = criteria;
        }

        public void setOrders(List<Sort.Order> orders) {
            this.orders = orders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MongoJsonCriteria)) {
                return false;
            }
            MongoJsonCriteria other = (MongoJsonCriteria)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Criteria this$criteria = this.getCriteria();
            Criteria other$criteria = other.getCriteria();
            if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
                return false;
            }
            List<Sort.Order> this$orders = this.getOrders();
            List<Sort.Order> other$orders = other.getOrders();
            return !(this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MongoJsonCriteria;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Criteria $criteria = this.getCriteria();
            result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
            List<Sort.Order> $orders = this.getOrders();
            result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractMongodbDao.MongoJsonCriteria(criteria=" + this.getCriteria() + ", orders=" + this.getOrders() + ")";
        }
    }

    public static class MongoJsonObject {
        String key;
        LinkedHashMap<String, Object> criteria = new LinkedHashMap();
        String sortDesc;

        public String getKey() {
            return this.key;
        }

        public LinkedHashMap<String, Object> getCriteria() {
            return this.criteria;
        }

        public String getSortDesc() {
            return this.sortDesc;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setCriteria(LinkedHashMap<String, Object> criteria) {
            this.criteria = criteria;
        }

        public void setSortDesc(String sortDesc) {
            this.sortDesc = sortDesc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MongoJsonObject)) {
                return false;
            }
            MongoJsonObject other = (MongoJsonObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            LinkedHashMap<String, Object> this$criteria = this.getCriteria();
            LinkedHashMap<String, Object> other$criteria = other.getCriteria();
            if (this$criteria == null ? other$criteria != null : !((Object)this$criteria).equals(other$criteria)) {
                return false;
            }
            String this$sortDesc = this.getSortDesc();
            String other$sortDesc = other.getSortDesc();
            return !(this$sortDesc == null ? other$sortDesc != null : !this$sortDesc.equals(other$sortDesc));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MongoJsonObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            LinkedHashMap<String, Object> $criteria = this.getCriteria();
            result = result * 59 + ($criteria == null ? 43 : ((Object)$criteria).hashCode());
            String $sortDesc = this.getSortDesc();
            result = result * 59 + ($sortDesc == null ? 43 : $sortDesc.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractMongodbDao.MongoJsonObject(key=" + this.getKey() + ", criteria=" + this.getCriteria() + ", sortDesc=" + this.getSortDesc() + ")";
        }
    }

    public static class MongoJson {
        int pageIndex = 1;
        int pageSize = 10;
        List<MongoJsonObject> values;

        public int getPageIndex() {
            return this.pageIndex;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public List<MongoJsonObject> getValues() {
            return this.values;
        }

        public void setPageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public void setValues(List<MongoJsonObject> values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MongoJson)) {
                return false;
            }
            MongoJson other = (MongoJson)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPageIndex() != other.getPageIndex()) {
                return false;
            }
            if (this.getPageSize() != other.getPageSize()) {
                return false;
            }
            List<MongoJsonObject> this$values = this.getValues();
            List<MongoJsonObject> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MongoJson;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPageIndex();
            result = result * 59 + this.getPageSize();
            List<MongoJsonObject> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractMongodbDao.MongoJson(pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", values=" + this.getValues() + ")";
        }
    }

    public static class MPage<T> {
        List<T> content;
        long total;
        long totalPage;

        public List<T> getContent() {
            return this.content;
        }

        public long getTotal() {
            return this.total;
        }

        public long getTotalPage() {
            return this.totalPage;
        }

        public void setContent(List<T> content) {
            this.content = content;
        }

        public void setTotal(long total) {
            this.total = total;
        }

        public void setTotalPage(long totalPage) {
            this.totalPage = totalPage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MPage)) {
                return false;
            }
            MPage other = (MPage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<T> this$content = this.getContent();
            List<T> other$content = other.getContent();
            if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            return this.getTotalPage() == other.getTotalPage();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MPage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<T> $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
            long $total = this.getTotal();
            result = result * 59 + (int)($total >>> 32 ^ $total);
            long $totalPage = this.getTotalPage();
            result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
            return result;
        }

        public String toString() {
            return "AbstractMongodbDao.MPage(content=" + this.getContent() + ", total=" + this.getTotal() + ", totalPage=" + this.getTotalPage() + ")";
        }

        public MPage(List<T> content, long total, long totalPage) {
            this.content = content;
            this.total = total;
            this.totalPage = totalPage;
        }
    }
}

