/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.parser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2OutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.product.storage.parser.MySqlOutputVisitorWithText;
import com.product.storage.parser.OracleOutputVisitorWithDate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;

public abstract class QueryExtractor {
    public static final int SELECT = 0;
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int REMOVE = 3;
    protected static final String DB = "db";
    protected String collectionName;
    protected String mycatTag;
    protected DBTYPE SQLDBType = DBTYPE.MYSQL;

    public abstract String getQueryForMongo();

    public abstract String getQueryForSQL();

    protected abstract String getMyCatTag();

    public void setSQLDBType(DBTYPE type) {
        this.SQLDBType = type;
    }

    public String getQueryForSQL(DBTYPE type) {
        this.setSQLDBType(type);
        return this.getQueryForSQL();
    }

    protected String getMongoQueryString(Query query) {
        if (query == null) {
            return "";
        }
        return SerializationUtils.serializeToJsonSafely((Object)query.getQueryObject());
    }

    protected String getSQL(SQLStatement statement) {
        StringBuilder out = new StringBuilder();
        Object visitor = null;
        switch (this.SQLDBType) {
            case DB2: {
                visitor = new DB2OutputVisitor((Appendable)out);
                break;
            }
            case MYSQL: {
                visitor = new MySqlOutputVisitorWithText(out);
                break;
            }
            case ORACLE: {
                visitor = new OracleOutputVisitorWithDate(out);
                break;
            }
            case SQLSERVER: {
                visitor = new SQLServerOutputVisitor((Appendable)out);
                break;
            }
            case POSTGRESQL: {
                visitor = new PGOutputVisitor((Appendable)out);
                break;
            }
            default: {
                visitor = new SQLASTOutputVisitor((Appendable)out);
            }
        }
        statement.accept((SQLASTVisitor)visitor);
        String statementSQL = out.toString().replace("\n", " ").replace(";", "");
        return String.format("%1$s%2$s", this.getMyCatTag(), statementSQL);
    }

    public static enum DBTYPE {
        MYSQL,
        ORACLE,
        SQLSERVER,
        POSTGRESQL,
        DB2,
        H2,
        DERBY,
        SQLITE,
        FIREBIRD,
        SYSBASE,
        OTHERSQL;

    }
}

