/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.parser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerInsertStatement;
import com.mongodb.BasicDBList;
import com.product.storage.parser.ExprTranslator;
import com.product.storage.parser.QueryExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.SerializationUtils;

public class QueryInsertExtractor
extends QueryExtractor {
    private List<Document> dbDocList;
    private boolean multi = false;
    private List<String> columns;
    private String mycatTag;

    public QueryInsertExtractor(String collectionName, Document dbDoc, String mycatTag) {
        this(collectionName, new ArrayList<Document>(Arrays.asList(dbDoc)), mycatTag);
    }

    public QueryInsertExtractor(String collectionName, List<Document> dbDocList, String mycatTag) {
        this.collectionName = collectionName;
        if (dbDocList.isEmpty()) {
            throw new IllegalArgumentException("Error: Document list is empty!");
        }
        this.dbDocList = dbDocList;
        this.mycatTag = mycatTag;
        this.init();
    }

    private void init() {
        for (Document obj : this.dbDocList) {
            obj.remove((Object)"_class");
            obj.remove((Object)"_id");
        }
        this.multi = this.dbDocList.size() > 1;
        this.columns = new ArrayList<String>(this.dbDocList.get(0).keySet());
    }

    @Override
    protected String getMyCatTag() {
        return StringUtils.isBlank((String)this.mycatTag) ? "" : this.mycatTag;
    }

    @Override
    public String getQueryForMongo() {
        StringBuilder sb = new StringBuilder();
        sb.append("db").append(".").append(this.collectionName).append(".insert(");
        if (!this.multi) {
            sb.append(SerializationUtils.serializeToJsonSafely((Object)this.dbDocList.get(0)));
        } else {
            BasicDBList dbList = new BasicDBList();
            for (Document obj : this.dbDocList) {
                dbList.add((Object)obj);
            }
            sb.append(SerializationUtils.serializeToJsonSafely((Object)dbList));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getQueryForSQL() {
        MySqlInsertStatement stmt = null;
        switch (this.SQLDBType) {
            case MYSQL: {
                stmt = new MySqlInsertStatement();
                break;
            }
            case ORACLE: {
                stmt = new OracleInsertStatement();
                break;
            }
            case SQLSERVER: {
                stmt = new SQLServerInsertStatement();
                break;
            }
            case POSTGRESQL: {
                stmt = new PGInsertStatement();
                break;
            }
            default: {
                stmt = new SQLInsertStatement();
            }
        }
        stmt.setTableSource(ExprTranslator.translateTableName(this.collectionName));
        this.parseColumns(this.columns, (SQLInsertStatement)stmt);
        this.parseValuesList(this.columns, this.dbDocList, (SQLInsertStatement)stmt);
        return this.getSQL((SQLStatement)stmt);
    }

    private void parseColumns(List<String> keys, SQLInsertStatement stmt) {
        List columns = stmt.getColumns();
        for (String key : keys) {
            columns.add(ExprTranslator.translateKey(key));
        }
    }

    private SQLInsertStatement.ValuesClause parseValues(List<String> keys, Document dbDoc) {
        SQLInsertStatement.ValuesClause values = new SQLInsertStatement.ValuesClause();
        for (String key : keys) {
            values.addValue(ExprTranslator.parseObject(dbDoc.get((Object)key), this.SQLDBType));
        }
        return values;
    }

    private void parseValuesList(List<String> keys, List<Document> dbDocList, SQLInsertStatement stmt) {
        List valuesList = null;
        if (stmt instanceof MySqlInsertStatement) {
            valuesList = ((MySqlInsertStatement)stmt).getValuesList();
        } else if (stmt instanceof SQLServerInsertStatement) {
            valuesList = ((SQLServerInsertStatement)stmt).getValuesList();
        } else if (stmt instanceof PGInsertStatement) {
            valuesList = ((PGInsertStatement)stmt).getValuesList();
        }
        if (valuesList != null) {
            for (Document obj : dbDocList) {
                valuesList.add(this.parseValues(keys, obj));
            }
        } else {
            stmt.setValues(this.parseValues(keys, dbDocList.get(0)));
        }
    }
}

