/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.template;

import com.product.storage.parser.QueryInsertExtractor;
import com.product.storage.parser.QueryRemoveExtractor;
import com.product.storage.parser.QuerySelectExtractor;
import com.product.storage.parser.QueryUpdateExtractor;
import com.product.storage.template.FMybatisTemplate;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class FStorageLogger {
    private static final Logger LOG = LogManager.getLogger(FStorageLogger.class);

    public static Logger getLog() {
        return LOG;
    }

    public void logSelectQuery(String collectionName, Query query, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QuerySelectExtractor extractor = new QuerySelectExtractor(collectionName, query, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logInsertQuery(String collectionName, Document dbDoc, List<Document> dbDocList, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QueryInsertExtractor extractor = dbDoc != null ? new QueryInsertExtractor(collectionName, dbDoc, FMybatisTemplate.getMyCatTag(mycatState)) : new QueryInsertExtractor(collectionName, dbDocList, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logUpdateQuery(String collectionName, Query query, Update update, boolean upsert, boolean multi, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QueryUpdateExtractor extractor = new QueryUpdateExtractor(collectionName, query, update, upsert, multi, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logDeleteQuery(String collectionName, Query query, int mycatState) {
        if (LOG.isDebugEnabled()) {
            try {
                QueryRemoveExtractor extractor = new QueryRemoveExtractor(collectionName, query, FMybatisTemplate.getMyCatTag(mycatState));
                LOG.info((Object)("MongoDB syntax: " + extractor.getQueryForMongo()));
                LOG.info((Object)("SQL syntax: " + extractor.getQueryForSQL()));
            }
            catch (Exception e) {
                LOG.warn((Object)("Got exception when get syntax: " + e.getMessage()));
            }
        }
    }

    public void logSQLQuery(String sql) {
        LOG.info((Object)("SQL syntax: " + sql));
    }
}

