/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.product.exception.ServiceRuntimeException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateTimeFormatUtil {
    private static final SimpleDateFormat standstandardDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat standstandardDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat standstandardTimeFormat = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat dayStartDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
    public static final SimpleDateFormat dayEndDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd 23:59:59");

    private DateTimeFormatUtil() {
    }

    public static String nowToDateTime() {
        return DateTimeFormatUtil.toDateTime(new Date());
    }

    public static String toDateTime(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardDateTimeFormat);
    }

    public static String toDateTime(Date dateTime, DateFormat dateFormat) {
        return dateTime == null ? "" : dateFormat.format(dateTime);
    }

    public static String nowToDate() {
        return DateTimeFormatUtil.toDate(new Date());
    }

    public static String toDate(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardDateFormat);
    }

    public static String nowToTime() {
        return DateTimeFormatUtil.toDateTime(new Date());
    }

    public static String toTime(Date dateTime) {
        return DateTimeFormatUtil.toDateTime(dateTime, standstandardTimeFormat);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return DateTimeFormatUtil.toDateTime(date, dateFormat);
    }

    public static Date parseDate(String dateTime) {
        try {
            return standstandardDateTimeFormat.parse(dateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u65f6\u95f4\u8f6c\u6362\u51fa\u9519");
        }
    }

    public static Date parseDateWithoutTime(String dateTime) {
        try {
            return standstandardDateFormat.parse(dateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u65f6\u95f4\u8f6c\u6362\u51fa\u9519");
        }
    }

    public static int daysBetween(Date smdate, Date bdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        int daysBetween = Integer.parseInt(String.valueOf(between_days));
        return daysBetween;
    }

    public static int getExpiryDays(Date endDate) {
        if (endDate != null) {
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date expiryDate = calendar.getTime();
            int days = DateTimeFormatUtil.daysBetween(expiryDate, endDate);
            return days;
        }
        return 9999;
    }

    public static Date dateTruncate(Date currentDate) {
        if (currentDate != null) {
            Date date = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date lastDate = calendar.getTime();
            return lastDate;
        }
        return currentDate;
    }

    public static Date dateAdd(Date currentDate, int days) {
        if (currentDate != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(currentDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            ((Calendar)calendar).add(5, days);
            Date lastDate = calendar.getTime();
            return lastDate;
        }
        return currentDate;
    }
}

