/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SequenceGenerator.class);
    private final long unusedBits = 1L;
    private final long timestampBits = 41L;
    private final long workerIdBits = 16L;
    private final long sequenceBits = 6L;
    private static final int NODE_ID_BITS = 16;
    private static final int SEQUENCE_BITS = 6;
    private static final int timestampLeftShift = 22;
    private static final int datacenterShift = 22;
    private static final int nodeShift = 6;
    private final long timestampShift = 22L;
    private final long datacenterIdShift = 22L;
    private final long workerIdShift = 6L;
    private static final int maxNodeId = (int)(Math.pow(2.0, 16.0) - 1.0);
    private static final int maxSequence = (int)(Math.pow(2.0, 6.0) - 1.0);
    private static final long CUSTOM_EPOCH = 1420070400000L;
    private final long epoch = 1420070400000L;
    private final int nodeId;
    private long lastTimestamp = -1L;
    private long sequence = 0L;
    private String macAdrr;
    private boolean isEx;

    public SequenceGenerator(int nodeId) {
        if (nodeId < 0 || nodeId > maxNodeId) {
            throw new IllegalArgumentException(String.format("NodeId must be between %d and %d", 0, maxNodeId));
        }
        this.nodeId = nodeId;
    }

    public SequenceGenerator() {
        String[] info = this.createNodeId();
        this.nodeId = Integer.valueOf(info[0]);
        this.macAdrr = info[1];
        this.isEx = Boolean.valueOf(info[2]);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getMacAdrr() {
        return this.macAdrr;
    }

    public void setMacAdrr(String macAdrr) {
        this.macAdrr = macAdrr;
    }

    public boolean isEx() {
        return this.isEx;
    }

    public void setEx(boolean isEx) {
        this.isEx = isEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long nextId() {
        SequenceGenerator sequenceGenerator = this;
        synchronized (sequenceGenerator) {
            long currentTimestamp = SequenceGenerator.timestamp();
            if (currentTimestamp < this.lastTimestamp) {
                throw new IllegalStateException("Invalid System Clock!");
            }
            if (currentTimestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & (long)maxSequence;
                if (this.sequence == 0L) {
                    currentTimestamp = this.waitNextMillis(currentTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = currentTimestamp;
            long id = currentTimestamp << 22;
            id |= (long)(this.nodeId << 6);
            return id |= this.sequence;
        }
    }

    private static long timestamp() {
        return Instant.now().toEpochMilli() - 1420070400000L;
    }

    private long waitNextMillis(long currentTimestamp) {
        while (currentTimestamp == this.lastTimestamp) {
            currentTimestamp = SequenceGenerator.timestamp();
        }
        return currentTimestamp;
    }

    private String[] createNodeId() {
        int nodeId;
        String[] res = new String[3];
        String macAdr = "";
        boolean isEx = false;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] mac = networkInterface.getHardwareAddress();
                if (mac == null) continue;
                for (int i = 0; i < mac.length; ++i) {
                    sb.append(String.format("%02X", mac[i]));
                }
            }
            macAdr = sb.toString();
            nodeId = macAdr.hashCode();
        }
        catch (Exception ex) {
            isEx = true;
            nodeId = new SecureRandom().nextInt();
        }
        res[0] = String.valueOf(nodeId &= maxNodeId);
        res[1] = macAdr;
        res[2] = String.valueOf(isEx);
        return res;
    }

    public long[] parseId(long id) {
        long[] arr = new long[5];
        arr[3] = (id & this.diode(1L, 41L)) >> 22;
        arr[0] = arr[3] + 1420070400000L;
        arr[1] = (id & this.diode(42L, 16L)) >> 6;
        arr[2] = id & this.diode(58L, 6L);
        return arr;
    }

    public String formatId(long id) {
        long[] arr = this.parseId(id);
        String tmf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(arr[0]));
        return String.format("%s, %d, %d", tmf, arr[1], arr[2]);
    }

    private long diode(long offset, long length) {
        int lb = (int)(64L - offset);
        int rb = (int)(64L - (offset + length));
        return -1L << lb ^ -1L << rb;
    }

    public static void main(String[] args) {
        SequenceGenerator sg = new SequenceGenerator();
        Long pk = 606302813482483712L;
        logger.debug(sg.formatId(pk));
        Long pk1 = 606031338417340421L;
        logger.debug(sg.formatId(pk1));
        Long pk2 = 606031190928572417L;
        logger.debug(sg.formatId(pk2));
        System.out.println("0A58C00305E0---|---" + "0A58C00305E0".hashCode() + "---|---" + ("0A58C00305E0".hashCode() & 0xFFFF));
        System.out.println("0A58C0030A96---|---" + "0A58C0030A96".hashCode() + "---|---" + ("0A58C0030A96".hashCode() & 0xFFFF));
        System.out.println("0A58C0030939---|---" + "0A58C0030939".hashCode() + "---|---" + ("0A58C0030939".hashCode() & 0xFFFF));
        System.out.println("0A58C00306A2---|---" + "0A58C00306A2".hashCode() + "---|---" + ("0A58C00306A2".hashCode() & 0xFFFF));
        System.out.println("0A58C0030383---|---" + "0A58C0030383".hashCode() + "---|---" + ("0A58C0030383".hashCode() & 0xFFFF));
        System.out.println("0A58C00307B0---|---" + "0A58C00307B0".hashCode() + "---|---" + ("0A58C00307B0".hashCode() & 0xFFFF));
        System.out.println("0A58C003083E---|---" + "0A58C003083E".hashCode() + "---|---" + ("0A58C003083E".hashCode() & 0xFFFF));
        System.out.println("0A58C0030438---|---" + "0A58C0030438".hashCode() + "---|---" + ("0A58C0030438".hashCode() & 0xFFFF));
        System.out.println(Integer.toBinaryString(1317729166));
        System.out.println(Integer.toBinaryString(65535));
        System.out.println(Instant.now().toEpochMilli());
    }
}

