/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.product.util.TypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.HttpHeaders;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class Utils {
    private static final String CR = " <br>          at ";
    private static boolean isDetailException;

    public static String getLastExceptionMessage(Exception e) {
        return Utils.getLastExceptionMessage(e, isDetailException);
    }

    protected static String getLastExceptionMessage(Exception e, boolean all) {
        Throwable t = e;
        if (e instanceof InvocationTargetException) {
            t = ((InvocationTargetException)e).getTargetException();
        } else {
            while ((t = t.getCause()) != null && t.getCause() != null) {
            }
            if (t == null) {
                t = e;
            }
        }
        String errmsg = t.getClass().getName() + ": " + t.getMessage();
        StackTraceElement[] stes = t.getStackTrace();
        if (stes != null && stes.length > 0) {
            errmsg = errmsg + CR + stes[0].toString();
            if (all) {
                StringBuffer sb = new StringBuffer();
                for (int i = 1; i < stes.length; ++i) {
                    sb.append(CR + stes[i].toString());
                }
                errmsg = errmsg + sb.toString();
            } else {
                String privmsg = null;
                String currmsg = null;
                for (int i = 1; i < stes.length; ++i) {
                    privmsg = stes[i - 1].toString();
                    if (stes[i].toString().indexOf("com.efuture.omd") < 0) continue;
                    if (i == 1) {
                        privmsg = null;
                    }
                    currmsg = stes[i].toString();
                    break;
                }
                if (currmsg != null) {
                    if (privmsg != null) {
                        errmsg = errmsg + " <br>          at ... <br>          at " + privmsg;
                    }
                    errmsg = errmsg + CR + currmsg;
                }
            }
        }
        return errmsg;
    }

    public static Object toNormalJSONObject(Object data) {
        return Utils.toNormalJSONObject(data, null);
    }

    public static Object toNormalJSONObject(Object data, Map<String, Object> config) {
        JSONObject jsondata = null;
        if (data instanceof JSONObject) {
            jsondata = (JSONObject)data;
        } else {
            try {
                if (config == null || config.size() < 1) {
                    jsondata = JSON.parseObject((String)JSON.toJSONStringWithDateFormat((Object)data, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
                } else {
                    final HashMap<String, SimpleDateFormat> params = new HashMap<String, SimpleDateFormat>();
                    Set<String> keySet = config.keySet();
                    for (String field : keySet) {
                        SimpleDateFormat format = new SimpleDateFormat(config.get(field).toString());
                        params.put(field, format);
                    }
                    jsondata = JSON.parseObject((String)JSON.toJSONString((Object)data, (SerializeFilter)new ValueFilter(){

                        public Object process(Object object, String name, Object value) {
                            if (params.containsKey(name)) {
                                DateFormat format = (DateFormat)params.get(name);
                                return format.format(value);
                            }
                            return value;
                        }
                    }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                }
            }
            catch (Exception ex) {
                return data;
            }
        }
        Set keys = jsondata.keySet();
        for (String key : keys) {
            if (jsondata.get((Object)key) instanceof Long) {
                jsondata.put(key, (Object)String.valueOf(jsondata.getLong(key)));
                continue;
            }
            if (jsondata.get((Object)key) instanceof Double || jsondata.get((Object)key) instanceof Float || jsondata.get((Object)key) instanceof BigDecimal) {
                double value;
                String xiaoShuValue2;
                String strValue = jsondata.getString(key);
                int index = strValue.indexOf(46);
                if (index < 0 || !strValue.endsWith("99999") && !strValue.endsWith("00001") || "".equals(xiaoShuValue2 = strValue.substring(index + 1)) || xiaoShuValue2.length() < 6) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("0.");
                for (int i = 0; i < xiaoShuValue2.length() - 1; ++i) {
                    sb.append("0");
                }
                sb.append("1");
                if (strValue.endsWith("99999")) {
                    value = Double.parseDouble(strValue) + Double.parseDouble(sb.toString());
                    jsondata.put(key, (Object)value);
                } else {
                    value = Double.parseDouble(strValue) - Double.parseDouble(sb.toString());
                }
                jsondata.put(key, (Object)value);
                continue;
            }
            if (jsondata.get((Object)key) instanceof JSONObject) {
                jsondata.put(key, Utils.toNormalJSONObject(jsondata.getJSONObject(key)));
                continue;
            }
            if (jsondata.get((Object)key) instanceof JSONArray) {
                JSONArray array = jsondata.getJSONArray(key);
                for (int i = 0; i < array.size(); ++i) {
                    Object o = array.get(i);
                    if (o instanceof Long || o instanceof Float || o instanceof Double) {
                        array.set(i, (Object)String.valueOf(o));
                        continue;
                    }
                    if (o instanceof Double || o instanceof Float || o instanceof BigDecimal) {
                        String xiaoShuValue2;
                        String strValue = o.toString();
                        int index = strValue.indexOf(46);
                        if (index < 0 || !strValue.endsWith("99999") && !strValue.endsWith("00001") || "".equals(xiaoShuValue2 = strValue.substring(index + 1)) || xiaoShuValue2.length() < 6) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append("0.");
                        for (int j = 0; j < xiaoShuValue2.length() - 1; ++j) {
                            sb.append("0");
                        }
                        sb.append("1");
                        double value = strValue.endsWith("99999") ? Double.parseDouble(strValue) + Double.parseDouble(sb.toString()) : Double.parseDouble(strValue) - Double.parseDouble(sb.toString());
                        array.set(i, (Object)value);
                        continue;
                    }
                    if (jsondata.get((Object)key) instanceof String) {
                        if (!jsondata.get((Object)key).equals("true") && !jsondata.get((Object)key).equals("false")) continue;
                        jsondata.put(key, (Object)TypeUtils.castToBoolean(jsondata.get((Object)key)));
                        continue;
                    }
                    if (!(o instanceof JSONObject)) continue;
                    array.set(i, Utils.toNormalJSONObject(o));
                }
                continue;
            }
            if (!(jsondata.get((Object)key) instanceof String) || !jsondata.get((Object)key).equals("true") && !jsondata.get((Object)key).equals("false")) continue;
            jsondata.put(key, (Object)TypeUtils.castToBoolean(jsondata.get((Object)key)));
        }
        return jsondata;
    }

    public static boolean stringArrayContainsKey(String[] array, String key, boolean ignoreCase) {
        if (array == null) {
            return false;
        }
        for (String k : array) {
            if (!(ignoreCase ? key.equalsIgnoreCase(k) : key.equals(k))) continue;
            return true;
        }
        return false;
    }

    public static String builderContentDispositionFileName(HttpHeaders headers, String filename) {
        String contentDisposition = "attachment;";
        try {
            String browser = headers.getRequestHeader("User-Agent").toString();
            contentDisposition = browser != null && browser.toLowerCase().indexOf("firefox") > 0 ? contentDisposition + "filename*=UTF-8''" + URLEncoder.encode(filename, "UTF-8") : contentDisposition + "filename=" + URLEncoder.encode(filename, "UTF-8");
        }
        catch (Exception ex) {
            contentDisposition = contentDisposition + "filename=" + filename;
        }
        return contentDisposition;
    }

    static {
        ServletContext sc;
        isDetailException = false;
        WebApplicationContext cont = ContextLoader.getCurrentWebApplicationContext();
        if (cont != null && (sc = cont.getServletContext()) != null && "true".equalsIgnoreCase(sc.getInitParameter("detailException"))) {
            isDetailException = true;
        }
    }
}

