/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.component.BeanField;
import com.product.exception.ServiceException;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.TypeUtils;
import com.shiji.core.util.ReflectUtils;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="batchinsservice")
public class BatchInsService {
    @Value(value="${batchinsert.batch_rows:1000}")
    private int BATCH_ROWS = 1000;

    public String convertToColType(QueryExtractor.DBTYPE dbtype, String colType) {
        if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
            if (colType.toLowerCase().startsWith("varchar") || colType.toLowerCase().startsWith("char")) {
                return "string";
            }
            if (colType.toLowerCase().startsWith("number")) {
                return "long";
            }
            if (colType.toLowerCase().startsWith("date")) {
                return "date";
            }
        } else if (dbtype == QueryExtractor.DBTYPE.MYSQL || dbtype == QueryExtractor.DBTYPE.SQLITE) {
            if (colType.toLowerCase().startsWith("varchar") || colType.toLowerCase().startsWith("char")) {
                return "string";
            }
            if (colType.toLowerCase().startsWith("int") || colType.toLowerCase().startsWith("bigint")) {
                return "long";
            }
            if (colType.toLowerCase().startsWith("decimal")) {
                return "double";
            }
            if (colType.toLowerCase().startsWith("date")) {
                return "date";
            }
        }
        return "string";
    }

    public Object getColData(FMybatisTemplate storage, Object o, String type2) throws ParseException {
        SimpleDateFormat timefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (type2.contains("long")) {
            o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
        } else if (type2.contains("int")) {
            o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
        } else if (type2.contains("float")) {
            o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
        } else if (type2.contains("double")) {
            o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
        } else if (type2.contains("short")) {
            o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
        } else if (type2.contains("boolean")) {
            if (!(o instanceof Boolean)) {
                o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
            }
        } else if (type2.contains("date")) {
            if (StringUtils.isEmpty((Object)o)) {
                o = null;
            } else {
                String s = timefmt.format(o);
                o = storage.getDBType() == QueryExtractor.DBTYPE.ORACLE ? "to_date('" + s + "', 'yyyy-mm-dd hh24:mi:ss')" : "'" + s + "'";
            }
        } else if (type2.contains("string")) {
            o = o == null ? String.valueOf(o) : "'" + String.valueOf(o).replace("'", "''").replace("\"", "") + "'";
        }
        return o;
    }

    public Set<BeanField> transform(List<Field> fields) {
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        for (Field fld : fields) {
            if (fld == null) continue;
            BeanField bf = new BeanField();
            bf.setColName(fld.getName());
            bf.setField(fld);
            bf.setColType(fld.getType().getName().toLowerCase());
            beanFields.add(bf);
        }
        return beanFields;
    }

    public List<Field> filter(List<Field> lists, Set<String> fields) {
        ArrayList<Field> rtn = new ArrayList<Field>();
        for (String field : fields) {
            List tmp = lists.stream().filter(e -> field.equalsIgnoreCase(e.getName())).collect(Collectors.toList());
            if (StringUtils.isEmpty(tmp) || tmp.isEmpty()) continue;
            rtn.add((Field)tmp.get(0));
        }
        return rtn;
    }

    public void batchInsert(FMybatisTemplate storage, List<Map<String, Object>> lists, String tableName) throws Exception {
        this.batchInsert(storage, lists, tableName, this.BATCH_ROWS);
    }

    public void batchInsert(FMybatisTemplate storage, List<Map<String, Object>> lists, String tableName, int batch_rows) throws Exception {
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        Map<String, Object> firstRow = lists.get(0);
        Set<String> flds = firstRow.keySet();
        for (String col : flds) {
            BeanField bf = new BeanField();
            bf.setColName(col);
            if (firstRow.get(col) != null) {
                bf.setColType(firstRow.get(col).getClass().toString().toLowerCase());
            } else {
                bf.setColType("string");
            }
            beanFields.add(bf);
        }
        this.batchInsertFields(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String tableName, List<T> lists) throws Exception {
        this.batchInsert(storage, objClass, tableName, lists, this.BATCH_ROWS);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, String tableName, List<T> lists, int batch_rows) throws Exception {
        List fields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        Set<BeanField> beanFields = this.transform(fields);
        this.batchInsertFields(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, Set<String> fields, List<T> lists, String tableName) throws Exception {
        this.batchInsert(storage, objClass, fields, lists, tableName, this.BATCH_ROWS);
    }

    public <T> void batchInsert(FMybatisTemplate storage, Class<?> objClass, Set<String> fields, List<T> lists, String tableName, int batch_rows) throws Exception {
        List allBeanFields = ReflectUtils.getAllFieldsFilterTransient(objClass);
        List<Field> fieldList = this.filter(allBeanFields, fields);
        Set<BeanField> beanFields = this.transform(fieldList);
        this.batchInsertFields(storage, beanFields, lists, tableName, batch_rows);
    }

    public <T> void batchInsertFields(FMybatisTemplate storage, Set<BeanField> beanFields, List<T> lists, String tableName, int batch_rows) throws Exception {
        if (StringUtils.isEmpty(lists) || lists.isEmpty()) {
            return;
        }
        if (StringUtils.isEmpty(beanFields) || beanFields.isEmpty()) {
            return;
        }
        SqlSessionTemplate db = storage.getSqlSessionTemplate();
        QueryExtractor.DBTYPE dbtype = storage.getDBType();
        if (dbtype != QueryExtractor.DBTYPE.ORACLE && dbtype != QueryExtractor.DBTYPE.MYSQL && dbtype != QueryExtractor.DBTYPE.SQLITE) {
            throw new ServiceException("5000", "unsupport DBMS Type!", new Object[0]);
        }
        int tot_page = (int)Math.ceil((float)lists.size() / (float)batch_rows);
        StringBuffer tabsql = new StringBuffer();
        tabsql.append("insert into ").append(tableName).append(" (");
        for (BeanField col : beanFields) {
            tabsql.append(col.getColName()).append(",");
        }
        tabsql.deleteCharAt(tabsql.length() - 1);
        tabsql.append(")");
        for (int page = 0; page < tot_page; ++page) {
            StringBuffer sql = new StringBuffer();
            sql.append(tabsql);
            boolean firstrow = true;
            for (int row = batch_rows * page; row < Math.min(lists.size(), batch_rows * (page + 1)); ++row) {
                T bean = lists.get(row);
                JSONObject rowjson = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
                if (dbtype == QueryExtractor.DBTYPE.ORACLE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, rowjson.get((Object)col.getColName()), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" from dual");
                } else if (dbtype == QueryExtractor.DBTYPE.SQLITE) {
                    if (!firstrow) {
                        sql.append(" union all ");
                    }
                    sql.append(" select ");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, rowjson.get((Object)col.getColName()), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" \r\n ");
                } else if (dbtype == QueryExtractor.DBTYPE.MYSQL) {
                    if (firstrow) {
                        sql.append(" values ");
                    } else {
                        sql.append(",");
                    }
                    sql.append("(");
                    for (BeanField col : beanFields) {
                        sql.append(this.getColData(storage, rowjson.get((Object)col.getColName()), col.getColType()));
                        sql.append(",");
                    }
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(")");
                }
                firstrow = false;
            }
            db.insert("mybatis.sql.insert", sql.toString());
        }
    }
}

