/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.exception.ServiceRuntimeException;
import com.product.model.AbstractEntityBean;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class MasterSlaveComponentServiceImpl<X> {
    private static final Logger log = LoggerFactory.getLogger(MasterSlaveComponentServiceImpl.class);
    public String[] slaveServiceNames;
    final Class<X> masterClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), MasterSlaveComponentServiceImpl.class);
    public Class masterBean = GenericTypeResolver.resolveTypeArgument(this.masterClass, JDBCCompomentServiceImpl.class);

    public String[] getSlaveServiceNames() {
        return this.slaveServiceNames;
    }

    public MasterSlaveComponentServiceImpl(String[] slaveServiceNames) {
        this.slaveServiceNames = slaveServiceNames;
    }

    public String getCollectionName() {
        String collectionName = null;
        try {
            collectionName = this.getCollectionName(this.masterClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return collectionName;
    }

    public String getKeyfieldName() {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("getKeyfieldName", new Class[0]);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, new Object[0]);
            return (String)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u83b7\u53d6\u4e3b\u8868\u4e3b\u952e\u5f02\u5e38");
        }
    }

    public String getKeyfieldName(Class<?> cl) {
        try {
            Method keyMethod = cl.getMethod("getKeyfieldName", new Class[0]);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            Object data = keyMethod.invoke(serviceObj, new Object[0]);
            return (String)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u83b7\u53d6\u4e3b\u8868\u4e3b\u952e\u5f02\u5e38");
        }
    }

    public FMybatisTemplate getTemplate() {
        try {
            Method masterTemplateMethod = this.masterClass.getMethod("getTemplate", new Class[0]);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterTemplateMethod.invoke(masterServiceObj, new Object[0]);
            return (FMybatisTemplate)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u83b7\u53d6MybatisTemplate\u5f02\u5e38");
        }
    }

    public String getBusinessIdentify() {
        return null;
    }

    public String getModelFlag(JSONObject dataRow) {
        if (dataRow.containsKey((Object)"_flag") && !StringUtils.isEmpty((Object)dataRow.get((Object)"_flag"))) {
            return dataRow.getString("_flag");
        }
        if (dataRow.containsKey((Object)"__flag") && !StringUtils.isEmpty((Object)dataRow.get((Object)"__flag"))) {
            return dataRow.getString("__flag");
        }
        return "#";
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        try {
            Method masterQueryMethod = this.masterClass.getMethod("onQuery", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterQueryMethod.invoke(masterServiceObj, session, paramsObject);
            return (ServiceResponse)data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ServiceResponse view(JSONObject paramsObject) {
        return this.view(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse view(ServiceSession session, JSONObject paramsObject) {
        JSONObject respdata = new JSONObject();
        try {
            respdata.put(this.getCollectionName(this.masterClass), this.viewWithBean(session, paramsObject));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u770b\u8be6\u60c5\u5931\u8d25:" + e.getMessage());
        }
        return ServiceResponse.buildSuccess((Object)respdata);
    }

    public <T> T viewWithBean(Long id) throws Exception {
        return this.viewWithBean(SpringContext.getSession(), id);
    }

    public <T> T viewWithBean(ServiceSession session, Long id) throws Exception {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put(this.getKeyfieldName(), (Object)id);
        return this.viewWithBean(session, jsonParam);
    }

    public <T> T viewWithBean(JSONObject paramsObject) throws Exception {
        return this.viewWithBean(SpringContext.getSession(), paramsObject);
    }

    public <T> T viewWithBean(ServiceSession session, JSONObject paramsObject) throws Exception {
        Method masterQueryMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterQueryMethod.invoke(masterServiceObj, session, paramsObject);
        if (!StringUtils.isEmpty((Object)data)) {
            this.getSlaveList(session, data);
        }
        return (T)TypeUtils.castToJavaBean((Object)data, (Class)this.masterBean);
    }

    public void getSlaveList(ServiceSession session, Object data) throws Exception {
        String[] masterSlaveFields = null;
        try {
            masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e3b\u8868\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef");
        }
        if (!StringUtils.isEmpty((Object)masterSlaveFields)) {
            Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
            for (String slaveService : this.slaveServiceNames) {
                String orderdir;
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class clazz = GenericTypeResolver.resolveTypeArgument(slaveClass, JDBCCompomentServiceImpl.class);
                if (StringUtils.isEmpty((Object)clazz)) continue;
                String[] masterSlaveFields_slave = null;
                try {
                    masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u4ece\u8868" + slaveCollectionName + "\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef");
                }
                if (StringUtils.isEmpty((Object)masterSlaveFields_slave)) continue;
                JSONObject slaveparam = new JSONObject();
                for (int i = 0; i < masterSlaveFields_slave.length; ++i) {
                    String field = masterSlaveFields_slave[i];
                    slaveparam.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, data, masterSlaveFields[i]));
                }
                String orderfields = this.getOrderField(clazz);
                if (!StringUtils.isEmpty((Object)orderfields)) {
                    slaveparam.put("order_field", (Object)orderfields);
                }
                if (!StringUtils.isEmpty((Object)(orderdir = this.getOrderDirection(clazz)))) {
                    slaveparam.put("order_direction", (Object)orderdir);
                }
                slaveparam.put("page_no", (Object)1);
                slaveparam.put("page_size", (Object)999999);
                Method slaveQueryMethod = slaveClass.getMethod("dataQuery", ServiceSession.class, JSONObject.class);
                Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                Object list = slaveQueryMethod.invoke(slaveServiceObj, session, slaveparam);
                Field field = AbstractEntityBean.fetchDeclaredField((Class)this.masterBean, (String)slaveCollectionName);
                Type type = field.getGenericType();
                if (type instanceof ParameterizedType) {
                    MasterSlaveComponentServiceImpl.setFieldValue(this.masterBean, data, slaveCollectionName, list);
                    continue;
                }
                List tmp = (List)list;
                if (StringUtils.isEmpty((Object)list) || tmp.size() <= 0) continue;
                MasterSlaveComponentServiceImpl.setFieldValue(this.masterBean, data, slaveCollectionName, tmp.get(0));
            }
        }
    }

    public void onBeforeDelete(ServiceSession session, JSONObject paramsObject) {
    }

    public void onAfterDelete(ServiceSession session, JSONObject paramsObject) {
    }

    public ServiceResponse delete(JSONObject paramsObject) {
        return this.delete(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse delete(ServiceSession session, JSONObject paramsObject) {
        return this.onDelete(session, paramsObject);
    }

    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        try {
            this.onBeforeDelete(session, paramsObject);
            Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterViewMethod.invoke(masterServiceObj, session, paramsObject);
            this.onDeleteSlave(session, data);
            Method masterDeleteMethod = this.masterClass.getMethod("onDelete", ServiceSession.class, JSONObject.class);
            Object object = masterDeleteMethod.invoke(masterServiceObj, session, paramsObject);
            this.onAfterDelete(session, paramsObject);
            return (ServiceResponse)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void onDeleteSlave(ServiceSession session, Object data) throws Exception {
        if (!StringUtils.isEmpty((Object)data)) {
            String[] masterSlaveFields = null;
            try {
                masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u4e3b\u8868\u6a21\u578b\u4e2d\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef");
            }
            if (!StringUtils.isEmpty((Object)masterSlaveFields)) {
                Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
                for (String slaveService : this.slaveServiceNames) {
                    Class<?> slaveClass = this.getServiceBean(slaveService);
                    String slaveCollectionName = this.getCollectionName(slaveClass);
                    Class<?> clazz = flds.get(slaveCollectionName);
                    if (StringUtils.isEmpty(clazz)) continue;
                    String[] masterSlaveFields_slave = null;
                    try {
                        masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("\u4ece\u8868" + slaveCollectionName + "\u672a\u914d\u7f6e\u4e3b\u4ece\u5173\u8054\uff0c\u6216\u8005\u914d\u7f6e\u9519\u8bef");
                    }
                    if (StringUtils.isEmpty((Object)masterSlaveFields_slave)) continue;
                    JSONObject slaveparam = new JSONObject();
                    for (int i = 0; i < masterSlaveFields_slave.length; ++i) {
                        String field = masterSlaveFields_slave[i];
                        slaveparam.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, data, masterSlaveFields[i]));
                    }
                    Method slaveDeleteMethod = slaveClass.getMethod("onDelete", ServiceSession.class, JSONObject.class);
                    Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                    slaveDeleteMethod.invoke(slaveServiceObj, session, slaveparam);
                }
            }
        }
    }

    public ServiceResponse insert(JSONObject paramsObject) throws Exception {
        return this.insert(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse insert(ServiceSession session, JSONObject paramsObject) throws Exception {
        return this.onInsert(session, paramsObject);
    }

    public void onBeforeSave(ServiceSession session, JSONObject paramsObject) {
    }

    public void onAfterSave(ServiceSession session, JSONObject paramsObject) {
    }

    public void beforeSave(ServiceSession session, T bean) {
    }

    public ServiceResponse save(ServiceSession session, T bean) throws Exception {
        this.beforeSave(session, bean);
        return ServiceResponse.buildSuccess((Object)"null");
    }

    public ServiceResponse onSave(ServiceSession session, JSONObject paramsObject) throws Exception {
        this.onBeforeSave(session, paramsObject);
        Method masterSaveMethod = this.masterClass.getMethod("onSave", ServiceSession.class, JSONObject.class);
        Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
        Object data = masterSaveMethod.invoke(masterServiceObj, session, paramsObject);
        String masterCollectionName = this.getCollectionName(this.masterClass);
        String masterKeyField = this.getKeyfieldName();
        ServiceResponse response = (ServiceResponse)data;
        if ("0".equals(response.getReturncode())) {
            Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
            JSONObject queryParam = new JSONObject();
            queryParam.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
            Object masterData = masterViewMethod.invoke(masterServiceObj, session, queryParam);
            String[] masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
            Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
            for (String slaveService : this.slaveServiceNames) {
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class<?> clazz = flds.get(slaveCollectionName);
                if (StringUtils.isEmpty(clazz)) continue;
                String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                Object slave = null;
                if (paramsObject.containsKey((Object)masterCollectionName)) {
                    slave = paramsObject.getJSONObject(masterCollectionName).get((Object)slaveCollectionName);
                } else {
                    slave = paramsObject.get((Object)slaveCollectionName);
                    if (Character.isDigit(slaveCollectionName.charAt(slaveCollectionName.length() - 1)) && StringUtils.isEmpty((Object)slave)) {
                        slave = paramsObject.get((Object)slaveCollectionName.substring(0, slaveCollectionName.length() - 1));
                    }
                }
                this.onSaveSlave(session, slaveClass, masterData, slave, masterSlaveFields, masterSlaveFields_slave);
            }
            paramsObject.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
            this.onAfterSave(session, paramsObject);
        }
        return response;
    }

    public void onSaveSlave(ServiceSession session, Class<?> clazz, Object masterData, Object slave, String[] linkFields_master, String[] linkFields_slave) throws Exception {
        String slaveCollectionName = this.getCollectionName(clazz);
        String keyField = this.getKeyfieldName(clazz);
        if (slave != null && slave instanceof List) {
            JSONArray paramsArray = (JSONArray)slave;
            ArrayList deleteList = new ArrayList();
            JSONArray deleteArray = new JSONArray();
            JSONArray insertArray = new JSONArray();
            JSONArray updateArray = new JSONArray();
            paramsArray.forEach(e -> {
                JSONObject dataMap = (JSONObject)JSON.toJSON((Object)e);
                String dataFlag = this.getModelFlag(dataMap);
                if ("D".equalsIgnoreCase(dataFlag)) {
                    if (!StringUtils.isEmpty((Object)dataMap.get((Object)keyField))) {
                        deleteList.add(dataMap.get((Object)keyField));
                        JSONObject keys = new JSONObject();
                        keys.put(keyField, dataMap.get((Object)keyField));
                        keys.put("_flag", (Object)"D");
                        deleteArray.add((Object)keys);
                    }
                } else if ("I".equalsIgnoreCase(dataFlag)) {
                    for (int j = 0; j < linkFields_slave.length; ++j) {
                        String field = linkFields_slave[j];
                        if (dataMap.containsKey((Object)field) && !StringUtils.isEmpty((Object)dataMap.get((Object)field)) || !this.getModelFlag(dataMap).equals("I")) continue;
                        try {
                            Object obj = MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, masterData, linkFields_master[j]);
                            dataMap.put(field, obj);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    insertArray.add((Object)dataMap);
                } else if ("U".equalsIgnoreCase(dataFlag)) {
                    updateArray.add((Object)dataMap);
                }
            });
            Object slaveServiceObj = SpringContext.getBean(clazz, (Object[])new Object[0]);
            Method slaveSaveMethod = clazz.getMethod("onSave", ServiceSession.class, JSONObject.class);
            Object slaveDelMethod = null;
            Object slaveInsMethod = null;
            Object slaveUptMethod = null;
            JSONObject slaveDelParam = new JSONObject();
            JSONObject slaveInsParam = new JSONObject();
            JSONObject slaveUptParam = new JSONObject();
            Object slaveDelData = null;
            ServiceResponse slaveDelResponse = null;
            Object slaveInsData = null;
            ServiceResponse slaveInsResponse = null;
            Object slaveUptData = null;
            ServiceResponse slaveUptResponse = null;
            if (!StringUtils.isEmpty((Object)deleteArray) && deleteArray.size() > 0) {
                slaveDelParam.put(slaveCollectionName, (Object)deleteArray);
                slaveDelData = slaveSaveMethod.invoke(slaveServiceObj, session, slaveDelParam);
                slaveDelResponse = (ServiceResponse)slaveDelData;
                if (!"0".equals(slaveDelResponse.getReturncode())) {
                    throw new ServiceRuntimeException(slaveDelResponse.getData().toString());
                }
            }
            if (!StringUtils.isEmpty((Object)insertArray) && insertArray.size() > 0) {
                slaveInsParam.put(slaveCollectionName, (Object)insertArray);
                slaveInsData = slaveSaveMethod.invoke(slaveServiceObj, session, slaveInsParam);
                slaveInsResponse = (ServiceResponse)slaveInsData;
                if (!"0".equals(slaveInsResponse.getReturncode())) {
                    throw new ServiceRuntimeException(slaveInsResponse.getData().toString());
                }
            }
            if (!StringUtils.isEmpty((Object)updateArray) && updateArray.size() > 0) {
                slaveUptParam.put(slaveCollectionName, (Object)updateArray);
                slaveUptData = slaveSaveMethod.invoke(slaveServiceObj, session, slaveUptParam);
                slaveUptResponse = (ServiceResponse)slaveUptData;
                if (!"0".equals(slaveUptResponse.getReturncode())) {
                    throw new ServiceRuntimeException(slaveUptResponse.getData().toString());
                }
            }
        } else if (slave != null && slave instanceof Map) {
            Object slaveServiceObj;
            Map slavemap = (Map)slave;
            for (int j = 0; j < linkFields_slave.length; ++j) {
                String field = linkFields_slave[j];
                if (slavemap.containsKey(field) && !StringUtils.isEmpty(slavemap.get(field)) || !this.getModelFlag((JSONObject)slavemap).equals("I")) continue;
                slavemap.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, masterData, linkFields_master[j]));
            }
            Method slaveSaveMethod = clazz.getMethod("onSave", ServiceSession.class, JSONObject.class);
            Object slavedata = slaveSaveMethod.invoke(slaveServiceObj = SpringContext.getBean(clazz, (Object[])new Object[0]), session, slavemap);
            ServiceResponse slaveresponse = (ServiceResponse)slavedata;
            if (!"0".equals(slaveresponse.getReturncode())) {
                throw new ServiceRuntimeException(slaveresponse.getData().toString());
            }
        }
    }

    protected Map<String, Class<?>> getSlaveBean(Class<?> masterClazz) throws Exception {
        List<Class> classes = this.getSlaveBeans();
        HashMap map = new HashMap();
        Field[] fields = masterClazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                String[] slavekey;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Field fld = this.getMasterSlaveField((Class)(type = parameterizedType.getActualTypeArguments()[0]));
                if (fld == null || StringUtils.isEmpty((Object)(slavekey = (String[])fld.get(null)))) continue;
                map.put(field.getName(), (Class)type);
                continue;
            }
            if (!classes.contains(type)) continue;
            map.put(field.getName(), (Class)type);
        }
        return map;
    }

    public List<Class> getSlaveBeans() throws Exception {
        ArrayList<Class> list = new ArrayList<Class>();
        for (String slaveService : this.slaveServiceNames) {
            Class<?> slaveClass = this.getServiceBean(slaveService);
            Class slaveBean = GenericTypeResolver.resolveTypeArgument(slaveClass, JDBCCompomentServiceImpl.class);
            list.add(slaveBean);
        }
        return list;
    }

    protected Field getMasterSlaveField(Class<?> cl) {
        return this.getModelField(cl, "MASTER_SLAVE_KEY");
    }

    protected String getOrderField(Class<?> cl) {
        try {
            Field fld = this.getModelField(cl, "ORDER_FIELD");
            return (String)fld.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getOrderDirection(Class<?> cl) {
        try {
            Field fld = this.getModelField(cl, "ORDER_DIRECTION");
            return (String)fld.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Field getModelField(Class<?> cl, String fieldName) {
        return AbstractEntityBean.fetchDeclaredField(cl, (String)fieldName);
    }

    protected String[] getMasterSlaveFields(Class<?> cl) throws Exception {
        Field fld = this.getMasterSlaveField(cl);
        return (String[])fld.get(null);
    }

    public Class<?> getServiceBean(String serviceName) throws Exception {
        Class<?> c = Class.forName(this.masterClass.getPackage().getName() + "." + serviceName);
        return c;
    }

    public String getCollectionName(Class<?> Clazz) throws Exception {
        Method method = Clazz.getMethod("getCollectionName", new Class[0]);
        Object obj = SpringContext.getBean(Clazz, (Object[])new Object[0]);
        String collectionName = (String)method.invoke(obj, new Object[0]);
        return collectionName;
    }

    public static Object getFieldValue(Class clazz, Object bean, String col) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getReadMethod();
        Object o1 = getMethod.invoke(bean, new Object[0]);
        return o1;
    }

    public static void setFieldValue(Class clazz, Object bean, String col, Object object) throws Exception {
        PropertyDescriptor pd = new PropertyDescriptor(col, clazz);
        Method getMethod = pd.getWriteMethod();
        getMethod.invoke(bean, object);
    }

    public <T> T dataQueryFirst(Query query) {
        return this.dataQueryFirst(SpringContext.getSession(), query);
    }

    public <T> T dataQueryFirst(ServiceSession session, Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, Query.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, query, this.getCollectionName(), this.masterBean);
            return (T)TypeUtils.castToJavaBean((Object)data, (Class)this.masterBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public <T> T dataQueryFirst(JSONObject paramsObject) {
        return this.dataQueryFirst(SpringContext.getSession(), paramsObject);
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject) {
        return this.dataQueryFirst(session, paramsObject, this.getCollectionName(), this.masterBean);
    }

    public <T> T dataQueryFirst(JSONObject paramsObject, Class<T> classzz) {
        return this.dataQueryFirst(SpringContext.getSession(), paramsObject, classzz);
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject, Class<T> classzz) {
        return this.dataQueryFirst(session, paramsObject, this.getCollectionName(), classzz);
    }

    public <T> T dataQueryFirst(JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return this.dataQueryFirst(SpringContext.getSession(), paramsObject, collectionName, classzz);
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, paramsObject, collectionName, classzz);
            return (T)TypeUtils.castToJavaBean((Object)data, classzz);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public <T> T dataQueryById(Long id) {
        try {
            return this.viewWithBean(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public <T> List<T> dataQuery(Query query) {
        return this.dataQuery(SpringContext.getSession(), query);
    }

    public <T> List<T> dataQuery(ServiceSession session, Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQuery", ServiceSession.class, Query.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, query, this.getCollectionName(), this.masterBean);
            return (List)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public <T> List<T> dataQuery(JSONObject paramsObject) {
        return this.dataQuery(SpringContext.getSession(), paramsObject);
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject) {
        return this.dataQuery(session, paramsObject, this.getCollectionName(), this.masterBean);
    }

    public <T> List<T> dataQuery(JSONObject paramsObject, Class<T> classzz) {
        return this.dataQuery(SpringContext.getSession(), paramsObject, classzz);
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject, Class<T> classzz) {
        return this.dataQuery(session, paramsObject, this.getCollectionName(), classzz);
    }

    public <T> List<T> dataQuery(JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return this.dataQuery(SpringContext.getSession(), paramsObject, collectionName, classzz);
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQuery", ServiceSession.class, JSONObject.class, String.class, Class.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, paramsObject, collectionName, classzz);
            return (List)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public void onBeforeInsert(ServiceSession session, JSONObject paramsObject) {
    }

    public void onAfterInsert(ServiceSession session, JSONObject paramsObject) {
    }

    public ServiceResponse onInsert(ServiceSession session, JSONObject paramsObject) {
        try {
            this.onBeforeInsert(session, paramsObject);
            Method masterSaveMethod = this.masterClass.getMethod("onInsert", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterSaveMethod.invoke(masterServiceObj, session, paramsObject);
            String masterCollectionName = this.getCollectionName(this.masterClass);
            String masterKeyField = this.getKeyfieldName();
            ServiceResponse response = (ServiceResponse)data;
            JSONObject queryParam = new JSONObject();
            queryParam.put(masterKeyField, TypeUtils.toJSONObj((Object)response.getData(), (boolean)false, (SerializerFeature[])new SerializerFeature[0]).get((Object)masterKeyField));
            Method masterViewMethod = this.masterClass.getMethod("dataQueryFirst", ServiceSession.class, JSONObject.class);
            Object masterData = masterViewMethod.invoke(masterServiceObj, session, queryParam);
            String[] masterSlaveFields = this.getMasterSlaveFields(this.masterBean);
            Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
            for (String slaveService : this.slaveServiceNames) {
                Class<?> slaveClass = this.getServiceBean(slaveService);
                String slaveCollectionName = this.getCollectionName(slaveClass);
                Class<?> clazz = flds.get(slaveCollectionName);
                if (StringUtils.isEmpty(clazz)) continue;
                String[] masterSlaveFields_slave = this.getMasterSlaveFields(clazz);
                Object slave = null;
                slave = paramsObject.containsKey((Object)masterCollectionName) ? paramsObject.getJSONObject(masterCollectionName).get((Object)slaveCollectionName) : paramsObject.get((Object)slaveCollectionName);
                Method slaveSaveMethod = slaveClass.getMethod("onInsert", ServiceSession.class, JSONObject.class);
                Object slaveServiceObj = SpringContext.getBean(slaveClass, (Object[])new Object[0]);
                if (slave != null && slave instanceof List) {
                    JSONArray paramsArray = (JSONArray)slave;
                    for (int i = 0; i < paramsArray.size(); ++i) {
                        JSONObject params = paramsArray.getJSONObject(i);
                        for (int j = 0; j < masterSlaveFields_slave.length; ++j) {
                            String field = masterSlaveFields_slave[j];
                            if (params.containsKey((Object)field) || !StringUtils.isEmpty((Object)params.get((Object)field))) continue;
                            params.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, masterData, masterSlaveFields[j]));
                        }
                    }
                    JSONObject slaveparam = new JSONObject();
                    slaveparam.put(slaveCollectionName, slave);
                    slaveSaveMethod.invoke(slaveServiceObj, session, slaveparam);
                    continue;
                }
                if (slave == null || !(slave instanceof Map)) continue;
                Map slavemap = (Map)slave;
                for (int j = 0; j < masterSlaveFields_slave.length; ++j) {
                    String field = masterSlaveFields_slave[j];
                    if (slavemap.containsKey(field) || !StringUtils.isEmpty(slavemap.get(field))) continue;
                    slavemap.put(field, MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, masterData, masterSlaveFields[j]));
                }
                slaveSaveMethod.invoke(slaveServiceObj, session, slavemap);
            }
            this.onAfterInsert(session, paramsObject);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public ServiceResponse onUpdate(ServiceSession session, JSONObject paramsObject) {
        try {
            Method masterSaveMethod = this.masterClass.getMethod("onUpdate", ServiceSession.class, JSONObject.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterSaveMethod.invoke(masterServiceObj, session, paramsObject);
            return (ServiceResponse)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    public <T> ServiceResponse onInsert(ServiceSession session, T bean) {
        JSONObject jsonparam = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        return this.onInsert(session, jsonparam);
    }

    public <T> ServiceResponse onDelete(ServiceSession session, T bean) {
        JSONObject jsonparam = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        return this.onDelete(session, jsonparam);
    }

    public <T> ServiceResponse onUpdate(ServiceSession session, T bean) {
        JSONObject jsonparam = TypeUtils.toJSONObj(bean, (boolean)false, (SerializerFeature[])new SerializerFeature[0]);
        return this.onUpdate(session, jsonparam);
    }

    public ServiceResponse onInsert(JSONObject paramsObject) {
        return this.onInsert(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onDelete(JSONObject paramsObject) {
        return this.onDelete(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onUpdate(JSONObject paramsObject) {
        return this.onUpdate(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onQuery(JSONObject paramsObject) {
        return this.onQuery(SpringContext.getSession(), paramsObject);
    }

    public ServiceResponse onSave(JSONObject paramsObject) throws Exception {
        return this.onSave(SpringContext.getSession(), paramsObject);
    }

    public <T> List<T> dataQueryTotal(Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryTotal", Query.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, query);
            return (List)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public <T> int onUpdateBean(T bean) {
        return this.onUpdateBean(bean, null);
    }

    public <T> int onUpdateBean(T bean, Set<String> keys) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("onUpdateBean", bean.getClass(), Set.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, bean, keys);
            return (Integer)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public <T> List<T> dataQueryTotalPage(Query query) {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("dataQueryTotalPage", Query.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, query);
            return (List)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public ServiceResponse onImportData(String params, MultipartFile file) throws Exception {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("onImportData", String.class, MultipartFile.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, params, file);
            return (ServiceResponse)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public ServiceResponse onImportData(ServiceSession session, String params, MultipartFile file) throws Exception {
        try {
            Method masterKeyMethod = this.masterClass.getMethod("onImportData", ServiceSession.class, String.class, MultipartFile.class);
            Object masterServiceObj = SpringContext.getBean(this.masterClass, (Object[])new Object[0]);
            Object data = masterKeyMethod.invoke(masterServiceObj, session, params, file);
            return (ServiceResponse)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException(e.getMessage());
        }
    }

    public <T> void batchInsert(List<T> list) throws Exception {
        this.batchInsert(this.masterClass, list);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList);
        }
    }

    public <T> List getSlaveList(List<T> list, String CollectionName, Class<?> clazz) throws Exception {
        ArrayList slaveList = new ArrayList();
        for (T t : list) {
            List tmp = (List)MasterSlaveComponentServiceImpl.getFieldValue(this.masterBean, t, CollectionName);
            if (StringUtils.isEmpty((Object)tmp) || tmp.size() <= 0) continue;
            slaveList.addAll(tmp);
        }
        return slaveList;
    }

    public <T> void batchInsert(List<T> list, int batch_rows) throws Exception {
        this.batchInsert(this.masterClass, list, batch_rows);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList, batch_rows);
        }
    }

    public <T> void batchInsert(List<T> list, Set<String> fields) throws Exception {
        this.batchInsert(this.masterClass, list, fields);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList);
        }
    }

    public <T> void batchInsert(List<T> list, Set<String> fields, int batch_rows) throws Exception {
        this.batchInsert(this.masterClass, list, fields, batch_rows);
        Map<String, Class<?>> flds = this.getSlaveBean(this.masterBean);
        for (String slaveService : this.slaveServiceNames) {
            List slaveList;
            Class<?> slaveClass = this.getServiceBean(slaveService);
            String slaveCollectionName = this.getCollectionName(slaveClass);
            Class<?> clazz = flds.get(slaveCollectionName);
            if (StringUtils.isEmpty(clazz) || StringUtils.isEmpty((Object)(slaveList = this.getSlaveList(list, slaveCollectionName, clazz))) || slaveList.size() <= 0) continue;
            this.batchInsert(slaveClass, slaveList, batch_rows);
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list, Set<String> fields, int batch_rows) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class, Set.class, Integer.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list, fields, batch_rows);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u6279\u91cf\u63d2\u5165\u5931\u8d25");
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list, Set<String> fields) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class, Set.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list, fields);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u6279\u91cf\u63d2\u5165\u5931\u8d25");
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u6279\u91cf\u63d2\u5165\u5931\u8d25");
        }
    }

    public <T> void batchInsert(Class<?> cl, List<T> list, int batch_rows) {
        try {
            Method batchInsertMethod = cl.getMethod("batchInsert", List.class, Integer.class);
            Object serviceObj = SpringContext.getBean(cl, (Object[])new Object[0]);
            batchInsertMethod.invoke(serviceObj, list, batch_rows);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceRuntimeException("\u6279\u91cf\u63d2\u5165\u5931\u8d25");
        }
    }
}

