/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.efuture.redis.component.RedisClient;
import com.efuture.redis.constant.RedisConstant;
import com.product.component.BaseCompomentServiceImpl;
import com.product.controller.ProductController;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public abstract class RedisCompomentServiceImpl<X>
extends BaseCompomentServiceImpl<RedisClient, X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductController.class);
    private int keepSeconds;
    private List<String> indexFields;

    public int getKeepSeconds() {
        return this.keepSeconds;
    }

    public void setKeepSeconds(int keepSeconds) {
        this.keepSeconds = keepSeconds;
    }

    public List<String> getIndexFields() {
        return this.indexFields;
    }

    public void setIndexFields(List<String> indexFields) {
        this.indexFields = indexFields;
    }

    public RedisCompomentServiceImpl(String collectionName, String keyfieldName) {
        super(collectionName, keyfieldName);
    }

    @Override
    protected long onCount(ServiceSession session, RedisClient template, Query query, String collectionName) {
        Document dbQuery = query.getQueryObject();
        String redisQuery = null;
        ArrayList<String> otherKeys = new ArrayList<String>();
        Set keySet = dbQuery.keySet();
        try {
            for (String keyName : keySet) {
                if (StringUtils.isEmpty(redisQuery)) {
                    redisQuery = String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbQuery.get((Object)keyName));
                    continue;
                }
                otherKeys.add(String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbQuery.get((Object)keyName)));
            }
        }
        catch (Exception e) {
            LOGGER.error("onCount\u6267\u884c\u5f02\u5e38, \u67e5\u8be2\u6761\u4ef6:query--" + query + ", collectionName--" + collectionName);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return template.onCount(session.getEnt_id(), this.getCollectionName(), redisQuery, otherKeys);
    }

    @Override
    protected <T> List<T> onFind(ServiceSession session, RedisClient template, Query query, Class<T> entityClass, String collectionName) {
        ArrayList<Object> response = new ArrayList<Object>();
        try {
            List dataList;
            Object dataRow;
            String data;
            ArrayList fieldList = new ArrayList();
            ArrayList<String> operatorList = new ArrayList<String>();
            ArrayList<Object> argslist = new ArrayList<Object>();
            Document dbQuery = query.getQueryObject();
            int limit = query.getLimit();
            int skip = Math.toIntExact(query.getSkip());
            String redisQuery = null;
            boolean isLuaQuery = false;
            ArrayList<String> otherKeys = new ArrayList<String>();
            Set keySet = dbQuery.keySet();
            for (Iterator keyName : keySet) {
                Object dbValue = dbQuery.get((Object)keyName);
                if (StringUtils.isEmpty(redisQuery)) {
                    redisQuery = String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbValue);
                } else {
                    otherKeys.add(String.format("%1$s:%2$s:%3$s", this.getCollectionName(), keyName, dbValue));
                }
                if (dbValue instanceof Map) {
                    isLuaQuery = true;
                    Map dataRow2 = (Map)dbValue;
                    Set operKeys = dataRow2.keySet();
                    for (String operKey : operKeys) {
                        Object operValue = dataRow2.get(operKey);
                        if ("=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("=");
                            argslist.add(operValue);
                            continue;
                        }
                        if (">".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add(">");
                            argslist.add(operValue);
                            continue;
                        }
                        if (">=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add(">=");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("<".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("<");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("<=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("<=");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("!=".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("!=");
                            argslist.add(operValue);
                            continue;
                        }
                        if ("like".equals(operKey)) {
                            fieldList.add(keyName);
                            operatorList.add("like");
                            argslist.add(operValue);
                            continue;
                        }
                        if (!"in".equals(operKey)) continue;
                        fieldList.add(keyName);
                        operatorList.add("in");
                        if (operValue instanceof List) {
                            argslist.add(operValue);
                            continue;
                        }
                        ArrayList sublist = new ArrayList();
                        sublist.add(operValue);
                        argslist.add(sublist);
                    }
                    continue;
                }
                if (dbValue instanceof List) {
                    isLuaQuery = true;
                    fieldList.add(keyName);
                    operatorList.add("in");
                    argslist.add(dbValue);
                    continue;
                }
                fieldList.add(keyName);
                operatorList.add("=");
                argslist.add(dbValue);
            }
            if (isLuaQuery) {
                List results = null;
                LOGGER.info("... queryByLua \u67e5\u8be2\u5230\u7ed3\u679c\u96c6\uff1a" + results.size());
                for (String id : results) {
                    Map dataMap = template.onQueryById(session.getEnt_id(), this.getCollectionName(), id);
                    data = JSON.toJSONString((Object)dataMap);
                    dataRow = JSON.parseObject((String)data, entityClass);
                    response.add(dataRow);
                }
            } else if (keySet.size() < 1) {
                dataList = template.onQueryPage(session.getEnt_id(), this.getCollectionName(), limit, skip, RedisConstant.Sort.nosort);
                for (Map dataMap : dataList) {
                    String data2 = JSON.toJSONString((Object)dataMap);
                    Object dataRow3 = JSON.parseObject((String)data2, entityClass);
                    response.add(dataRow3);
                }
            } else {
                dataList = template.onQueryPageByCondition(session.getEnt_id(), RedisConstant.Sort.nosort, this.getCollectionName(), skip, limit, redisQuery, otherKeys);
                List mapList = template.onQueryByIdList(session.getEnt_id(), this.getCollectionName(), dataList);
                for (Map dataMap : mapList) {
                    data = JSON.toJSONString((Object)dataMap);
                    dataRow = JSON.parseObject((String)data, entityClass);
                    response.add(dataRow);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("onFind\u6267\u884c\u5f02\u5e38, \u67e5\u8be2\u6761\u4ef6:query--" + query + ", collectionName--" + collectionName);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    protected Document onDefaultRowInsert(Query query, Update update) {
        Document dbInsert = new Document();
        Document dbUpdateObject = update.getUpdateObject();
        Object oDataSet = dbUpdateObject.get((Object)"$set");
        Object oDataInsert = dbUpdateObject.get((Object)"$setOnInsert");
        if (oDataSet != null && oDataSet instanceof Document) {
            dbInsert.putAll((Map)((Document)oDataSet));
        }
        if (oDataInsert != null && oDataInsert instanceof Document) {
            dbInsert.putAll((Map)((Document)oDataInsert));
        }
        dbInsert.putAll((Map)query.getQueryObject());
        return dbInsert;
    }

    @Override
    protected void onUpsert(ServiceSession session, RedisClient template, Query query, Update update, String collectionName) {
        Document dbQuery = query.getQueryObject();
        String primaryKey = TypeUtils.castToString((Object)dbQuery.get((Object)this.getKeyfieldName()));
        HashMap updateRow = new HashMap();
        HashMap InsertRow = new HashMap();
        Set keys = update.getUpdateObject().keySet();
        for (String keyname : keys) {
            if ("$set".equalsIgnoreCase(keyname)) {
                Document updateMap = (Document)update.getUpdateObject().get((Object)keyname);
                updateRow.putAll(updateMap);
                continue;
            }
            if (!"$setOnInsert".equalsIgnoreCase(keyname)) continue;
            Document insertMap = (Document)update.getUpdateObject().get((Object)keyname);
            updateRow.putAll(insertMap);
        }
        template.onRowUpsert(session.getEnt_id(), this.getCollectionName(), updateRow, InsertRow, primaryKey, this.getIndexFields(), this.getKeepSeconds());
    }

    @Override
    protected int onInsertd(ServiceSession session, RedisClient template, JSONObject dataRow, String collectionName) {
        String primaryKey = dataRow.getString(this.getKeyfieldName());
        template.onRowInsert(session.getEnt_id(), this.getCollectionName(), (Map)dataRow, primaryKey, this.getIndexFields(), this.getKeepSeconds());
        return 1;
    }

    @Override
    protected void onInsert(ServiceSession session, RedisClient template, JSONObject dataRow, String collectionName) {
        String primaryKey = dataRow.getString(this.getKeyfieldName());
        template.onRowInsert(session.getEnt_id(), this.getCollectionName(), (Map)dataRow, primaryKey, this.getIndexFields(), this.getKeepSeconds());
    }

    @Override
    protected void onRemove(ServiceSession session, RedisClient template, Query query, String collectionName) {
        Document dbQuery = query.getQueryObject();
        String primaryKey = TypeUtils.castToString((Object)dbQuery.get((Object)this.getKeyfieldName()));
        template.onRowDelete(session.getEnt_id(), this.getCollectionName(), primaryKey, this.getIndexFields());
    }

    public <T> T dataQueryById(Long id) {
        return null;
    }

    public <T> T dataQueryFirst(Query query) {
        return null;
    }

    public <T> T dataQueryFirst(JSONObject paramsObject) {
        return null;
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    public <T> T dataQueryFirst(JSONObject paramsObject, Class<T> classzz) {
        return null;
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject, Class<T> classzz) {
        return null;
    }

    public <T> T dataQueryFirst(JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return null;
    }

    public <T> T dataQueryFirst(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return null;
    }

    public <T> List<T> dataQuery(JSONObject paramsObject) {
        return null;
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    public <T> List<T> dataQuery(JSONObject paramsObject, Class<T> classzz) {
        return null;
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject, Class<T> classzz) {
        return null;
    }

    public <T> List<T> dataQuery(JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return null;
    }

    public <T> List<T> dataQuery(ServiceSession session, JSONObject paramsObject, String collectionName, Class<T> classzz) {
        return null;
    }

    public <T> List<T> dataQuery(Query query) {
        return null;
    }

    public <T> T dataQueryFirst(ServiceSession session, Query query) {
        return null;
    }

    public <T> List<T> dataQuery(ServiceSession session, Query query) {
        return null;
    }

    public <T> List<T> dataQueryTotal(Query query) {
        return null;
    }

    public <T> List<T> dataQueryTotalPage(Query query) {
        return null;
    }

    public ServiceResponse view(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    public ServiceResponse view(JSONObject paramsObject) {
        return null;
    }

    public <T> T viewWithBean(JSONObject paramsObject) throws Exception {
        return null;
    }

    public <T> T viewWithBean(ServiceSession session, JSONObject paramsObject) throws Exception {
        return null;
    }

    public <T> void batchInsert(List<T> list) throws Exception {
    }

    public <T> void batchInsert(List<T> list, int batch_rows) throws Exception {
    }
}

