/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.isce;

import com.alibaba.fastjson.JSONObject;
import com.product.component.MasterSlaveComponentServiceImpl;
import com.product.component.globrule.GlobRuleSrv;
import com.product.component.isce.BillComponentService;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.model.isce.BaseSheetHeadModel;
import com.product.util.SpringContext;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.StringUtils;

public class BillComponentServiceImpl<X>
extends MasterSlaveComponentServiceImpl<X>
implements BillComponentService {
    final Class<X> masterClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), BillComponentServiceImpl.class);

    public BillComponentServiceImpl(String[] slaveServiceNames) {
        super(slaveServiceNames);
    }

    @Override
    public void onBeforeInsert(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"sheetid") || StringUtils.isEmpty((Object)paramsObject.get((Object)"sheetid"))) {
            try {
                String sheetId = this.getSheetId(session, paramsObject);
                paramsObject.put("sheetid", (Object)sheetId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceRuntimeException("\u751f\u6210\u5355\u636e\u7f16\u53f7\u5931\u8d25");
            }
        }
    }

    @Override
    public void onAfterInsert(ServiceSession session, JSONObject paramsObject) {
    }

    @Override
    public void onBeforeSave(ServiceSession session, JSONObject paramsObject) {
        if ((!paramsObject.containsKey((Object)"sheetid") || StringUtils.isEmpty((Object)paramsObject.get((Object)"sheetid"))) && this.getModelFlag(paramsObject).equals("I")) {
            try {
                String sheetId = this.getSheetId(session, paramsObject);
                paramsObject.put("sheetid", (Object)sheetId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceRuntimeException("\u751f\u6210\u5355\u636e\u7f16\u53f7\u5931\u8d25");
            }
        }
    }

    @Override
    public void onAfterSave(ServiceSession session, JSONObject jsonparam) {
    }

    @Override
    public void onBeforeDelete(ServiceSession session, JSONObject paramsObject) {
    }

    @Override
    public void onAfterDelete(ServiceSession session, JSONObject paramsObject) {
    }

    @Override
    public ServiceResponse audit(JSONObject paramsObject) throws Exception {
        return this.audit(SpringContext.getSession(), paramsObject);
    }

    @Override
    public ServiceResponse audit(ServiceSession session, JSONObject paramsObject) throws Exception {
        BaseSheetHeadModel bean = (BaseSheetHeadModel)this.viewWithBean(session, paramsObject);
        return this.audit(session, bean);
    }

    @Override
    public ServiceResponse audit(ServiceSession session, BaseSheetHeadModel bean) throws Exception {
        if (StringUtils.isEmpty((Object)bean) || StringUtils.isEmpty((Object)bean.getSheetid())) {
            throw new ServiceRuntimeException("\u5355\u636esheetid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.onBeforeAudit(session, bean);
        this.onAudit(session, bean);
        this.onAfterAudit(session, bean);
        return ServiceResponse.buildSuccess((Object)"\u5ba1\u6838\u6210\u529f");
    }

    public void onBeforeAudit(ServiceSession session, BaseSheetHeadModel bean) {
        if (StringUtils.isEmpty((Object)bean.getSheetid())) {
            String errMsg = "\u5355\u636e\u5ba1\u6838\uff0c\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            throw new ServiceRuntimeException(errMsg);
        }
    }

    public void onBeforeAudit(BaseSheetHeadModel bean) {
    }

    public Set<String> onAudit(BaseSheetHeadModel bean) {
        return null;
    }

    public void onAudit(ServiceSession session, BaseSheetHeadModel bean) {
    }

    public void onAfterAudit(BaseSheetHeadModel bean) {
    }

    public void onAfterAudit(ServiceSession session, BaseSheetHeadModel bean) {
    }

    @Override
    public ServiceResponse cancel(JSONObject paramsObject) throws Exception {
        return this.cancel(SpringContext.getSession(), paramsObject);
    }

    @Override
    public ServiceResponse cancel(ServiceSession session, JSONObject paramsObject) throws Exception {
        BaseSheetHeadModel bean = (BaseSheetHeadModel)this.viewWithBean(session, paramsObject);
        return this.cancel(session, bean);
    }

    @Override
    public ServiceResponse cancel(ServiceSession session, BaseSheetHeadModel bean) throws Exception {
        if (StringUtils.isEmpty((Object)bean) || StringUtils.isEmpty((Object)bean.getSheetid())) {
            throw new ServiceRuntimeException("\u5355\u636esheetid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.onBeforeCancel(session, bean);
        this.onCancel(session, bean);
        this.onAfterCancel(session, bean);
        return ServiceResponse.buildSuccess((Object)"\u5ba1\u6838\u6210\u529f");
    }

    public void onBeforeCancel(ServiceSession session, BaseSheetHeadModel bean) {
    }

    public void onCancel(ServiceSession session, BaseSheetHeadModel bean) {
    }

    public void onAfterCancel(ServiceSession session, BaseSheetHeadModel bean) {
    }

    @Override
    public String getSheetId(ServiceSession session, JSONObject jsonparam) throws Exception {
        GlobRuleSrv globRuleSrv = (GlobRuleSrv)SpringContext.getContext().getBean(GlobRuleSrv.class);
        String sheetid = globRuleSrv.getSheetId(session, jsonparam);
        return sheetid;
    }

    @Override
    public ServiceResponse generateSheetId(ServiceSession session, JSONObject jsonparam) throws Exception {
        String sheetid = this.getSheetId(session, jsonparam);
        JSONObject rtnObject = new JSONObject();
        rtnObject.put("sheetid", (Object)sheetid);
        return ServiceResponse.buildSuccess((Object)rtnObject);
    }

    @Override
    public ServiceResponse audit(List<Long> ids) throws Exception {
        if (ids == null || ids.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)SpringContext.getSession(), (String)"10000", (String)"\u5355\u636eID\u4e3a\u7a7a\uff01");
        }
        for (Long id : ids) {
            this.audit(id);
        }
        return ServiceResponse.buildSuccess((Object)"\u5ba1\u6838\u6210\u529f");
    }

    @Override
    public ServiceResponse audit(Long id) throws Exception {
        BaseSheetHeadModel bean = (BaseSheetHeadModel)this.viewWithBean(id);
        if (StringUtils.isEmpty((Object)bean) || StringUtils.isEmpty((Object)bean.getSheetid())) {
            throw new ServiceRuntimeException("\u5355\u636esheetid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.validateBillAudit(bean);
        this.onBeforeAudit(bean);
        Set<String> keys = this.onAudit(bean);
        if (keys == null) {
            keys = new HashSet<String>();
        }
        bean.setFlag(Integer.valueOf(100));
        bean.setChecker(SpringContext.getSession().getUser_name());
        bean.setCheckdate(new Date());
        keys.add("flag");
        keys.add("checker");
        keys.add("checkdate");
        this.onUpdateBean(bean, keys);
        this.onAfterAudit(bean);
        return ServiceResponse.buildSuccess((Object)String.format("\u5355\u636e\u7f16\u53f7%1$s\u5ba1\u6838\u6210\u529f", bean.getSheetid()));
    }

    @Override
    public ServiceResponse invalid(List<Long> ids) throws Exception {
        if (ids == null || ids.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)SpringContext.getSession(), (String)"10000", (String)"\u5355\u636eID\u4e3a\u7a7a\uff01");
        }
        for (Long id : ids) {
            this.invalid(id);
        }
        return ServiceResponse.buildSuccess((Object)"\u53d6\u6d88\u6210\u529f");
    }

    @Override
    public ServiceResponse invalid(Long id) throws Exception {
        BaseSheetHeadModel bean = (BaseSheetHeadModel)this.viewWithBean(id);
        if (StringUtils.isEmpty((Object)bean) || StringUtils.isEmpty((Object)bean.getSheetid())) {
            throw new ServiceRuntimeException("\u5355\u636esheetid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.validateBillInvalid(bean);
        this.onBeforeInvalid(bean);
        Set<String> keys = this.onInvalid(bean);
        if (keys == null) {
            keys = new HashSet<String>();
        }
        bean.setFlag(Integer.valueOf(99));
        bean.setChecker(SpringContext.getSession().getUser_name());
        bean.setCheckdate(new Date());
        keys.add("flag");
        keys.add("checker");
        keys.add("checkdate");
        this.onUpdateBean(bean, keys);
        this.onAfterInvalid(bean);
        return ServiceResponse.buildSuccess((Object)String.format("\u5355\u636e\u7f16\u53f7%1$s\u53d6\u6d88\u6210\u529f", bean.getSheetid()));
    }

    public void validateBillAudit(BaseSheetHeadModel bean) {
        if (bean.getFlag() == 99) {
            throw new ServiceRuntimeException(String.format("\u5355\u636e[%1$s]\u5df2\u4f5c\u5e9f\uff01", bean.getSheetid()));
        }
        if (bean.getFlag() == 100) {
            throw new ServiceRuntimeException(String.format("\u5355\u636e[%1$s]\u5df2\u5ba1\u6838\uff01", bean.getSheetid()));
        }
    }

    public void validateBillInvalid(BaseSheetHeadModel bean) {
        if (bean.getFlag() == 99) {
            throw new ServiceRuntimeException(String.format("\u5355\u636e[%1$s]\u5df2\u53d6\u6d88\uff01", bean.getSheetid()));
        }
    }

    public void onBeforeInvalid(BaseSheetHeadModel bean) {
    }

    public Set<String> onInvalid(BaseSheetHeadModel bean) {
        return null;
    }

    public void onAfterInvalid(BaseSheetHeadModel bean) {
    }
}

