/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.product.component.AuthorityBaseServiceImpl;
import com.product.component.ILogFileRecoderServiceImpl;
import com.product.controller.ProductReflect;
import com.product.language.MessageSourceHelper;
import com.product.mybatisplus.config.MybatisPlusConfig;
import com.product.storage.slice.filter.SliceBase;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.UniqueID;
import com.shiji.core.component.JdbcTemplateImpl;
import com.shiji.core.service.ILogRecoderService;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableAutoConfiguration(exclude={MongoAutoConfiguration.class, MongoDataAutoConfiguration.class})
@AutoConfigureAfter(value={MybatisPlusConfig.class})
public class BaseConfiger {
    private static final Logger log = LoggerFactory.getLogger(BaseConfiger.class);
    @Value(value="${spring.datasource.jdbcUrl}")
    protected String jdbcUrl;
    @Value(value="${spring.datasource.driver-class-name}")
    protected String jdbcDriver;
    @Value(value="${spring.datasource.username}")
    protected String jdbcUser;
    @Value(value="${spring.datasource.password}")
    protected String jdbcPass;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean(name={"UniqueID"})
    UniqueID onUniqueIDTemplate() throws Exception {
        UniqueID instance = new UniqueID();
        instance.setHostId("120");
        return instance;
    }

    @Bean(name={"datasource"})
    @ConfigurationProperties(prefix="spring.datasource")
    @Primary
    public DataSource onHikariDataSource() {
        log.info("---> BaseConfiger creating DataSource: jdbcDriver:{} jdbcUrl:{} jdbcUser:{} jdbcPass:{} ", new Object[]{this.jdbcDriver + "", this.jdbcUrl + "", this.jdbcUser + "", this.jdbcPass + ""});
        DataSource response = DataSourceBuilder.create().type(HikariDataSource.class).build();
        return response;
    }

    @Bean(name={"JdbcTemplate"})
    @DependsOn(value={"datasource"})
    @Primary
    public JdbcTemplate onJdbcTemplate(@Qualifier(value="datasource") DataSource dataSource) {
        log.info("---> BaseConfiger 1. creating JdbcTemplate");
        JdbcTemplateImpl response = new JdbcTemplateImpl(dataSource);
        return response;
    }

    @Autowired
    @ConditionalOnProperty(name={"mybatis-plus.enable"}, havingValue="false", matchIfMissing=true)
    @Bean(name={"sqlSessionFactory"})
    @DependsOn(value={"datasource"})
    @Primary
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="datasource") DataSource datasource) {
        log.info("---> BaseConfiger 2. creating SqlSessionFactoryBean");
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        return service;
    }

    @Bean(name={"sqlSessionTemplate"})
    @DependsOn(value={"sqlSessionFactory"})
    @Primary
    public SqlSessionTemplate sessionTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        log.info("---> BaseConfiger 3. creating SqlSessionTemplate");
        SqlSessionTemplate response = new SqlSessionTemplate(sqlSessionFactory);
        return response;
    }

    @ConditionalOnProperty(name={"mybatis-plus.enable"}, havingValue="true", matchIfMissing=false)
    @Bean(name={"globalConfiguration"})
    @ConfigurationProperties(prefix="mybatis-plus.configuration")
    public MybatisConfiguration globalConfiguration() {
        return new MybatisConfiguration();
    }

    @Autowired
    @ConditionalOnProperty(name={"mybatis-plus.enable"}, havingValue="true", matchIfMissing=false)
    @Bean(name={"sqlSessionFactory"})
    @DependsOn(value={"datasource"})
    @Primary
    public MybatisSqlSessionFactoryBean onMybatisSqlSessionFactoryBean(@Qualifier(value="datasource") DataSource datasource, MybatisConfiguration mybatisPlusConfiguration, MybatisPlusInterceptor paginationInterceptor) {
        log.info("---> BaseConfiger creating SqlSessionFactoryBean");
        MybatisSqlSessionFactoryBean service = new MybatisSqlSessionFactoryBean();
        mybatisPlusConfiguration.setLogImpl(StdOutImpl.class);
        service.setConfiguration(mybatisPlusConfiguration);
        service.setPlugins(new Interceptor[]{paginationInterceptor});
        service.setDataSource(datasource);
        return service;
    }

    @Autowired
    @Bean(name={"StorageOperation"})
    @Qualifier(value="StorageOperation")
    @DependsOn(value={"sqlSessionFactory"})
    @Primary
    public FMybatisTemplate onFMybatisTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        log.info("---> BaseConfiger 4. creating FMybatisTemplate");
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Autowired
    @Bean(name={"primaryTransactionManager"})
    @DependsOn(value={"datasource"})
    @Primary
    public PlatformTransactionManager transactionManager(@Qualifier(value="datasource") DataSource datasource) {
        return new DataSourceTransactionManager(datasource);
    }

    @Bean(name={"ServiceMethodReflect"})
    public ProductReflect onProductReflect() {
        return new ProductReflect();
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource onResourceBundleMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"message"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean(name={"messageSourceHelper"})
    public MessageSourceHelper onMessageSourceHelper() {
        MessageSourceHelper messageSourceHelper = new MessageSourceHelper();
        messageSourceHelper.setMessageSource(this.onResourceBundleMessageSource());
        return messageSourceHelper;
    }

    @Bean(name={"authorityBaseServiceImpl"})
    public AuthorityBaseServiceImpl onAuthorityBaseServiceImpl() {
        AuthorityBaseServiceImpl authorityBaseServiceImpl = new AuthorityBaseServiceImpl();
        return authorityBaseServiceImpl;
    }

    @Bean(initMethod="init")
    @ConditionalOnMissingBean
    public SliceBase initSliceBase() {
        return new SliceBase();
    }

    @Bean
    @ConditionalOnMissingBean
    public ILogRecoderService initLogRecoder() {
        return new ILogFileRecoderServiceImpl();
    }
}

