/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.dynamicds;

import com.product.config.BaseConfiger;
import com.product.config.dynamicds.DbConfigModel;
import com.product.config.dynamicds.DbConfigServiceImpl;
import com.product.datasource.DynamicDataSourceContextHolder;
import com.product.datasource.DynamicRoutingDataSource;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.SpringContext;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(prefix="dynamicsds", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={BaseConfiger.class})
public class DynamicDatasourceConfig
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DynamicDatasourceConfig.class);
    @Autowired
    FMybatisTemplate mybatisTemplate;
    @Autowired
    @Qualifier(value="datasource")
    private DataSource dataSource;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean(value={"dynamicDataSource"})
    public DataSource onDynamicDataSource() {
        log.info("---> creating dynamicDataSource");
        DynamicRoutingDataSource dynamicRoutingDataSource = new DynamicRoutingDataSource();
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(2);
        dataSourceMap.put("defaultDs", this.dataSource);
        DbConfigServiceImpl dbConfigSrv = new DbConfigServiceImpl(this.mybatisTemplate);
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        List<DbConfigModel> dblist = this.mybatisTemplate.select(query, DbConfigModel.class, dbConfigSrv.getCollectionName());
        for (DbConfigModel db : dblist) {
            db.setDriverClassName("com.mysql.jdbc.Driver");
            db.setJdbcUrl("jdbc:mysql://" + db.getIp() + ":" + db.getPort() + "/" + db.getDb() + "?useSSL=false&useUnicode=true&serverTimezone=GMT%2B8&characterEncoding=utf8&autoReconnect=true&allowMultiQueries=true&useAffectedRows=true");
            log.info("---> DynamicDatasourceConfig creating DataSource:{}: jdbcDriver:{} jdbcUrl:{} jdbcUser:{} jdbcPass:{} ", new Object[]{db.getCode() + "", db.getDriverClassName() + "", db.getJdbcUrl() + "", db.getUsername() + "", db.getPassword() + ""});
            DataSource datasource = DataSourceBuilder.create().type(HikariDataSource.class).driverClassName(db.getDriverClassName()).url(db.getJdbcUrl()).username(db.getUsername()).password(db.getPassword()).build();
            dataSourceMap.put(db.getCode(), datasource);
        }
        String defaultdbkey = (String)dataSourceMap.keySet().iterator().next();
        dynamicRoutingDataSource.setDefaultTargetDataSource(dataSourceMap.get(defaultdbkey));
        dynamicRoutingDataSource.setTargetDataSources(dataSourceMap);
        DynamicDataSourceContextHolder.dataSourceKeys.addAll(dataSourceMap.keySet());
        DynamicDataSourceContextHolder.setRouterKey(defaultdbkey);
        return dynamicRoutingDataSource;
    }

    @Bean(name={"moreSqlSessionFactory"})
    @DependsOn(value={"dynamicDataSource"})
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="dynamicDataSource") DataSource datasource) {
        log.info("---> creating more sqlSessionFactoryBean");
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        return service;
    }

    @Bean(name={"moreSessionTemplate"})
    @DependsOn(value={"moreSqlSessionFactory"})
    public SqlSessionTemplate onSessionTemplate(@Qualifier(value="moreSqlSessionFactory") SqlSessionFactory moreSessionFactory) {
        log.info("---> creating moreSessionTemplate");
        SqlSessionTemplate response = new SqlSessionTemplate(moreSessionFactory);
        return response;
    }

    @Bean(name={"moreStorageOperation"})
    @Qualifier(value="moreStorageOperation")
    @DependsOn(value={"moreSqlSessionFactory"})
    public FMybatisTemplate onMoreFMybatisTemplate(@Qualifier(value="moreSqlSessionFactory") SqlSessionFactory moreSessionFactory) {
        log.info("---> creating moreFMybatisTemplate");
        return new FMybatisTemplate(moreSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"dynamicTemplate"})
    @DependsOn(value={"dynamicDataSource"})
    public JdbcTemplate dynamicTemplate(@Qualifier(value="dynamicDataSource") DataSource datasource) {
        return new JdbcTemplate(datasource);
    }

    @Bean(name={"dynamicTransactionManager"})
    @DependsOn(value={"dynamicDataSource"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="dynamicDataSource") DataSource datasource) {
        log.info("---> creating moreTransactionManager");
        return new DataSourceTransactionManager(datasource);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.setInstance((ConfigurableApplicationContext)((ConfigurableApplicationContext)applicationContext));
    }
}

