/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.product.model.PropertyValidateEntity;
import com.product.model.ValidateEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.springframework.util.StringUtils;

public class ValidateUtils {
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> ValidateEntity validate(T t, Class<?> ... groups) throws Exception {
        ValidateEntity validate = new ValidateEntity();
        try {
            Set violationSet = validator.validate(t, (Class[])groups);
            if (!StringUtils.isEmpty((Object)violationSet) && violationSet.size() > 0) {
                validate.setCode(false);
                List<PropertyValidateEntity> msg = ValidateUtils.getValidateMsg(violationSet);
                validate.setPropmsg(msg);
            } else {
                validate.setCode(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return validate;
    }

    public static <T> ValidateEntity validatePropertys(T t, String ... fileds) {
        ValidateEntity validate = new ValidateEntity();
        ArrayList<PropertyValidateEntity> msg = new ArrayList<PropertyValidateEntity>();
        for (String field : fileds) {
            Set violationSet = validator.validateProperty(t, field, new Class[0]);
            List<PropertyValidateEntity> propmsg = ValidateUtils.getValidateMsg(violationSet);
            msg.addAll(propmsg);
        }
        if (!StringUtils.isEmpty(msg) && msg.size() > 0) {
            validate.setCode(false);
            validate.setPropmsg(msg);
        } else {
            validate.setCode(true);
        }
        return validate;
    }

    private static <T> List<PropertyValidateEntity> getValidateMsg(Set<ConstraintViolation<T>> violationSet) {
        ArrayList<PropertyValidateEntity> msg = new ArrayList<PropertyValidateEntity>();
        for (ConstraintViolation<T> constraintViolation : violationSet) {
            PropertyValidateEntity entity;
            String prop = constraintViolation.getPropertyPath().toString();
            String validatemsg = constraintViolation.getMessage();
            System.out.println("propertypath: " + constraintViolation.getPropertyPath() + "  message: " + constraintViolation.getMessage());
            if (msg.stream().anyMatch(e -> e.getProperty().equalsIgnoreCase(prop))) {
                entity = (PropertyValidateEntity)msg.stream().filter(e -> e.getProperty().equalsIgnoreCase(prop)).collect(Collectors.toList()).get(0);
                entity.setMsg(String.format("%1$s,%2$s", entity.getMsg(), validatemsg));
                continue;
            }
            entity = new PropertyValidateEntity();
            entity.setProperty(prop);
            entity.setMsg(validatemsg);
            msg.add(entity);
        }
        return msg;
    }
}

