/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.efuture.redis.BaseJedisConnectionFactory;
import com.efuture.redis.component.RedisClient;
import java.time.Duration;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class SpringSessionRedisConfiguration {
    @Resource
    ConfigurableEnvironment environment;

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public RedisStandaloneConfiguration redisStandaloneConfig() {
        String host = this.environment.getProperty("spring.redis.host");
        String port = this.environment.getProperty("spring.redis.port");
        String password = this.environment.getProperty("spring.redis.password");
        String index = this.environment.getProperty("spring.redis.database");
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(host.trim());
        redisStandaloneConfiguration.setPort(Integer.parseInt(port.trim()));
        redisStandaloneConfiguration.setDatabase(!StringUtils.isEmpty((Object)index) ? Integer.valueOf(index) : 0);
        redisStandaloneConfiguration.setPassword(!StringUtils.isEmpty((Object)password) ? password.trim() : "");
        return redisStandaloneConfiguration;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public LettucePoolingClientConfiguration lettucePoolingClientConfiguration() {
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
        builder.poolConfig((GenericObjectPoolConfig)this.poolConfiguration());
        int timeout = (Integer)this.environment.getProperty("spring.redis.timeout", Integer.class, (Object)10000);
        builder.commandTimeout(Duration.ofMillis(timeout));
        return builder.build();
    }

    @Bean(value={"lettuceConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    @Primary
    public LettuceConnectionFactory redisConnectionFactory() {
        LettuceConnectionFactory connect = new LettuceConnectionFactory(this.redisStandaloneConfig(), (LettuceClientConfiguration)this.lettucePoolingClientConfiguration());
        connect.setConvertPipelineAndTxResults(false);
        return connect;
    }

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    public JedisConnectionFactory jedisConnectionFactory() {
        BaseJedisConnectionFactory.StandaloneJedisClientConfiguration clientConfig = (BaseJedisConnectionFactory.StandaloneJedisClientConfiguration)BaseJedisConnectionFactory.StandaloneJedisClientConfiguration.create((GenericObjectPoolConfig)this.poolConfiguration());
        int timeout = (Integer)this.environment.getProperty("spring.redis.timeout", Integer.class, (Object)10000);
        clientConfig.setReadTimeout(Duration.ofMillis(timeout));
        BaseJedisConnectionFactory jedisConnectionFactory = new BaseJedisConnectionFactory(this.redisStandaloneConfig(), (JedisClientConfiguration)clientConfig);
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        return jedisConnectionFactory;
    }

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    public JedisConnectionFactory sentineljedisConnectionFactory() {
        BaseJedisConnectionFactory jedisConnectionFactory = new BaseJedisConnectionFactory(this.sentinelConfiguration(), this.poolConfiguration());
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        return jedisConnectionFactory;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    public RedisSentinelConfiguration sentinelConfiguration() {
        Properties properties = new Properties();
        properties.put("spring.redis.sentinel.master", this.environment.getProperty("spring.redis.sentinel.master"));
        properties.put("spring.redis.sentinel.nodes", this.environment.getProperty("spring.redis.sentinel.nodes"));
        PropertiesPropertySource redisPropertySource = new PropertiesPropertySource("redis", properties);
        RedisSentinelConfiguration redisSentinelConfiguration = new RedisSentinelConfiguration((PropertySource)redisPropertySource);
        String password = this.environment.getProperty("spring.redis.password");
        String index = this.environment.getProperty("spring.redis.database");
        int dbIndex = 0;
        if (!StringUtils.isEmpty((Object)index)) {
            dbIndex = Integer.valueOf(index);
        }
        redisSentinelConfiguration.setDatabase(dbIndex);
        redisSentinelConfiguration.setPassword(password);
        return redisSentinelConfiguration;
    }

    @Bean(value={"lettuceConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    public LettuceConnectionFactory lettuceConnectionFactory() {
        LettuceConnectionFactory connect = new LettuceConnectionFactory(this.sentinelConfiguration(), (LettuceClientConfiguration)this.lettucePoolingClientConfiguration());
        connect.setConvertPipelineAndTxResults(false);
        return connect;
    }

    @Bean(value={"jedisConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public JedisConnectionFactory clusterJedisConnectionFactory() {
        BaseJedisConnectionFactory jedisConnectionFactory = new BaseJedisConnectionFactory(this.clusterConfiguration(), this.poolConfiguration());
        jedisConnectionFactory.setConvertPipelineAndTxResults(false);
        return jedisConnectionFactory;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public RedisClusterConfiguration clusterConfiguration() {
        Properties properties = new Properties();
        properties.put("spring.redis.cluster.nodes", this.environment.getProperty("spring.redis.cluster.nodes"));
        String maxRedirects = this.environment.getProperty("spring.redis.cluster.max-redirects");
        properties.put("spring.redis.cluster.max-redirects", (Object)Integer.parseInt(maxRedirects));
        PropertiesPropertySource redisPropertySource = new PropertiesPropertySource("redis", properties);
        RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration((PropertySource)redisPropertySource);
        String password = this.environment.getProperty("spring.redis.password");
        redisClusterConfiguration.setPassword(password);
        return redisClusterConfiguration;
    }

    @Bean(value={"lettuceConnectionFactory"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    public LettuceConnectionFactory clusterConnectionFactory() {
        LettuceConnectionFactory connect = new LettuceConnectionFactory(this.clusterConfiguration(), (LettuceClientConfiguration)this.lettucePoolingClientConfiguration());
        connect.setConvertPipelineAndTxResults(false);
        return connect;
    }

    @Bean
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, matchIfMissing=false)
    public JedisPoolConfig poolConfiguration() {
        JedisPoolConfig config = new JedisPoolConfig();
        String maxActive = this.environment.getProperty("spring.redis.jedis.pool.max-active");
        String maxWait = this.environment.getProperty("spring.redis.jedis.pool.max-wait");
        String maxIdle = this.environment.getProperty("spring.redis.jedis.pool.max-idle");
        String minIdle = this.environment.getProperty("spring.redis.jedis.pool.min-idle");
        boolean testOnCreate = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-create", Boolean.class, (Object)false);
        boolean testOnBorrow = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-borrow", Boolean.class, (Object)false);
        boolean testOnReturn = (Boolean)this.environment.getProperty("spring.redis.pool.test-on-return", Boolean.class, (Object)false);
        boolean testWhileIdle = (Boolean)this.environment.getProperty("spring.redis.pool.test-while-idle", Boolean.class, (Object)false);
        config.setMaxTotal(Integer.parseInt(maxActive));
        config.setMaxWaitMillis((long)Integer.parseInt(maxWait));
        config.setMaxIdle(Integer.parseInt(maxIdle));
        config.setMinIdle(Integer.parseInt(minIdle));
        config.setTestOnBorrow(testOnBorrow);
        config.setTestOnCreate(testOnCreate);
        config.setTestOnReturn(testOnReturn);
        config.setTestWhileIdle(testWhileIdle);
        return config;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    RedisTemplate<Object, Object> sentinelRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.lettuceConnectionFactory());
        redisTemplate.setEnableTransactionSupport(true);
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="sentinel")
    StringRedisTemplate sentinelStringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.lettuceConnectionFactory());
        stringRedisTemplate.setEnableTransactionSupport(true);
        return stringRedisTemplate;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    RedisTemplate<Object, Object> redisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
        redisTemplate.setEnableTransactionSupport(true);
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="single")
    StringRedisTemplate stringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory());
        stringRedisTemplate.setEnableTransactionSupport(true);
        return stringRedisTemplate;
    }

    @Bean(value={"redisTemplate"})
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    RedisTemplate<Object, Object> clusterRedisTemplate() {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)this.clusterConnectionFactory());
        return redisTemplate;
    }

    @Bean(value={"stringRedisTemplate"})
    @Qualifier(value="stringRedisTemplate")
    @ConditionalOnProperty(prefix="redis", name={"connection.mode"}, havingValue="cluster")
    StringRedisTemplate clusterStringRedisTemplate() {
        StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
        stringRedisTemplate.setConnectionFactory((RedisConnectionFactory)this.clusterConnectionFactory());
        return stringRedisTemplate;
    }

    @Bean
    @Autowired
    RedisClient redisClient(@Qualifier(value="stringRedisTemplate") StringRedisTemplate stringRedisTemplate) {
        return new RedisClient(stringRedisTemplate);
    }
}

