/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.product.component.BeanField;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.template.FMybatisTemplate;
import com.product.util.UniqueID;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.StringUtils;

public class BatchBaseService {
    public Set<BeanField> transform(List<Field> fields) {
        HashSet<BeanField> beanFields = new HashSet<BeanField>();
        for (Field fld : fields) {
            if (fld == null) continue;
            BeanField bf = new BeanField();
            bf.setColName(fld.getName());
            bf.setField(fld);
            bf.setColType(fld.getType().getName().toLowerCase());
            beanFields.add(bf);
        }
        return beanFields;
    }

    public List<Field> filter(List<Field> lists, Set<String> fields) {
        ArrayList<Field> rtn = new ArrayList<Field>();
        for (String field : fields) {
            Field tmp = lists.stream().filter(e -> field.equalsIgnoreCase(e.getName())).findFirst().orElse(null);
            if (StringUtils.isEmpty((Object)tmp)) continue;
            rtn.add(tmp);
        }
        return rtn;
    }

    public Object getColValue(JSONObject json, String colname, String keyFieldName) {
        Boolean isPrimaryKey = false;
        if (colname.equalsIgnoreCase(keyFieldName)) {
            isPrimaryKey = true;
        }
        if (isPrimaryKey.booleanValue()) {
            if (json.containsKey((Object)colname) && !StringUtils.isEmpty((Object)json.get((Object)colname))) {
                return json.get((Object)colname);
            }
            return UniqueID.getUniqueID();
        }
        return json.get((Object)colname);
    }

    public Object getColData(FMybatisTemplate storage, Object o, String type2) throws ParseException {
        SimpleDateFormat timefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (type2.contains("long")) {
            o = StringUtils.isEmpty((Object)o) ? 0L : Long.parseLong(o.toString());
        } else if (type2.contains("int")) {
            o = StringUtils.isEmpty((Object)o) ? 0 : Integer.parseInt(o.toString());
        } else if (type2.contains("float")) {
            o = Float.valueOf(StringUtils.isEmpty((Object)o) ? 0.0f : Float.parseFloat(o.toString()));
        } else if (type2.contains("double")) {
            o = StringUtils.isEmpty((Object)o) ? 0.0 : Double.parseDouble(o.toString());
        } else if (type2.contains("short")) {
            o = StringUtils.isEmpty((Object)o) ? (short)0 : Short.parseShort(o.toString());
        } else if (type2.contains("boolean")) {
            if (!(o instanceof Boolean)) {
                o = StringUtils.isEmpty((Object)o) ? Boolean.valueOf(false) : Boolean.valueOf("true".equalsIgnoreCase(o.toString()) || "Y".equalsIgnoreCase(o.toString()));
            }
        } else if (type2.contains("date")) {
            if (StringUtils.isEmpty((Object)o)) {
                o = null;
            } else {
                String s = timefmt.format(o);
                o = storage.getDBType() == QueryExtractor.DBTYPE.ORACLE ? "to_date('" + s + "', 'yyyy-mm-dd hh24:mi:ss')" : "'" + s + "'";
            }
        } else if (type2.contains("string")) {
            o = o == null ? String.valueOf(o) : "'" + String.valueOf(o).replace("'", "''").replace("\"", "") + "'";
        }
        return o;
    }
}

