/*
 * Decompiled with CFR 0.152.
 */
package com.product.config;

import com.product.rest.interceptor.CustomClientHttpRequestInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(name={"service.deploy.mode"}, havingValue="tomcat")
@AutoConfigureAfter(value={RestTemplate.class})
public class RestConfig {
    private static final Logger log = LoggerFactory.getLogger(RestConfig.class);
    @Autowired
    ConfigurableEnvironment environment;
    @Autowired
    RestTemplate restTemplate;

    @Bean
    public void addRestInterceptor() {
        List interceptors = this.restTemplate.getInterceptors();
        interceptors.add(new CustomClientHttpRequestInterceptor(this.environment));
        log.info(" ----------   >>>>>>>>>>>>>> \u521d\u59cb\u5316resttemplate\u62e6\u622a\u5668\u6210\u529f");
    }
}

