/*
 * Decompiled with CFR 0.152.
 */
package com.product.config.redis;

import com.alibaba.fastjson.JSON;
import com.product.annotation.redis.CacheKeyGenerator;
import com.product.annotation.redis.CacheLock;
import com.product.config.redis.RedisLockHelper;
import com.product.model.ServiceResponse;
import java.lang.reflect.Method;
import java.util.UUID;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class LockMethodInterceptor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LockMethodInterceptor.class);
    private final RedisLockHelper redisLockHelper;
    private final CacheKeyGenerator cacheKeyGenerator;

    @Around(value="@annotation(com.product.annotation.redis.CacheLock)")
    public Object interceptor(ProceedingJoinPoint pjp) {
        LOGGER.info("---->LockMethodInterceptor.interceptor.1");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        CacheLock lock = method.getAnnotation(CacheLock.class);
        if (StringUtils.isEmpty((Object)lock.prefix())) {
            LOGGER.info("---->LockMethodInterceptor.interceptor.2");
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, (String)"10000", (String)"\u5206\u5e03\u5f0f\u9501\u5173\u952e\u5b57\u4e0d\u80fd\u672a\u7a7a"));
        }
        String lockKey = this.cacheKeyGenerator.getLockKey(pjp);
        String value = UUID.randomUUID().toString();
        try {
            LOGGER.info("---->LockMethodInterceptor.interceptor.3");
            boolean success = this.redisLockHelper.lock(lockKey, value, lock.expire(), lock.timeUnit());
            if (!success) {
                LOGGER.info("---->LockMethodInterceptor.interceptor.4");
                throw new RuntimeException("\u5206\u5e03\u5f0f\u9501\u91cd\u590d\u63d0\u4ea4\u9650\u5236");
            }
            LOGGER.info("---->LockMethodInterceptor.interceptor.5");
            try {
                Object object = pjp.proceed();
                return object;
            }
            catch (Throwable throwable) {
                LOGGER.info("---->LockMethodInterceptor.interceptor.6");
                throw new RuntimeException("\u5206\u5e03\u5f0f\u9501\u7cfb\u7edf\u5f02\u5e38");
            }
        }
        finally {
            LOGGER.info("---->LockMethodInterceptor.interceptor.7");
            this.redisLockHelper.unlock(lockKey, value);
        }
    }

    public LockMethodInterceptor(RedisLockHelper redisLockHelper, CacheKeyGenerator cacheKeyGenerator) {
        this.redisLockHelper = redisLockHelper;
        this.cacheKeyGenerator = cacheKeyGenerator;
    }
}

