/*
 * Decompiled with CFR 0.152.
 */
package com.product.query;

import com.alibaba.fastjson.parser.ParserConfig;
import com.github.pagehelper.Page;
import com.google.common.base.Splitter;
import com.product.query.QueryUsedFunction;
import com.product.storage.strategy.SqlSessionTemplate;
import com.product.util.BeanUtils;
import com.product.util.TypeUtils;
import com.shiji.core.annotation.KeepTransient;
import com.shiji.core.annotation.ModelProperty;
import com.shiji.core.enums.QueryUsed;
import com.shiji.core.sensor.query.builder.EntryImpl;
import com.shiji.core.sensor.query.builder.TableQueryModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTableQueryModel
extends TableQueryModel {
    private static final Logger log = LoggerFactory.getLogger(MyTableQueryModel.class);
    private final Pattern pattern = Pattern.compile(".*\\s(?<operator>like|in|not\\s+in|between)\\s+\\[value\\]", 10);
    private final String SQL_SELECT = "mybatis.sql.select";
    private final String TRANSIENTS = "fields,order_direction,page_no,page_size";
    private Map<QueryUsed, QueryUsedFunction<String, Object, Boolean, Boolean, String>> normalMap;
    private Boolean prefixFuzzy;
    private Boolean suffixFuzzy;
    private Set<String> transientSet;

    public static String toUseLikeValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> {
            Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, null, (String)",", (Boolean)prefix, (Boolean)suffix);
            return String.format("%1$s like %2$s", fieldName, responseEntry.getValue());
        };
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseInValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> {
            Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)",", (Boolean)false, (Boolean)false);
            return String.format("%1$s in (%2$s)", fieldName, responseEntry.getValue());
        };
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseBeetweenValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> {
            Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)" AND ", (Boolean)false, (Boolean)false);
            if (((Boolean)responseEntry.getKey()).booleanValue()) {
                return String.format("%1$s between %2$s", fieldName, responseEntry.getValue());
            }
            return String.format("%1$s = %2$s", fieldName, responseEntry.getValue());
        };
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseIsNullValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> String.format("%1$s is null", fieldName);
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseNotNullValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> String.format("%1$s is not null", fieldName);
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseGreaterThanValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> {
            Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)"','", (Boolean)false, (Boolean)false);
            return String.format("%1$s > %2$s", fieldName, responseEntry.getValue());
        };
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseGreaterThanEqualValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> {
            Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)"','", (Boolean)false, (Boolean)false);
            return String.format("%1$s >= %2$s", fieldName, responseEntry.getValue());
        };
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseLessThanValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> {
            Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)"','", (Boolean)false, (Boolean)false);
            return String.format("%1$s < %2$s", fieldName, responseEntry.getValue());
        };
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public static String toUseThanEqualValue(String fieldName, Object value, Boolean prefixFuzzy, Boolean suffixFuzzy) {
        QueryUsedFunction<String, Object, Boolean, Boolean, String> function = (colName, colValue, prefix, suffix) -> {
            Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)"','", (Boolean)false, (Boolean)false);
            return String.format("%1$s <= %2$s", fieldName, responseEntry.getValue());
        };
        return function.apply(fieldName, value, prefixFuzzy, suffixFuzzy);
    }

    public MyTableQueryModel() {
        this(false, true);
    }

    public MyTableQueryModel(Boolean prefixFuzzy, Boolean suffixFuzzy) {
        this.prefixFuzzy = prefixFuzzy;
        this.suffixFuzzy = suffixFuzzy;
        this.normalMap = new HashMap<QueryUsed, QueryUsedFunction<String, Object, Boolean, Boolean, String>>();
        this.normalMap.put(QueryUsed.UseLike, MyTableQueryModel::toUseLikeValue);
        this.normalMap.put(QueryUsed.UseIn, MyTableQueryModel::toUseInValue);
        this.normalMap.put(QueryUsed.UseBetween, MyTableQueryModel::toUseBeetweenValue);
        this.normalMap.put(QueryUsed.UseIsNull, MyTableQueryModel::toUseIsNullValue);
        this.normalMap.put(QueryUsed.UseNotNull, MyTableQueryModel::toUseNotNullValue);
        this.normalMap.put(QueryUsed.UseGreaterThan, MyTableQueryModel::toUseGreaterThanValue);
        this.normalMap.put(QueryUsed.UseGreaterThanEqual, MyTableQueryModel::toUseGreaterThanEqualValue);
        this.normalMap.put(QueryUsed.UseLessThan, MyTableQueryModel::toUseLessThanValue);
        this.normalMap.put(QueryUsed.UseLessThanEqual, MyTableQueryModel::toUseThanEqualValue);
        this.transientSet = new HashSet<String>();
        Iterable iterable = Splitter.on((String)",").split((CharSequence)this.TRANSIENTS);
        for (String item : iterable) {
            this.transientSet.add(item);
        }
    }

    protected boolean isTransient(Object model, Field field, String fieldName) {
        boolean isTransient = super.isTransient(model, field, fieldName);
        if (isTransient) {
            return true;
        }
        if (this.transientSet.contains(fieldName)) {
            return true;
        }
        return field.isAnnotationPresent(KeepTransient.class);
    }

    protected String onParseExpression(String fieldExpr) {
        ArrayList<String> tokenList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(fieldExpr);
        while (tokenizer.hasMoreElements()) {
            tokenList.add(tokenizer.nextToken());
        }
        return "";
    }

    protected String onWhere(Object target, Field field, String fieldName, String fieldExpr, Object value) {
        if (StringUtils.isEmpty((String)fieldExpr)) {
            ModelProperty modelProperty;
            if (field.isAnnotationPresent(ModelProperty.class) && this.normalMap.containsKey((modelProperty = field.getAnnotation(ModelProperty.class)).queryType())) {
                QueryUsedFunction<String, Object, Boolean, Boolean, String> function = this.normalMap.get(modelProperty.queryType());
                if (!StringUtils.isEmpty((String)modelProperty.paramsField())) {
                    Field paramsField = this.getField(target.getClass(), modelProperty.paramsField());
                    try {
                        paramsField.setAccessible(true);
                        value = paramsField.get(target);
                    }
                    catch (Exception e) {
                        String errorMsg = String.format("\u6a21\u578b %1$s \u914d\u7f6e\u6807\u6ce8\u6307\u5b9a\u53c2\u6570\u5b57\u6bb5 %2$s \u4e0d\u6b63\u786e", target.getClass().getName(), modelProperty.paramsField());
                        log.error(errorMsg, (Throwable)e);
                        throw new UnsupportedOperationException(errorMsg);
                    }
                    return function.apply(fieldName, value, this.prefixFuzzy, this.suffixFuzzy);
                }
                return function.apply(fieldName, value, this.prefixFuzzy, this.suffixFuzzy);
            }
        } else {
            Matcher matcher = this.pattern.matcher(fieldExpr);
            if (matcher.find()) {
                String operator = matcher.group("operator");
                if ("like".equalsIgnoreCase(operator)) {
                    Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, null, (String)",", (Boolean)this.prefixFuzzy, (Boolean)this.suffixFuzzy);
                    return fieldExpr.replaceAll("\\[value\\]", (String)responseEntry.getValue());
                }
                if ("in".equalsIgnoreCase(operator)) {
                    Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)",", (Boolean)false, (Boolean)false);
                    return fieldExpr.replaceAll("\\[value\\]", String.format("(%1$s)", responseEntry.getValue()));
                }
                if ("between".equalsIgnoreCase(operator)) {
                    Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)" AND ", (Boolean)false, (Boolean)false);
                    if (((Boolean)responseEntry.getKey()).booleanValue()) {
                        return fieldExpr.replaceAll("\\[value\\]", (String)responseEntry.getValue());
                    }
                    return fieldExpr.replaceAll("\\[value\\]", String.format(" %1$s AND %1$s", responseEntry.getValue()));
                }
                if ("not#in".equalsIgnoreCase(operator.replaceAll("\\s+", "#"))) {
                    Map.Entry responseEntry = TableQueryModel.onValueConvert((Object)value, (String)",", (String)",", (Boolean)false, (Boolean)false);
                    return fieldExpr.replaceAll("\\[value\\]", String.format("(%1$s)", responseEntry.getValue()));
                }
            }
        }
        return super.onWhere(target, field, fieldName, fieldExpr, value);
    }

    private String convertChartsetSQL(String sql, String chartset) {
        if (StringUtils.isEmpty((String)chartset)) {
            return sql;
        }
        try {
            String s = new String(sql.getBytes("GBK"), chartset);
            return s;
        }
        catch (Exception ex) {
            return sql;
        }
    }

    private <T> T toJavaObject(Object obj, Class<T> entityClass) {
        return (T)TypeUtils.cast((Object)obj, entityClass, (ParserConfig)ParserConfig.getGlobalInstance());
    }

    public <T> List<T> toJavaObjectList(List<?> objlist, Class<T> entityClass) {
        if (objlist instanceof Page) {
            Page page = (Page)objlist;
            Page list = new Page();
            BeanUtils.copyProperties((Object)page, (Object)list);
            for (Object obj : objlist) {
                list.add(this.toJavaObject(obj, entityClass));
            }
            return list;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Object obj : objlist) {
            list.add(this.toJavaObject(obj, entityClass));
        }
        return list;
    }

    private <T> List<T> doQueryList(SqlSessionTemplate sqlTemplate, Object model, String fields, String orders, int pageSize, int pageno, Class<T> entityClass, String chartset) {
        this.onParse(model);
        String querySQL = this.onGenerate(fields, orders);
        log.info(String.format("query:%1$s", querySQL));
        List<T> dataList = null;
        if (pageSize > 0) {
            long offset = pageSize * pageno > 0 ? (long)(pageSize * pageno) : 0L;
            int limit = pageSize > 0 ? pageSize : Integer.MAX_VALUE;
            RowBounds rowBounds = new RowBounds(Math.toIntExact(offset), limit);
            dataList = this.toJavaObjectList(sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(querySQL, chartset), rowBounds), entityClass);
        } else {
            dataList = this.toJavaObjectList(sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(querySQL, chartset)), entityClass);
        }
        return dataList;
    }

    public <T> List<T> onQueryList(SqlSessionTemplate sqlTemplate, Object model, String fields, String orders, int pageSize, int pageno, Class<T> entityClass, String chartset) {
        this.onParse(model);
        return this.doQueryList(sqlTemplate, model, fields, orders, pageSize, pageno, entityClass, chartset);
    }

    public <T> List<T> onQueryAll(SqlSessionTemplate sqlTemplate, Object model, String fields, String orders, Class<T> entityClass, String chartset) {
        this.onParse(model);
        return this.doQueryList(sqlTemplate, model, fields, orders, 0, Integer.MAX_VALUE, entityClass, chartset);
    }

    public <T> EntryImpl<Long, List<T>> onQuery(SqlSessionTemplate sqlTemplate, Object model, int pageSize, int pageno, Class<T> entityClass) {
        return this.onQuery(sqlTemplate, model, null, null, pageSize, pageno, entityClass, null);
    }

    public <T> EntryImpl<Long, List<T>> onQuery(SqlSessionTemplate sqlTemplate, Object model, String fields, String orders, int pageSize, int pageno, Class<T> entityClass, String chartset) {
        EntryImpl responseEntry = new EntryImpl();
        responseEntry.setKey((Object)1L);
        this.onParse(model);
        String countSQL = this.onGenerateCount();
        String querySQL = this.onGenerate(fields, orders);
        System.out.println(String.format("count:%1$s\r\nquery:%2$s", countSQL, querySQL));
        Object response = sqlTemplate.selectOne("mybatis.sql.select", this.convertChartsetSQL(countSQL, chartset));
        if (response instanceof Map) {
            Map responseMap = (Map)response;
            responseEntry.setKey((Object)TypeUtils.castToLong(responseMap.get("count")));
        }
        List<T> dataList = null;
        if (pageSize > 0) {
            long offset = pageSize * pageno > 0 ? (long)(pageSize * pageno) : 0L;
            int limit = pageSize > 0 ? pageSize : Integer.MAX_VALUE;
            RowBounds rowBounds = new RowBounds(Math.toIntExact(offset), limit);
            dataList = this.toJavaObjectList(sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(querySQL, chartset), rowBounds), entityClass);
        } else {
            dataList = this.toJavaObjectList(sqlTemplate.selectList("mybatis.sql.select", this.convertChartsetSQL(querySQL, chartset)), entityClass);
        }
        responseEntry.setValue(dataList);
        return responseEntry;
    }
}

