/*
 * Decompiled with CFR 0.152.
 */
package com.product.trace;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.product.trace.LoggerThreadLocal;
import com.product.trace.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Aspect
@Service
@Configuration
@ConditionalOnProperty(name={"aop.trace.enable"}, havingValue="true", matchIfMissing=false)
public class TraceMonitor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TraceMonitor.class);
    ObjectMapper mapper = new ObjectMapper();

    @Pointcut(value="execution(* com.*.*.component.*Impl.*(..))")
    private void executionInService() {
    }

    @Before(value="executionInService()")
    public void pushStackInBean(JoinPoint joinPoint) {
        this.pushStack(joinPoint);
    }

    @AfterReturning(value="executionInService()", returning="returnValue")
    public void popStackInBean(Object returnValue) {
        this.popStack(returnValue);
    }

    private void pushStack(JoinPoint joinPoint) {
        Method m = new Method();
        m.setMethodName(StringUtils.replace((String)joinPoint.getSignature().toString(), (String)"com.shiji.", (String)""));
        String input = this.getInputParametersString(joinPoint.getArgs());
        m.setInput(input);
        m.setTimeInMs(System.currentTimeMillis());
        LoggerThreadLocal.getMethodStack().push(m);
    }

    private String getInputParametersString(Object[] joinPointArgs) {
        String input;
        try {
            input = this.mapper.writeValueAsString((Object)joinPointArgs);
        }
        catch (Exception e) {
            input = "Unable to create input parameters string. Error:" + e.getMessage();
        }
        return input;
    }

    private void popStack(Object output) {
        Method childMethod = LoggerThreadLocal.getMethodStack().pop();
        try {
            childMethod.setOutput(output == null ? "" : this.mapper.writeValueAsString(output));
        }
        catch (JsonProcessingException e) {
            childMethod.setOutput(e.getMessage());
        }
        childMethod.setTimeInMs(System.currentTimeMillis() - childMethod.getTimeInMs());
        if (LoggerThreadLocal.getMethodStack().isEmpty()) {
            LoggerThreadLocal.setMainMethod(childMethod);
        } else {
            Method parentMethod = LoggerThreadLocal.getMethodStack().peek();
            this.addChildMethod(childMethod, parentMethod);
        }
    }

    private void addChildMethod(Method childMethod, Method parentMethod) {
        if (parentMethod != null) {
            if (parentMethod.getMethodList() == null) {
                parentMethod.setMethodList(new ArrayList<Method>());
            }
            parentMethod.getMethodList().add(childMethod);
        }
    }

    public void printTrace() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n<TRACE>\n").append(this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)LoggerThreadLocal.getMainMethod()));
            sb.append("\n</TRACE>");
            LOGGER.info(sb.toString());
        }
        catch (JsonProcessingException e) {
            LOGGER.error(StringUtils.abbreviate((String)ExceptionUtils.getStackTrace((Throwable)e), (int)2000));
        }
    }
}

