/*
 * Decompiled with CFR 0.152.
 */
package com.product.component;

import com.alibaba.fastjson.JSONObject;
import com.product.component.BaseCallback;
import com.product.component.JDBCCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.storage.template.FMybatisTemplate;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class RwSyncJDBCCompomentServiceImpl<T>
extends JDBCCompomentServiceImpl<T> {
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected static final ReentrantReadWriteLock.ReadLock READ_LOCK = lock.readLock();
    protected static final ReentrantReadWriteLock.WriteLock WRITE_LOCK = lock.writeLock();

    public RwSyncJDBCCompomentServiceImpl(FMybatisTemplate mybatisTemplate, String collectionName, String keyfieldName) {
        super(mybatisTemplate, collectionName, keyfieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse onInsertCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        WRITE_LOCK.lock();
        try {
            ServiceResponse serviceResponse = super.onInsertCallback(session, paramsObject, callback);
            return serviceResponse;
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse onQueryCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        READ_LOCK.lock();
        try {
            ServiceResponse serviceResponse = super.onQueryCallback(session, paramsObject, callback);
            return serviceResponse;
        }
        finally {
            READ_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse onUpdateCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        WRITE_LOCK.lock();
        try {
            ServiceResponse serviceResponse = super.onUpdateCallback(session, paramsObject, callback);
            return serviceResponse;
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse onDeleteCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        WRITE_LOCK.lock();
        try {
            ServiceResponse serviceResponse = super.onDeleteCallback(session, paramsObject, callback);
            return serviceResponse;
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }
}

