/*
 * Decompiled with CFR 0.152.
 */
package com.product.dao;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterConnectionMode;
import com.product.dao.AbstractMongodbDao;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public abstract class AbstractMongodbTransactionDao<T>
extends AbstractMongodbDao<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMongodbTransactionDao.class);
    @Autowired
    MongoClient mongoClient;
    @Autowired
    MongoTemplate mongoTemplate;
    private String primaryKeyName;
    private Class<T> tClass;
    private String collectionName;

    public AbstractMongodbTransactionDao(Class<T> tClass, String primaryKeyName) {
        this.primaryKeyName = primaryKeyName;
        this.tClass = tClass;
    }

    public AbstractMongodbTransactionDao(Class<T> tClass, String primaryKeyName, String collectionName) {
        this.primaryKeyName = primaryKeyName;
        this.tClass = tClass;
        this.collectionName = collectionName;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public Class<T> gettClass() {
        return this.tClass;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public T save(ClientSession session, MongoTemplate mongoTemplate, T t) {
        if (StringUtils.isNotBlank((CharSequence)this.getCollectionName())) {
            return (T)mongoTemplate.insert(t, this.getCollectionName());
        }
        return (T)mongoTemplate.insert(t);
    }

    public Collection<T> saveBatch(ClientSession session, MongoTemplate mongoTemplate, List<T> tList) {
        if (StringUtils.isNotBlank((CharSequence)this.collectionName)) {
            return mongoTemplate.insert(tList, this.collectionName);
        }
        return mongoTemplate.insert(tList, mongoTemplate.getCollectionName(this.tClass));
    }

    public T updateByPrimaryKey(ClientSession session, MongoTemplate mongoTemplate, T t, String ... updateFields) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        AbstractMongodbDao.UpdateCondition updateCondition = this.createUpdate(t, this.getPrimaryKeyName(), this.gettClass(), updateFields);
        long count = 0L;
        count = StringUtils.isNotBlank((CharSequence)this.getCollectionName()) ? mongoTemplate.updateFirst(updateCondition.getQuery(), updateCondition.getUpdateDefinition(), this.gettClass(), this.getCollectionName()).getModifiedCount() : mongoTemplate.updateFirst(updateCondition.getQuery(), updateCondition.getUpdateDefinition(), this.gettClass()).getModifiedCount();
        if (count == 1L) {
            return t;
        }
        return null;
    }

    public T updateByCompoundIndex(ClientSession session, MongoTemplate mongoTemplate, T t, String compoundIndexName, String ... updateFields) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        AbstractMongodbDao.UpdateCondition updateCondition = this.createUpdateByCompoundIndex(t, compoundIndexName, this.gettClass(), updateFields);
        long count = 0L;
        count = StringUtils.isNotBlank((CharSequence)this.getCollectionName()) ? mongoTemplate.updateFirst(updateCondition.getQuery(), updateCondition.getUpdateDefinition(), this.gettClass(), this.getCollectionName()).getModifiedCount() : mongoTemplate.updateFirst(updateCondition.getQuery(), updateCondition.getUpdateDefinition(), this.gettClass()).getModifiedCount();
        if (count == 1L) {
            return t;
        }
        return null;
    }

    public List<T> updateBatchByPrimaryKey(ClientSession session, MongoTemplate mongoTemplate, List<T> ts, String ... updateFields) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        for (T t : ts) {
            this.updateByPrimaryKey(session, mongoTemplate, t, updateFields);
        }
        return ts;
    }

    public List<T> updateBatchByCompoundIndex(ClientSession session, MongoTemplate mongoTemplate, List<T> ts, String compoundIndexName, String ... updateFields) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        for (T t : ts) {
            this.updateByCompoundIndex(session, mongoTemplate, t, compoundIndexName, updateFields);
        }
        return ts;
    }

    public long updateBatchByCompoundIndex(ClientSession session, MongoTemplate mongoTemplate, T t, String compoundIndexName, String ... updateFields) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        AbstractMongodbDao.UpdateCondition updateCondition = this.createUpdateByCompoundIndex(t, compoundIndexName, this.tClass, updateFields);
        long count = 0L;
        count = StringUtils.isNotBlank((CharSequence)this.collectionName) ? mongoTemplate.updateMulti(updateCondition.getQuery(), updateCondition.getUpdateDefinition(), this.tClass, this.collectionName).getModifiedCount() : mongoTemplate.updateMulti(updateCondition.getQuery(), updateCondition.getUpdateDefinition(), this.tClass).getModifiedCount();
        return count;
    }

    public long removeByPrimaryKey(ClientSession session, MongoTemplate mongoTemplate, Object keyValue) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)this.primaryKeyName).is(keyValue));
        if (StringUtils.isNotBlank((CharSequence)this.collectionName)) {
            return mongoTemplate.remove(query, this.collectionName).getDeletedCount();
        }
        return mongoTemplate.remove(query, this.tClass).getDeletedCount();
    }

    public void removeAll(ClientSession session, MongoTemplate mongoTemplate) {
        if (StringUtils.isNotBlank((CharSequence)this.collectionName)) {
            mongoTemplate.dropCollection(this.collectionName);
        } else {
            mongoTemplate.dropCollection(this.tClass);
        }
    }

    public long removeByCompoundIndex(ClientSession session, MongoTemplate mongoTemplate, T t, String compoundIndexName) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        Query query = this.buildQuery(t, compoundIndexName, this.tClass);
        if (StringUtils.isNotBlank((CharSequence)this.collectionName)) {
            return mongoTemplate.remove(query, this.collectionName).getDeletedCount();
        }
        return mongoTemplate.remove(query, this.tClass).getDeletedCount();
    }

    public long remove(ClientSession session, MongoTemplate mongoTemplate, Query query) {
        if (StringUtils.isNotBlank((CharSequence)this.collectionName)) {
            return mongoTemplate.remove(query, this.tClass, this.collectionName).getDeletedCount();
        }
        return mongoTemplate.remove(query, this.tClass, mongoTemplate.getCollectionName(this.tClass)).getDeletedCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mongodbTransactional(CallBack callBack) {
        Object result = null;
        if (!this.getMongoClient().getClusterDescription().getConnectionMode().equals((Object)ClusterConnectionMode.SINGLE)) {
            try (ClientSession session = this.getMongoClient().startSession();){
                session.startTransaction();
                try {
                    MongoTemplate mongoTemplate = this.getMongoTemplate().withSession(session);
                    result = callBack.execute(session, mongoTemplate);
                    session.commitTransaction();
                }
                catch (Exception e) {
                    log.error("Mongodb\u4e8b\u52a1\u5931\u8d25\u9519\u8bef\u4fe1\u606f", (Throwable)e);
                    session.abortTransaction();
                }
                finally {
                    session.close();
                }
            }
        } else {
            result = callBack.execute(null, this.getMongoTemplate());
        }
        return result;
    }

    public static interface CallBack {
        public Object execute(ClientSession var1, MongoTemplate var2);
    }
}

