/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.slice.filter.standard;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.stat.TableStat;
import com.product.model.ServiceSession;
import com.product.storage.mybatis.ReflectUtil;
import com.product.storage.slice.filter.standard.BaseSliceExecutorWrapper;
import com.product.util.DateTimeFormatUtil;
import com.product.util.SpringContext;
import com.product.util.UniqueID;
import com.zaxxer.hikari.HikariDataSource;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class ExecutorSliceNewWrapper
extends BaseSliceExecutorWrapper
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ExecutorSliceNewWrapper.class);
    public static final Logger slogLogger = LoggerFactory.getLogger((String)"slowLogger");

    private static String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = "'" + formatter.format(obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", ExecutorSliceNewWrapper.getParameterValue(parameterObject));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", ExecutorSliceNewWrapper.getParameterValue(obj));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    obj = boundSql.getAdditionalParameter(propertyName);
                    sql = sql.replaceFirst("\\?", ExecutorSliceNewWrapper.getParameterValue(obj));
                }
            }
        }
        return sql;
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sqlId, long time) {
        String sql = ExecutorSliceNewWrapper.showSql(configuration, boundSql);
        return sql;
    }

    @Override
    public boolean isIntercept(String tableName) {
        ServiceSession session = SpringContext.getSession();
        String hashKey = String.format("dbslice:tableconfig:%1$s", tableName);
        return session != null;
    }

    @Override
    public void printSlowLog(Configuration configuration, BoundSql boundSql, String sqlId, long execTime) {
        ConfigurableEnvironment environment = SpringContext.getEnvironment();
        String slowlog_limit = environment.getProperty("slowlog.limit");
        String slowlog_table = environment.getProperty("slowlog.table");
        String slowlog_redis = environment.getProperty("slowlog.redis");
        if (!StringUtils.isEmpty((Object)slowlog_limit) && !StringUtils.isEmpty((Object)slowlog_table)) {
            if (execTime < Long.valueOf(slowlog_limit)) {
                return;
            }
            String sql = ExecutorSliceNewWrapper.getSql(configuration, boundSql, sqlId, execTime);
            String[] tableArray = slowlog_table.split(",");
            if (slowlog_table.equals("*") || CollectionUtils.containsAll(Arrays.asList(tableArray), ExecutorSliceNewWrapper.getAllTableNameBySQL(sql))) {
                this.printToLogBack(execTime, sql);
                if ("true".equals(slowlog_redis)) {
                    this.insertSqlToRedis(configuration, sql, execTime);
                }
            }
        }
    }

    private void printToLogBack(long execTime, String sql) {
        slogLogger.info("# Query_time(ms): {}", (Object)execTime);
        slogLogger.info("SET timestamp={}({})", (Object)System.currentTimeMillis(), (Object)DateTimeFormatUtil.toDateTime(new Date()));
        slogLogger.info("sql:{}", (Object)sql);
        HttpServletRequest request = SpringContext.getRequest();
        slogLogger.info("--------------------- \u8bf7\u6c42\u4fe1\u606f begin --------------------- ");
        slogLogger.info(request.getAttribute("requestSession").toString());
        slogLogger.info("--------------------- \u8bf7\u6c42\u4fe1\u606f end ----------------------- ");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        boolean find = false;
        slogLogger.info("--------------------- \u5806\u6808\u4fe1\u606f begin --------------------- ");
        for (StackTraceElement ele : stackTrace) {
            if (ele.toString().contains("com.product.controller.ProductReflect.invoke")) {
                find = true;
            }
            if (find || ele.toString().contains("sun.reflect") || ele.toString().contains("java.lang") || ele.toString().contains("org.springframework.aop") || ele.toString().contains("com.product.storage.slice.filter.standard")) continue;
            slogLogger.info(ele.toString());
        }
        slogLogger.info("--------------------- \u5806\u6808\u4fe1\u606f end ---------------------");
    }

    private void insertSqlToRedis(Configuration configuration, String sql, long execTime) {
        StringRedisTemplate stringRedisTemplate = null;
        String methodName = SpringContext.getRequest().getParameter("method");
        HikariDataSource datasource = (HikariDataSource)configuration.getEnvironment().getDataSource();
        String jdbcUrl = datasource.getJdbcUrl();
        String ipAndPort = org.apache.commons.lang3.StringUtils.substringBefore((String)org.apache.commons.lang3.StringUtils.substringAfter((String)jdbcUrl, (String)"//"), (String)"/");
        String ip = org.apache.commons.lang3.StringUtils.substringBefore((String)ipAndPort, (String)":");
        String port = org.apache.commons.lang3.StringUtils.substringAfter((String)ipAndPort, (String)":");
        String user = datasource.getUsername();
        String password = datasource.getPassword();
        String dbName = datasource.getPoolName();
        dbName = org.apache.commons.lang3.StringUtils.substringAfter((String)dbName, (String)"-");
        final String sqlId = String.valueOf(UniqueID.getUniqueID());
        final HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", sqlId);
        dataMap.put("ip", ip);
        dataMap.put("port", port);
        dataMap.put("username", user);
        dataMap.put("password", password);
        dataMap.put("dbCode", ip + "-" + dbName);
        dataMap.put("databaseName", dbName);
        dataMap.put("methodName", methodName);
        dataMap.put("slowSql", sql);
        dataMap.put("execTime", String.valueOf(execTime));
        dataMap.put("createDate", DateTimeFormatUtil.toDateTime(new Date()));
        stringRedisTemplate = (StringRedisTemplate)SpringContext.getBean(StringRedisTemplate.class, null);
        List list = (List)stringRedisTemplate.execute((SessionCallback)new SessionCallback<List<Object>>(){

            public List<Object> execute(RedisOperations operations) throws DataAccessException {
                operations.multi();
                operations.boundListOps((Object)"slowsql:queue").leftPush((Object)sqlId);
                operations.boundHashOps((Object)("slowsql:" + sqlId)).putAll(dataMap);
                operations.expire((Object)("slowsql:" + sqlId), 48L, TimeUnit.HOURS);
                return operations.exec();
            }
        });
    }

    private static List<String> getAllTableNameBySQL(String sql) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        SQLStatement sqlStatement = parser.parseStatement();
        MySqlSchemaStatVisitor visitor = new MySqlSchemaStatVisitor();
        sqlStatement.accept((SQLASTVisitor)visitor);
        Map tables = visitor.getTables();
        ArrayList<String> allTableName = new ArrayList<String>();
        for (TableStat.Name t : tables.keySet()) {
            allTableName.add(t.getName());
        }
        return allTableName;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dbType = properties.getProperty("dbType");
        if (dbType == null || dbType.equals("")) {
            this.setDbType("mysql");
        } else {
            this.setDbType(dbType);
        }
    }

    @Override
    public String getWhere(String collectionName, String collectionAlias) {
        String sliceCode;
        String response = "";
        String tableName = collectionName;
        if (ExecutorSliceNewWrapper.isTableWrapper(tableName) && !StringUtils.isEmpty((Object)(sliceCode = this.getSliceCode(tableName)))) {
            String fieldName = (String)COLLECTION_MAP.get(tableName);
            response = !StringUtils.isEmpty((Object)collectionAlias) ? String.format("%1$s.%2$s = '%3$s'", collectionAlias, fieldName, sliceCode) : String.format("%1$s = '%2$s'", fieldName, sliceCode);
        }
        return response;
    }

    public String getSliceCode(String rule, ServiceSession session) {
        String[] str = rule.split(":");
        String fieldName = null;
        String sessionFieldName = null;
        if (!StringUtils.isEmpty((Object)str) && str.length == 1) {
            fieldName = str[0];
            sessionFieldName = str[0];
        } else if (!StringUtils.isEmpty((Object)str) && str.length == 2) {
            fieldName = str[0];
            sessionFieldName = str[1];
        }
        Object value = ReflectUtil.getFieldValue(session, sessionFieldName);
        String keyValue = sessionFieldName + ":" + value;
        if (ORGANIZATION_MAP.containsKey(keyValue)) {
            return (String)ORGANIZATION_MAP.get(keyValue);
        }
        return null;
    }

    @Override
    public String getSliceCode(String tableName) {
        String rule = (String)RULE_MAP.get(tableName);
        return this.getSliceCode(rule, SpringContext.getSession());
    }
}

