/*
 * Decompiled with CFR 0.152.
 */
package com.product.component.isce;

import com.alibaba.fastjson.JSONObject;
import com.product.component.MasterSlaveComponentServiceImpl;
import com.product.component.globrule.GlobRuleSrv;
import com.product.component.isce.BillComponentService;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.model.isce.BaseSheetHeadModel;
import com.product.util.SpringContext;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.GenericTypeResolver;
import org.springframework.util.StringUtils;

public class BillComponentServiceImpl<X>
extends MasterSlaveComponentServiceImpl<X>
implements BillComponentService {
    final Class<X> masterClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), BillComponentServiceImpl.class);

    public BillComponentServiceImpl(String[] slaveServiceNames) {
        super(slaveServiceNames);
    }

    @Override
    public void onBeforeInsert(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"sheetid") || StringUtils.isEmpty((Object)paramsObject.get((Object)"sheetid"))) {
            try {
                String sheetId = this.getSheetId(session, paramsObject);
                paramsObject.put("sheetid", (Object)sheetId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceRuntimeException("\u751f\u6210\u5355\u636e\u7f16\u53f7\u5931\u8d25");
            }
        }
    }

    @Override
    public void onAfterInsert(ServiceSession session, JSONObject paramsObject) {
    }

    @Override
    public void onBeforeSave(ServiceSession session, JSONObject paramsObject) {
        if ((!paramsObject.containsKey((Object)"sheetid") || StringUtils.isEmpty((Object)paramsObject.get((Object)"sheetid"))) && this.getModelFlag(paramsObject).equals("I")) {
            try {
                String sheetId = this.getSheetId(session, paramsObject);
                paramsObject.put("sheetid", (Object)sheetId);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServiceRuntimeException("\u751f\u6210\u5355\u636e\u7f16\u53f7\u5931\u8d25");
            }
        }
    }

    @Override
    public void onAfterSave(ServiceSession session, JSONObject jsonparam) {
    }

    @Override
    public void onBeforeDelete(ServiceSession session, JSONObject paramsObject) {
    }

    @Override
    public void onAfterDelete(ServiceSession session, JSONObject paramsObject) {
    }

    @Override
    public String getSheetId(ServiceSession session, JSONObject jsonparam) throws Exception {
        GlobRuleSrv globRuleSrv = (GlobRuleSrv)SpringContext.getContext().getBean(GlobRuleSrv.class);
        String sheetid = globRuleSrv.getSheetId(session, jsonparam);
        return sheetid;
    }

    @Override
    public ServiceResponse generateSheetId(ServiceSession session, JSONObject jsonparam) throws Exception {
        String sheetid = this.getSheetId(session, jsonparam);
        JSONObject rtnObject = new JSONObject();
        rtnObject.put("sheetid", (Object)sheetid);
        return ServiceResponse.buildSuccess((Object)rtnObject);
    }

    public void onBeforeAudit(BaseSheetHeadModel bean) {
    }

    public Set<String> onAudit(BaseSheetHeadModel bean) {
        return null;
    }

    public void onAfterAudit(BaseSheetHeadModel bean) {
    }

    @Override
    public ServiceResponse audit(List<Long> ids) throws Exception {
        if (ids == null || ids.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)SpringContext.getSession(), (String)"10000", (String)"\u5355\u636eID\u4e3a\u7a7a\uff01");
        }
        for (Long id : ids) {
            this.audit(id);
        }
        return ServiceResponse.buildSuccess((Object)"\u5ba1\u6838\u6210\u529f");
    }

    @Override
    public ServiceResponse audit(Long id) throws Exception {
        BaseSheetHeadModel bean = (BaseSheetHeadModel)this.viewWithBean(id);
        if (StringUtils.isEmpty((Object)bean) || StringUtils.isEmpty((Object)bean.getSheetid())) {
            throw new ServiceRuntimeException("\u5355\u636esheetid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.validateBillAudit(bean);
        this.onBeforeAudit(bean);
        Set<String> keys = this.onAudit(bean);
        if (keys == null) {
            keys = new HashSet<String>();
        }
        this.changeBillAuditFlag(bean, keys);
        this.onAfterAudit(bean);
        return ServiceResponse.buildSuccess((Object)String.format("\u5355\u636e\u7f16\u53f7%1$s\u5ba1\u6838\u6210\u529f", bean.getSheetid()));
    }

    @Override
    public ServiceResponse invalid(List<Long> ids) throws Exception {
        if (ids == null || ids.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)SpringContext.getSession(), (String)"10000", (String)"\u5355\u636eID\u4e3a\u7a7a\uff01");
        }
        for (Long id : ids) {
            this.invalid(id);
        }
        return ServiceResponse.buildSuccess((Object)"\u53d6\u6d88\u6210\u529f");
    }

    @Override
    public ServiceResponse invalid(Long id) throws Exception {
        BaseSheetHeadModel bean = (BaseSheetHeadModel)this.viewWithBean(id);
        if (StringUtils.isEmpty((Object)bean) || StringUtils.isEmpty((Object)bean.getSheetid())) {
            throw new ServiceRuntimeException("\u5355\u636esheetid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        this.validateBillInvalid(bean);
        this.onBeforeInvalid(bean);
        Set<String> keys = this.onInvalid(bean);
        if (keys == null) {
            keys = new HashSet<String>();
        }
        this.changeBillInvalidFlag(bean, keys);
        this.onAfterInvalid(bean);
        return ServiceResponse.buildSuccess((Object)String.format("\u5355\u636e\u7f16\u53f7%1$s\u53d6\u6d88\u6210\u529f", bean.getSheetid()));
    }

    public void validateBillAudit(BaseSheetHeadModel bean) {
        if (bean.getFlag() == 99) {
            throw new ServiceRuntimeException(String.format("\u5355\u636e[%1$s]\u5df2\u4f5c\u5e9f\uff01", bean.getSheetid()));
        }
        if (bean.getFlag() == 100) {
            throw new ServiceRuntimeException(String.format("\u5355\u636e[%1$s]\u5df2\u5ba1\u6838\uff01", bean.getSheetid()));
        }
    }

    public void validateBillInvalid(BaseSheetHeadModel bean) {
        if (bean.getFlag() == 99) {
            throw new ServiceRuntimeException(String.format("\u5355\u636e[%1$s]\u5df2\u53d6\u6d88\uff01", bean.getSheetid()));
        }
    }

    public void onBeforeInvalid(BaseSheetHeadModel bean) {
    }

    public Set<String> onInvalid(BaseSheetHeadModel bean) {
        return null;
    }

    public void onAfterInvalid(BaseSheetHeadModel bean) {
    }

    public void changeBillFlag(BaseSheetHeadModel bean, Set<String> keys, Integer flag) {
        bean.setChecker(SpringContext.getSession().getUser_code());
        bean.setCheckdate(new Date());
        bean.setFlag(flag);
        keys.add("flag");
        keys.add("checker");
        keys.add("checkdate");
        this.onUpdateBean(bean, keys);
    }

    public void changeBillInvalidFlag(BaseSheetHeadModel bean, Set<String> keys) {
        this.changeBillFlag(bean, keys, 99);
    }

    public void changeBillAuditFlag(BaseSheetHeadModel bean, Set<String> keys) {
        this.changeBillFlag(bean, keys, 100);
    }
}

